/*
 * Decompiled with CFR 0.152.
 */
package net.barribob.maelstrom.general;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001f\u0012\u0018\u0010\u0003\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\u0010\u001a\u0004\u0018\u00018\u00002\u0006\u0010\u0011\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0011\u001a\u00020\n\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0016\u001a\u00020\u0006J\u001b\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0019R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00060\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0006`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0003\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR*\u0010\u000e\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n0\tj\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u00000\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00028\u0000`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lnet/barribob/maelstrom/general/IdRegistry;", "T", "", "idProvider", "Lkotlin/Function1;", "", "", "(Lkotlin/jvm/functions/Function1;)V", "idMap", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "getIdProvider", "()Lkotlin/jvm/functions/Function1;", "nameMap", "objects", "get", "name", "(Ljava/lang/String;)Ljava/lang/Object;", "getIdFromName", "(Ljava/lang/String;)Ljava/lang/Integer;", "getNameFromId", "id", "register", "obj", "(Ljava/lang/String;Ljava/lang/Object;)I", "maelstrom-library"})
public final class IdRegistry<T> {
    @NotNull
    private final Function1<Collection<Integer>, Integer> idProvider;
    @NotNull
    private final HashMap<String, Integer> idMap;
    @NotNull
    private final HashMap<Integer, String> nameMap;
    @NotNull
    private final HashMap<String, T> objects;

    public IdRegistry(@NotNull Function1<? super Collection<Integer>, Integer> idProvider) {
        Intrinsics.checkNotNullParameter(idProvider, (String)"idProvider");
        this.idProvider = idProvider;
        this.idMap = new HashMap();
        this.nameMap = new HashMap();
        this.objects = new HashMap();
    }

    @NotNull
    public final Function1<Collection<Integer>, Integer> getIdProvider() {
        return this.idProvider;
    }

    public final int register(@NotNull String name, T obj) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Object object = this.idMap.values();
        Intrinsics.checkNotNullExpressionValue(object, (String)"idMap.values");
        int id = ((Number)this.idProvider.invoke(object)).intValue();
        object = this.idMap;
        Integer n = id;
        object.put(name, n);
        object = this.nameMap;
        n = id;
        object.put(n, name);
        ((Map)this.objects).put(name, obj);
        return id;
    }

    @Nullable
    public final Integer getIdFromName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.idMap.get(name);
    }

    @Nullable
    public final String getNameFromId(int id) {
        return this.nameMap.get(id);
    }

    @Nullable
    public final T get(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.objects.get(name);
    }
}

