/*
 * Decompiled with CFR 0.152.
 */
package me.steven.indrev.blockentities.generators;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.reflect.KProperty;
import me.steven.indrev.api.machines.Tier;
import me.steven.indrev.blockentities.BaseBlockEntity;
import me.steven.indrev.blockentities.Syncable;
import me.steven.indrev.blockentities.generators.GeneratorBlockEntity;
import me.steven.indrev.components.FluidComponent;
import me.steven.indrev.components.GuiSyncableComponentKt;
import me.steven.indrev.components.SyncableObject;
import me.steven.indrev.components.TemperatureComponent;
import me.steven.indrev.config.GeneratorConfig;
import me.steven.indrev.gui.properties.IntSyncableProperty;
import me.steven.indrev.inventories.IRInventoryDSL;
import me.steven.indrev.inventories.IRInventoryDSLKt;
import me.steven.indrev.registry.MachineRegistry;
import me.steven.indrev.utils.FluidutilsKt;
import me.steven.indrev.utils.IRFluidTank;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3612;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 $2\u00020\u0001:\u0001$B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001eJ\b\u0010\u001f\u001a\u00020\u001cH\u0016J\b\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010#\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R+\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR+\u0010\u0012\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n8B@BX\u0082\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0015\u0010\u0011\u001a\u0004\b\u0013\u0010\r\"\u0004\b\u0014\u0010\u000f\u00a8\u0006%"}, d2={"Lme/steven/indrev/blockentities/generators/HeatGeneratorBlockEntity;", "Lme/steven/indrev/blockentities/generators/GeneratorBlockEntity;", "tier", "Lme/steven/indrev/api/machines/Tier;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/BlockState;", "(Lme/steven/indrev/api/machines/Tier;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)V", "<set-?>", "", "burnTime", "getBurnTime", "()I", "setBurnTime", "(I)V", "burnTime$delegate", "Lme/steven/indrev/gui/properties/IntSyncableProperty;", "maxBurnTime", "getMaxBurnTime", "setMaxBurnTime", "maxBurnTime$delegate", "fromClientTag", "", "tag", "Lnet/minecraft/nbt/NbtCompound;", "fromTag", "getConsumptionRate", "", "temperature", "", "getGenerationRatio", "shouldGenerate", "", "toClientTag", "toTag", "Companion", "indrev"})
public final class HeatGeneratorBlockEntity
extends GeneratorBlockEntity {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final IntSyncableProperty burnTime$delegate;
    @NotNull
    private final IntSyncableProperty maxBurnTime$delegate;
    public static final int TANK_ID = 4;
    public static final int GENERATION_RATIO_ID = 5;
    public static final int CONSUMPTION_RATIO_ID = 6;

    public HeatGeneratorBlockEntity(@NotNull Tier tier, @NotNull class_2338 pos, @NotNull class_2680 state) {
        Intrinsics.checkNotNullParameter((Object)((Object)tier), (String)"tier");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(tier, MachineRegistry.Companion.getHEAT_GENERATOR_REGISTRY(), pos, state);
        this.burnTime$delegate = GuiSyncableComponentKt.autosync$default((BaseBlockEntity)this, 4, 0, null, 4, null);
        this.maxBurnTime$delegate = GuiSyncableComponentKt.autosync$default((BaseBlockEntity)this, 5, 0, null, 4, null);
        this.setTemperatureComponent(new TemperatureComponent(this, 0.8, new IntRange(7000, 9000), 10000));
        this.setInventoryComponent(IRInventoryDSLKt.inventory(this, (Function1<? super IRInventoryDSL, Unit>)((Function1)1.INSTANCE)));
        this.setFluidComponent(new FluidComponent((Function0)new Function0<Syncable>(){

            @NotNull
            public final Syncable invoke() {
                return this;
            }
        }, FluidutilsKt.getBucket() * (long)4, 0, 4, null));
        FluidComponent fluidComponent2 = this.getFluidComponent();
        Intrinsics.checkNotNull((Object)((Object)fluidComponent2));
        int[] nArray = new int[]{0};
        fluidComponent2.setInputTanks(nArray);
        BaseBlockEntity baseBlockEntity = this;
        FluidComponent fluidComponent3 = this.getFluidComponent();
        Intrinsics.checkNotNull((Object)((Object)fluidComponent3));
        GuiSyncableComponentKt.trackObject(baseBlockEntity, 4, (SyncableObject)fluidComponent3.get(0));
        GuiSyncableComponentKt.trackLong(this, 5, (Function0<Long>)((Function0)new Function0<Long>(){

            @NotNull
            public final Long invoke() {
                return this.getGenerationRatio();
            }
        }));
        GuiSyncableComponentKt.trackLong(this, 6, (Function0<Long>)((Function0)new Function0<Long>(){

            @NotNull
            public final Long invoke() {
                return HeatGeneratorBlockEntity.getConsumptionRate$default(this, 0.0, 1, null);
            }
        }));
    }

    private final int getBurnTime() {
        return ((Number)this.burnTime$delegate.getValue(this, $$delegatedProperties[0])).intValue();
    }

    private final void setBurnTime(int n) {
        this.burnTime$delegate.setValue(this, $$delegatedProperties[0], n);
    }

    private final int getMaxBurnTime() {
        return ((Number)this.maxBurnTime$delegate.getValue(this, $$delegatedProperties[1])).intValue();
    }

    private final void setMaxBurnTime(int n) {
        this.maxBurnTime$delegate.setValue(this, $$delegatedProperties[1], n);
    }

    @Override
    public boolean shouldGenerate() {
        if (this.getBurnTime() > 0) {
            int n = this.getBurnTime();
            this.setBurnTime(n + -1);
        } else if (this.getCapacity() > this.getEnergy$indrev()) {
            FluidComponent fluidComponent2 = this.getFluidComponent();
            Intrinsics.checkNotNull((Object)((Object)fluidComponent2));
            IRFluidTank tank2 = fluidComponent2.get(0);
            long consume = HeatGeneratorBlockEntity.getConsumptionRate$default(this, 0.0, 1, null);
            if (((FluidVariant)tank2.variant).isOf((Object)class_3612.field_15908) && tank2.tryExtract(consume)) {
                this.setBurnTime(10);
                this.setMaxBurnTime(this.getBurnTime());
                tank2.extract(consume, true);
            }
            this.method_5431();
        }
        return this.getBurnTime() > 0 && this.getEnergy$indrev() < this.getCapacity();
    }

    @Override
    public long getGenerationRatio() {
        double d = ((GeneratorConfig)this.getConfig()).getRatio();
        TemperatureComponent temperatureComponent = this.getTemperatureComponent();
        Intrinsics.checkNotNull((Object)temperatureComponent);
        double d2 = temperatureComponent.getTemperature();
        TemperatureComponent temperatureComponent2 = this.getTemperatureComponent();
        Intrinsics.checkNotNull((Object)temperatureComponent2);
        return (long)(d * RangesKt.coerceAtMost((double)(d2 / (double)temperatureComponent2.getOptimalRange().getFirst()), (double)1.0));
    }

    public final long getConsumptionRate(double temperature) {
        TemperatureComponent temperatureComponent = this.getTemperatureComponent();
        Intrinsics.checkNotNull((Object)temperatureComponent);
        return (long)(RangesKt.coerceIn((double)(temperature / (double)temperatureComponent.getOptimalRange().getFirst()), (double)0.001, (double)1.0) * (double)810);
    }

    public static /* synthetic */ long getConsumptionRate$default(HeatGeneratorBlockEntity heatGeneratorBlockEntity, double d, int n, Object object) {
        if ((n & 1) != 0) {
            TemperatureComponent temperatureComponent = heatGeneratorBlockEntity.getTemperatureComponent();
            Intrinsics.checkNotNull((Object)temperatureComponent);
            d = temperatureComponent.getTemperature();
        }
        return heatGeneratorBlockEntity.getConsumptionRate(d);
    }

    @Override
    public void fromTag(@NotNull class_2487 tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        super.fromTag(tag);
        this.setBurnTime(tag.method_10550("BurnTime"));
        this.setMaxBurnTime(tag.method_10550("MaxBurnTime"));
    }

    @Override
    public void toTag(@NotNull class_2487 tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        tag.method_10569("BurnTime", this.getBurnTime());
        tag.method_10569("MaxBurnTime", this.getMaxBurnTime());
        super.toTag(tag);
    }

    @Override
    public void toClientTag(@NotNull class_2487 tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        FluidComponent fluidComponent2 = this.getFluidComponent();
        Intrinsics.checkNotNull((Object)((Object)fluidComponent2));
        fluidComponent2.toTag(tag);
    }

    @Override
    public void fromClientTag(@NotNull class_2487 tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        FluidComponent fluidComponent2 = this.getFluidComponent();
        Intrinsics.checkNotNull((Object)((Object)fluidComponent2));
        fluidComponent2.fromTag(tag);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(HeatGeneratorBlockEntity.class, "burnTime", "getBurnTime()I", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(HeatGeneratorBlockEntity.class, "maxBurnTime", "getMaxBurnTime()I", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lme/steven/indrev/blockentities/generators/HeatGeneratorBlockEntity$Companion;", "", "()V", "CONSUMPTION_RATIO_ID", "", "GENERATION_RATIO_ID", "TANK_ID", "indrev"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

