/*
 * Decompiled with CFR 0.152.
 */
package me.steven.indrev;

import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public abstract class IREnergyStorage
extends SnapshotParticipant<Long> {
    private final SideStorage[] sideStorages = new SideStorage[7];

    public IREnergyStorage() {
        for (int i = 0; i < 7; ++i) {
            this.sideStorages[i] = new SideStorage(i == 6 ? null : class_2350.method_10143((int)i));
        }
    }

    public abstract long getCapacity();

    public abstract long getMaxInsert(@Nullable class_2350 var1);

    public abstract long getMaxExtract(@Nullable class_2350 var1);

    public EnergyStorage getSideStorage(@Nullable class_2350 side) {
        return this.sideStorages[side == null ? 6 : side.method_10146()];
    }

    public long getAmount() {
        return 0L;
    }

    public void setAmount(long v) {
    }

    protected Long createSnapshot() {
        return this.getAmount();
    }

    protected void readSnapshot(Long snapshot) {
        this.setAmount(snapshot);
    }

    private class SideStorage
    implements EnergyStorage {
        private final class_2350 side;

        private SideStorage(class_2350 side) {
            this.side = side;
        }

        public boolean supportsInsertion() {
            return IREnergyStorage.this.getMaxInsert(this.side) > 0L;
        }

        public long insert(long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notNegative((long)maxAmount);
            long inserted = Math.min(IREnergyStorage.this.getMaxInsert(this.side), Math.min(maxAmount, this.getCapacity() - this.getAmount()));
            if (inserted > 0L) {
                IREnergyStorage.this.updateSnapshots(transaction);
                IREnergyStorage.this.setAmount(this.getAmount() + inserted);
                return inserted;
            }
            return 0L;
        }

        public boolean supportsExtraction() {
            return IREnergyStorage.this.getMaxExtract(this.side) > 0L;
        }

        public long extract(long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notNegative((long)maxAmount);
            long extracted = Math.min(IREnergyStorage.this.getMaxExtract(this.side), Math.min(maxAmount, this.getAmount()));
            if (extracted > 0L) {
                IREnergyStorage.this.updateSnapshots(transaction);
                IREnergyStorage.this.setAmount(this.getAmount() - extracted);
                return extracted;
            }
            return 0L;
        }

        public long getAmount() {
            return IREnergyStorage.this.getAmount();
        }

        public long getCapacity() {
            return IREnergyStorage.this.getCapacity();
        }
    }
}

