/*
 * Decompiled with CFR 0.152.
 */
package dev.fulmineo.guild.screen;

import com.google.common.collect.ImmutableList;
import dev.fulmineo.guild.Guild;
import dev.fulmineo.guild.data.Quest;
import dev.fulmineo.guild.data.QuestHelper;
import dev.fulmineo.guild.data.QuestProfession;
import dev.fulmineo.guild.network.ClientNetworkManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class QuestsScreenHandler
extends class_1703 {
    public Map<String, List<Quest>> availableQuests;
    public List<Quest> acceptedQuests;
    public List<QuestProfession> professions;
    public Map<String, ProfessionData> professionsData;
    public int maxAcceptedQuests;
    public class_1937 world;
    private class_1661 playerInventory;

    public QuestsScreenHandler(int syncId, class_1661 playerInventory, class_2540 buf) {
        this(syncId, playerInventory);
        class_2487 nbt = buf.method_10798();
        this.availableQuests = QuestHelper.fromMapNbt(nbt);
        this.acceptedQuests = QuestHelper.fromNbt(nbt);
        this.professions = new ArrayList<QuestProfession>();
        this.professionsData = new HashMap<String, ProfessionData>();
        class_2499 professionsInfo = nbt.method_10554("Professions", 10);
        for (class_2520 entry : professionsInfo) {
            class_2487 professionInfo = (class_2487)entry;
            QuestProfession profession = new QuestProfession();
            profession.name = professionInfo.method_10558("Name");
            profession.icon = professionInfo.method_10558("Icon");
            ProfessionData data = new ProfessionData();
            data.exp = professionInfo.method_10550("Exp");
            data.level = professionInfo.method_10550("Level");
            data.levelPerc = professionInfo.method_10550("LevelPerc");
            this.professions.add(profession);
            this.professionsData.put(profession.name, data);
        }
        this.maxAcceptedQuests = nbt.method_10550("MaxAcceptedQuests");
        this.world = playerInventory.field_7546.field_6002;
        this.playerInventory = playerInventory;
        this.updateItemCompletion();
    }

    public QuestsScreenHandler(int syncId, class_1661 playerInventory) {
        super(Guild.QUESTS_SCREEN_HANDLER, syncId);
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public void acceptQuest(String profession, int index) {
        List<Quest> professionsQuest = this.availableQuests.get(profession);
        if (professionsQuest == null || professionsQuest.size() <= index) {
            return;
        }
        Quest quest = professionsQuest.remove(index);
        quest.accept(this.world.method_8510());
        this.acceptedQuests.add(quest);
        ClientNetworkManager.acceptQuest(profession, index);
        this.updateItemCompletion();
    }

    @Environment(value=EnvType.CLIENT)
    public void tryCompleteQuest(int index) {
        class_2540 buf = PacketByteBufs.create();
        buf.writeInt(index);
        ClientPlayNetworking.registerReceiver((class_2960)Guild.TRY_COMPLETE_QUEST_PACKET_ID, (client, player, buffer, responseSender) -> {
            if (buffer.readBoolean()) {
                Quest quest = this.acceptedQuests.remove(index);
                class_2487 nbt = buffer.method_10798();
                ProfessionData data = this.professionsData.get(quest.getProfessionName());
                if (data != null) {
                    data.exp = nbt.method_10550("Exp");
                    data.level = nbt.method_10550("Level");
                    data.levelPerc = nbt.method_10550("LevelPerc");
                }
                this.updateItemCompletion();
            }
            ClientPlayNetworking.unregisterReceiver((class_2960)Guild.TRY_COMPLETE_QUEST_PACKET_ID);
        });
        ClientPlayNetworking.send((class_2960)Guild.TRY_COMPLETE_QUEST_PACKET_ID, (class_2540)buf);
    }

    @Environment(value=EnvType.CLIENT)
    public void deleteAcceptedQuest(int index) {
        ClientNetworkManager.deleteAcceptedQuest(this.acceptedQuests, index);
    }

    @Environment(value=EnvType.CLIENT)
    public void deleteAvailableQuest(String profession, int index) {
        ClientNetworkManager.deleteAvailableQuest(this.availableQuests, profession, index);
    }

    private void updateItemCompletion() {
        HashMap<String, ArrayList<class_1799>> itemsById = new HashMap<String, ArrayList<class_1799>>();
        ImmutableList mainAndOffhand = ImmutableList.of((Object)this.playerInventory.field_7547, (Object)this.playerInventory.field_7544);
        for (class_2371 defaultedList : mainAndOffhand) {
            for (int i = 0; i < defaultedList.size(); ++i) {
                class_1799 stack = (class_1799)defaultedList.get(i);
                if (stack.method_31574(class_1802.field_8162)) continue;
                String id = class_2378.field_11142.method_10221((Object)stack.method_7909()).toString();
                ArrayList<class_1799> list = (ArrayList<class_1799>)itemsById.get(id);
                if (list == null) {
                    list = new ArrayList<class_1799>();
                }
                list.add(stack);
                itemsById.put(id, list);
            }
        }
        for (Quest quest : this.acceptedQuests) {
            class_2499 items = quest.getItemList();
            for (class_2520 elm : items) {
                class_2487 entry = (class_2487)elm;
                String item = entry.method_10558("Name");
                List list = (List)itemsById.get(item);
                int count = 0;
                if (list != null) {
                    int needed = entry.method_10550("Needed");
                    for (class_1799 stack : list) {
                        if (entry.method_10545("Tag") && !Quest.matchesNbt(stack.method_7948(), entry.method_10562("Tag")) || (count += stack.method_7947()) < needed) continue;
                        count = needed;
                        break;
                    }
                }
                entry.method_10569("Count", count);
            }
            quest.updateTasksAndRewards();
        }
    }

    public class ProfessionData {
        public int exp;
        public int level;
        public int levelPerc;
    }
}

