/*
 * Decompiled with CFR 0.152.
 */
package dev.fulmineo.guild.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.fulmineo.guild.Guild;
import dev.fulmineo.guild.data.Quest;
import dev.fulmineo.guild.data.QuestProfession;
import dev.fulmineo.guild.screen.QuestsScreenHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_757;

public class QuestsScreen
extends class_465<QuestsScreenHandler> {
    private static final class_2960 TEXTURE = new class_2960("guild", "textures/gui/container/guild.png");
    private ProfessionButton[] professions = new ProfessionButton[7];
    private List<QuestButton> available = new ArrayList<QuestButton>();
    private List<QuestButton> accepted = new ArrayList<QuestButton>();
    private List<Quest> professionQuests = new ArrayList<Quest>();
    int indexStartOffset;
    private String professionName;
    private QuestsScreenHandler.ProfessionData professionData;
    private boolean deleteMode;

    public QuestsScreen(QuestsScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.field_22792 = false;
        this.field_2792 = 276;
        this.field_2779 = 200;
        this.field_25268 = 4;
    }

    protected void method_25426() {
        super.method_25426();
        int w = (this.field_22789 - this.field_2792) / 2;
        int h = (this.field_22790 - this.field_2779) / 2;
        this.method_37063((class_364)new InfoButton(w + 6, h + 16, button -> {}));
        this.method_37063((class_364)new class_4185(w + this.field_2792 - 56, h + 16, 50, 20, (class_2561)new class_2588("button.guild.quest.delete"), button -> {
            this.deleteMode = !this.deleteMode;
            button.method_25355((class_2561)(this.deleteMode ? new class_2588("button.guild.quest.cancel") : new class_2588("button.guild.quest.delete")));
            for (int i = 0; i < this.available.size(); ++i) {
                this.available.get((int)i).field_22763 = this.deleteMode ? true : ((QuestsScreenHandler)this.field_2797).acceptedQuests.size() < ((QuestsScreenHandler)this.field_2797).maxAcceptedQuests;
            }
        }));
        int y = h + 41;
        int profNum = ((QuestsScreenHandler)this.field_2797).professions.size();
        int x = this.field_22789 / 2 - (profNum * 20 + (profNum - 1) * 2) / 2;
        for (int i = 0; i < profNum; ++i) {
            this.professions[i] = (ProfessionButton)this.method_37063((class_364)new ProfessionButton(x, y - 25, i, button -> {
                if (!button.field_22763) {
                    return;
                }
                this.selectProfession(((ProfessionButton)button).index);
            }));
            x += 22;
        }
        if (((QuestsScreenHandler)this.field_2797).professions.size() > 0) {
            this.selectProfession(0);
        }
    }

    private void initButtons() {
        QuestButton btn;
        int i;
        int w = (this.field_22789 - this.field_2792) / 2;
        int h = (this.field_22790 - this.field_2779) / 2;
        int y = h + 52;
        for (i = 0; i < ((QuestsScreenHandler)this.field_2797).professions.size(); ++i) {
            this.professions[i].field_22763 = ((QuestsScreenHandler)this.field_2797).professions.get((int)i).name != this.professionName;
        }
        for (i = 0; i < this.available.size(); ++i) {
            this.method_37066((class_364)this.available.get(i));
        }
        for (i = 0; i < this.accepted.size(); ++i) {
            this.method_37066((class_364)this.accepted.get(i));
        }
        this.available.clear();
        this.accepted.clear();
        for (i = 0; i < this.professionQuests.size(); ++i) {
            this.professionQuests.get(i).updateTasksAndRewards();
            this.field_22788.field_4730 = 0.0f;
            btn = (AvailableQuestButton)this.method_37063((class_364)new AvailableQuestButton(w + 6, y, i, button -> {
                int index = ((AvailableQuestButton)button).index;
                if (this.deleteMode) {
                    ((QuestsScreenHandler)this.field_2797).deleteAvailableQuest(this.professionName, index);
                } else {
                    if (!button.field_22763 || ((QuestsScreenHandler)this.field_2797).acceptedQuests.size() == ((QuestsScreenHandler)this.field_2797).maxAcceptedQuests) {
                        return;
                    }
                    ((QuestsScreenHandler)this.field_2797).acceptQuest(this.professionName, index);
                    this.professionQuests = ((QuestsScreenHandler)this.field_2797).availableQuests.get(this.professionName);
                }
                this.initButtons();
            }));
            btn.field_22763 = ((QuestsScreenHandler)this.field_2797).acceptedQuests.size() < ((QuestsScreenHandler)this.field_2797).maxAcceptedQuests;
            this.available.add(btn);
            y += 20;
        }
        y = h + 52;
        for (i = 0; i < ((QuestsScreenHandler)this.field_2797).acceptedQuests.size(); ++i) {
            ((QuestsScreenHandler)this.field_2797).acceptedQuests.get(i).updateTasksAndRewards();
            btn = (AcceptedQuestButton)this.method_37063((class_364)new AcceptedQuestButton(w + 143, y, i, button -> {
                int index = ((AcceptedQuestButton)button).index;
                if (this.deleteMode) {
                    ((QuestsScreenHandler)this.field_2797).deleteAcceptedQuest(index);
                } else if (((QuestsScreenHandler)this.field_2797).acceptedQuests.size() > index) {
                    ((QuestsScreenHandler)this.field_2797).tryCompleteQuest(index);
                }
                this.initButtons();
            }));
            this.accepted.add(btn);
            y += 20;
        }
    }

    protected void method_2388(class_4587 matrices, int mouseX, int mouseY) {
        float x = (70 - this.field_22793.method_27525((class_5348)this.field_22785)) / 2;
        this.field_22793.method_30883(matrices, this.field_22785, x, (float)this.field_25268, 0x404040);
        this.field_22793.method_30883(matrices, (class_2561)new class_2588("screen.guild.quests.available"), 6.0f, 40.0f, 0x404040);
        class_2588 accepted = new class_2588("screen.guild.quests.accepted");
        this.field_22793.method_30883(matrices, (class_2561)accepted, (float)(this.field_2792 - 6 - this.field_22793.method_27525((class_5348)accepted)), 40.0f, 0x404040);
    }

    protected void method_2389(class_4587 matrices, float delta, int mouseX, int mouseY) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        QuestsScreen.method_25291((class_4587)matrices, (int)this.field_2776, (int)this.field_2800, (int)this.method_25305(), (float)0.0f, (float)0.0f, (int)this.field_2792, (int)this.field_2779, (int)512, (int)256);
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        super.method_25394(matrices, mouseX, mouseY, delta);
        this.method_2380(matrices, mouseX, mouseY);
        int i = (this.field_22789 - this.field_2792) / 2;
        int j = (this.field_22790 - this.field_2779) / 2;
        this.drawLevelInfo(matrices, i, j);
    }

    private void drawLevelInfo(class_4587 matrices, int x, int y) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        QuestsScreen.method_25291((class_4587)matrices, (int)(x + 85), (int)(y + 44), (int)this.method_25305(), (float)0.0f, (float)216.0f, (int)102, (int)5, (int)512, (int)256);
        QuestsScreen.method_25291((class_4587)matrices, (int)(x + 85), (int)(y + 44), (int)this.method_25305(), (float)0.0f, (float)221.0f, (int)(this.professionData.levelPerc + 1), (int)5, (int)512, (int)256);
        int tx = x + 138;
        int ty = y + 38;
        String val = String.valueOf(this.professionData.level + 1);
        this.field_22793.method_1729(matrices, val, (float)((tx -= this.field_22793.method_1727(val) / 2) + 1), (float)ty, 0);
        this.field_22793.method_1729(matrices, val, (float)(tx - 1), (float)ty, 0);
        this.field_22793.method_1729(matrices, val, (float)tx, (float)(ty + 1), 0);
        this.field_22793.method_1729(matrices, val, (float)tx, (float)(ty - 1), 0);
        this.field_22793.method_1729(matrices, val, (float)tx, (float)ty, 8453920);
    }

    private void selectProfession(int index) {
        QuestProfession profession = ((QuestsScreenHandler)this.field_2797).professions.get(index);
        this.professionName = profession.name;
        this.professionQuests = ((QuestsScreenHandler)this.field_2797).availableQuests.get(this.professionName);
        if (this.professionQuests == null) {
            this.professionQuests = new ArrayList<Quest>();
        }
        this.professionData = ((QuestsScreenHandler)this.field_2797).professionsData.get(this.professionName);
        this.initButtons();
    }

    @Environment(value=EnvType.CLIENT)
    class ProfessionButton
    extends class_4185 {
        final int index;
        private class_1792 item;

        public ProfessionButton(int x, int y, int index, class_4185.class_4241 onPress) {
            super(x, y, 20, 20, class_2585.field_24366, onPress);
            this.index = index;
        }

        public QuestProfession getQuestProfession() {
            return ((QuestsScreenHandler)((QuestsScreen)QuestsScreen.this).field_2797).professions.get(this.index);
        }

        public void method_25359(class_4587 matrices, int mouseX, int mouseY, float delta) {
            QuestProfession profession = this.getQuestProfession();
            if (profession == null) {
                return;
            }
            super.method_25359(matrices, mouseX, mouseY, delta);
            ((QuestsScreen)QuestsScreen.this).field_22788.field_4730 = 100.0f;
            if (this.item == null) {
                this.item = (class_1792)class_2378.field_11142.method_10223(new class_2960(profession.icon));
            }
            class_1799 stack = new class_1799((class_1935)this.item);
            QuestsScreen.this.field_22788.method_27953(stack, this.field_22760 + 2, this.field_22761 + 2);
        }

        public void method_25352(class_4587 matrices, int mouseX, int mouseY) {
            if (this.field_22762) {
                ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
                QuestProfession profession = this.getQuestProfession();
                tooltip.add(QuestProfession.getTranslatedText(profession.name).method_27692(class_124.field_1065));
                QuestsScreen.this.method_32634(matrices, tooltip, Optional.empty(), mouseX, mouseY);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    class InfoButton
    extends class_4185 {
        public InfoButton(int x, int y, class_4185.class_4241 onPress) {
            super(x, y, 20, 20, (class_2561)new class_2585("?"), onPress);
        }

        public void method_25352(class_4587 matrices, int mouseX, int mouseY) {
            if (this.field_22762) {
                ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
                tooltip.add(new class_2588("screen.guild.quests.legend").method_27692(class_124.field_1075));
                if (Guild.CONFIG.expirationTicks != 0) {
                    tooltip.add(new class_2585("\u231a").method_27692(class_124.field_1062).method_27693(" ").method_10852((class_2561)new class_2588("screen.guild.quests.quest_expiration")));
                    tooltip.add(new class_2588("screen.guild.quests.quest_expiration.description", new Object[]{Guild.CONFIG.expirationTicks / 60 / 20}).method_27692(class_124.field_1063));
                }
                tooltip.add(new class_2585("\u231a").method_27692(class_124.field_1080).method_27693(" ").method_10852((class_2561)new class_2588("screen.guild.quests.time_available")));
                tooltip.add(new class_2588("screen.guild.quests.time_available.description").method_27692(class_124.field_1063));
                tooltip.add(new class_2588("screen.guild.quests.time_available.description2").method_27692(class_124.field_1063));
                tooltip.add(new class_2588("screen.guild.quests.time_available.description3").method_27692(class_124.field_1063));
                tooltip.add(new class_2585("\u2709").method_27692(class_124.field_1080).method_27693(" ").method_10852((class_2561)new class_2588("screen.guild.quests.item")));
                tooltip.add(new class_2588("screen.guild.quests.item.description").method_27692(class_124.field_1063));
                tooltip.add(new class_2588("screen.guild.quests.item.description2").method_27692(class_124.field_1063));
                tooltip.add(new class_2585("\ud83d\udde1").method_27692(class_124.field_1080).method_27693(" ").method_10852((class_2561)new class_2588("screen.guild.quests.slay")));
                tooltip.add(new class_2588("screen.guild.quests.slay.description").method_27692(class_124.field_1063));
                tooltip.add(new class_2585("\u2719").method_27692(class_124.field_1080).method_27693(" ").method_10852((class_2561)new class_2588("screen.guild.quests.cure")));
                tooltip.add(new class_2588("screen.guild.quests.cure.description").method_27692(class_124.field_1063));
                tooltip.add(new class_2585("\u2726").method_27692(class_124.field_1080).method_27693(" ").method_10852((class_2561)new class_2588("screen.guild.quests.summon")));
                tooltip.add(new class_2588("screen.guild.quests.summon.description").method_27692(class_124.field_1063));
                QuestsScreen.this.method_32634(matrices, tooltip, Optional.empty(), mouseX, mouseY);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    class AvailableQuestButton
    extends QuestButton {
        public AvailableQuestButton(int x, int y, int index, class_4185.class_4241 onPress) {
            super(x, y, index, onPress);
        }

        @Override
        public Quest getQuest() {
            return QuestsScreen.this.professionQuests.size() > this.index ? QuestsScreen.this.professionQuests.get(this.index) : null;
        }
    }

    @Environment(value=EnvType.CLIENT)
    class AcceptedQuestButton
    extends QuestButton {
        public AcceptedQuestButton(int x, int y, int index, class_4185.class_4241 onPress) {
            super(x, y, index, onPress);
        }

        @Override
        public Quest getQuest() {
            return ((QuestsScreenHandler)((QuestsScreen)QuestsScreen.this).field_2797).acceptedQuests.size() > this.index ? ((QuestsScreenHandler)((QuestsScreen)QuestsScreen.this).field_2797).acceptedQuests.get(this.index) : null;
        }

        @Override
        public void method_25359(class_4587 matrices, int mouseX, int mouseY, float delta) {
            Quest quest = this.getQuest();
            if (quest == null) {
                return;
            }
            super.method_25359(matrices, mouseX, mouseY, delta);
        }
    }

    @Environment(value=EnvType.CLIENT)
    abstract class QuestButton
    extends class_4185 {
        final int index;

        public QuestButton(int x, int y, int index, class_4185.class_4241 onPress) {
            super(x, y, 126, 20, class_2585.field_24366, onPress);
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        public Quest getQuest() {
            return null;
        }

        public void method_25359(class_4587 matrices, int mouseX, int mouseY, float delta) {
            Quest quest = this.getQuest();
            if (quest == null) {
                return;
            }
            super.method_25359(matrices, mouseX, mouseY, delta);
            ((QuestsScreen)QuestsScreen.this).field_22788.field_4730 = 100.0f;
            int xi = this.field_22760 + 3;
            int yi = this.field_22761 + 1;
            for (Quest.QuestData data : quest.tasks) {
                QuestsScreen.this.field_22788.method_27953(data.stack, xi, yi);
                QuestsScreen.this.field_22788.method_4022(QuestsScreen.this.field_22793, data.stack, xi - 10, yi - 9, data.icon);
                this.renderGuiItemOverlay(QuestsScreen.this.field_22793, data.stack, xi, yi, data.needed - data.count);
                xi += 20;
            }
            xi = this.field_22760 + 108;
            for (Quest.QuestData data : quest.rewards) {
                QuestsScreen.this.field_22788.method_27953(data.stack, xi, yi);
                this.renderGuiItemOverlay(QuestsScreen.this.field_22793, data.stack, xi, yi, data.count);
                xi -= 18;
            }
            ((QuestsScreen)QuestsScreen.this).field_22788.field_4730 = 0.0f;
        }

        protected void renderGuiItemOverlay(class_327 renderer, class_1799 stack, int x, int y, int val) {
            QuestsScreen.this.field_22788.method_4022(QuestsScreen.this.field_22793, stack, x, y, val > 0 ? String.valueOf(val) : "\u2714");
        }

        public void method_25352(class_4587 matrices, int mouseX, int mouseY) {
            if (this.field_22762) {
                Quest quest = this.getQuest();
                if (quest == null) {
                    return;
                }
                ArrayList<class_5250> tooltip = new ArrayList<class_5250>();
                class_5250 text = new class_2588("screen.guild.quests.tasks").method_27692(class_124.field_1078).method_27693("      ");
                long time = ((QuestsScreenHandler)((QuestsScreen)QuestsScreen.this).field_2797).world.method_8510();
                String accTime = quest.getAcceptationTime(time);
                String remTime = quest.getRemainingTime(time);
                if (accTime.length() > 0) {
                    text.method_10852((class_2561)new class_2585("\u231a " + accTime).method_27692(accTime == "00:00" ? class_124.field_1061 : class_124.field_1062));
                } else {
                    text.method_27693("           ");
                }
                if (remTime.length() > 0) {
                    if (accTime.length() > 0) {
                        text.method_27693("  ");
                    }
                    text.method_10852((class_2561)new class_2585("\u231a " + remTime).method_27692(remTime == "00:00" ? class_124.field_1061 : class_124.field_1080));
                }
                tooltip.add(text);
                for (Quest.QuestData task : quest.tasks) {
                    tooltip.add(new class_2585(task.icon).method_27692(class_124.field_1080).method_27693(" ").method_10852(task.stack.method_7964()).method_27693(" ").method_27693(String.valueOf(task.count)).method_27693(" / ").method_27693(String.valueOf(task.needed)));
                }
                tooltip.add(new class_2588("screen.guild.quests.rewards").method_27692(class_124.field_1060));
                for (Quest.QuestData reward : quest.rewards) {
                    tooltip.add(new class_2585("").method_27692(class_124.field_1080).method_10852(reward.stack.method_7964()).method_27693(" ").method_27693(String.valueOf(reward.count)));
                }
                QuestsScreen.this.method_32634(matrices, tooltip, Optional.empty(), mouseX, mouseY);
            }
        }
    }
}

