/*
 * Decompiled with CFR 0.152.
 */
package dev.fulmineo.guild.data;

import com.google.common.collect.ImmutableMap;
import dev.fulmineo.guild.Guild;
import dev.fulmineo.guild.data.QuestProfession;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_3853;

public class VillagerData {
    public static void refreshTrades(Map<String, QuestProfession> professions) {
        HashMap<Integer, ArrayList<SellGuildProfessionItemFactory>> offersByLevel = new HashMap<Integer, ArrayList<SellGuildProfessionItemFactory>>();
        for (Map.Entry<String, QuestProfession> entry : professions.entrySet()) {
            String professionName = entry.getKey();
            QuestProfession prof = entry.getValue();
            int level = prof.guildMasterLevel == 0 ? 1 : (prof.guildMasterLevel > 5 ? 5 : prof.guildMasterLevel);
            ArrayList<SellGuildProfessionItemFactory> offers = (ArrayList<SellGuildProfessionItemFactory>)offersByLevel.get(level);
            if (offers == null) {
                offers = new ArrayList<SellGuildProfessionItemFactory>();
            }
            offers.add(new SellGuildProfessionItemFactory((class_1935)Guild.QUEST_PROFESSION_LICENCE_ITEM, professionName, 5 * level, (int)(5.0 * Math.pow(level, 2.0))));
            offersByLevel.put(level, offers);
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry entry : offersByLevel.entrySet()) {
            class_3853.class_1652[] array = new class_3853.class_1652[((List)entry.getValue()).size()];
            ((List)entry.getValue()).toArray(array);
            builder.put((Object)((Integer)entry.getKey()), (Object)array);
        }
        class_3853.field_17067.put(Guild.GUILD_MASTER, VillagerData.toIntMap((ImmutableMap<Integer, class_3853.class_1652[]>)builder.build()));
    }

    private static Int2ObjectMap<class_3853.class_1652[]> toIntMap(ImmutableMap<Integer, class_3853.class_1652[]> trades) {
        return new Int2ObjectOpenHashMap(trades);
    }

    public static class SellGuildProfessionItemFactory
    implements class_3853.class_1652 {
        private final class_1792 sell;
        private final String profession;
        private final int price;
        private final int experience;

        public SellGuildProfessionItemFactory(class_1935 item, String profession, int price, int experience) {
            this.sell = item.method_8389();
            this.profession = profession;
            this.price = price;
            this.experience = experience;
        }

        public class_1914 method_7246(class_1297 entity, Random random) {
            class_1799 stack = new class_1799((class_1935)this.sell);
            class_2487 nbt = stack.method_7948();
            nbt.method_10582("Profession", this.profession);
            return new class_1914(new class_1799((class_1935)class_1802.field_8687, this.price), stack, 99999, this.experience, 0.05f);
        }
    }
}

