/*
 * Decompiled with CFR 0.152.
 */
package dev.fulmineo.guild.data;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import dev.fulmineo.guild.Guild;
import dev.fulmineo.guild.data.QuestLevel;
import dev.fulmineo.guild.data.QuestLevels;
import dev.fulmineo.guild.data.QuestPool;
import dev.fulmineo.guild.data.QuestProfession;
import dev.fulmineo.guild.data.VillagerData;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleSynchronousResourceReloadListener;
import net.minecraft.class_2487;
import net.minecraft.class_2494;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3300;

public class ServerDataManager {
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).registerTypeAdapter(class_2487.class, (Object)new JsonDeserializer<class_2487>(){

        public class_2487 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            return json.isJsonObject() ? (class_2487)this.jsonToNbt(json) : null;
        }

        public class_2520 jsonToNbt(JsonElement json) {
            if (json.isJsonArray()) {
                JsonArray arr = json.getAsJsonArray();
                if (arr.size() > 0 && arr.get(0).isJsonPrimitive() && arr.get(0).getAsString().startsWith("I;")) {
                    int[] intArr = new int[arr.size()];
                    intArr[0] = Integer.parseInt(arr.get(0).getAsString().replace("I;", ""));
                    for (int i = 1; i < arr.size(); ++i) {
                        intArr[i] = arr.get(i).getAsInt();
                    }
                    return new class_2495(intArr);
                }
                class_2499 list = new class_2499();
                for (int i = 0; i < arr.size(); ++i) {
                    list.add((Object)this.jsonToNbt(arr.get(i)));
                }
                return list;
            }
            if (json.isJsonObject()) {
                JsonObject obj = json.getAsJsonObject();
                class_2487 nbt = new class_2487();
                for (Map.Entry entry : obj.entrySet()) {
                    class_2520 elm = this.jsonToNbt((JsonElement)entry.getValue());
                    if (elm == null) continue;
                    nbt.method_10566((String)entry.getKey(), elm);
                }
                return nbt;
            }
            if (json.isJsonPrimitive()) {
                String val = json.getAsString();
                if (Pattern.compile("^[\\d\\.]+$", 2).matcher(val).find()) {
                    if (val.contains(".")) {
                        return class_2494.method_23244((float)json.getAsFloat());
                    }
                    return class_2497.method_23247((int)json.getAsInt());
                }
                return class_2519.method_23256((String)val);
            }
            return null;
        }
    }).create();
    public static Map<String, List<QuestLevel>> levels = new HashMap<String, List<QuestLevel>>();
    public static Map<String, QuestProfession> professions = new HashMap<String, QuestProfession>();

    public static void init() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)new SimpleSynchronousResourceReloadListener(){

            public class_2960 getFabricId() {
                return new class_2960("guild", "data");
            }

            public void method_14491(class_3300 manager) {
                InputStream stream;
                Guild.errors.clear();
                levels.clear();
                professions.clear();
                HashMap<String, QuestPool> pools = new HashMap<String, QuestPool>();
                for (class_2960 class_29602 : manager.method_14488("quests/levels", path -> path.endsWith(".json"))) {
                    try {
                        stream = manager.method_14486(class_29602).method_14482();
                        try {
                            try {
                                QuestLevels data = (QuestLevels)GSON.fromJson(new String(stream.readAllBytes()), QuestLevels.class);
                                levels.put(data.name, data.levels);
                            }
                            catch (Exception e) {
                                Guild.errors.add("Couldn't parse quest level " + class_29602.toString());
                            }
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                    catch (Exception e) {
                        Guild.errors.add("Error occurred while loading resource json " + class_29602.toString());
                    }
                }
                for (class_2960 class_29603 : manager.method_14488("quests/professions", path -> path.endsWith(".json"))) {
                    try {
                        stream = manager.method_14486(class_29603).method_14482();
                        try {
                            try {
                                QuestProfession profession = (QuestProfession)GSON.fromJson(new String(stream.readAllBytes()), QuestProfession.class);
                                if (professions.containsKey(profession.name)) {
                                    professions.get(profession.name).merge(profession);
                                    continue;
                                }
                                professions.put(profession.name, profession);
                            }
                            catch (Exception e) {
                                Guild.errors.add("Couldn't parse quest profession " + class_29603.toString());
                            }
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                    catch (Exception e) {
                        Guild.errors.add("Error occurred while loading resource json " + class_29603.toString());
                    }
                }
                for (class_2960 class_29604 : manager.method_14488("quests/pools", path -> path.endsWith(".json"))) {
                    try {
                        stream = manager.method_14486(class_29604).method_14482();
                        try {
                            try {
                                QuestPool pool = (QuestPool)GSON.fromJson(new String(stream.readAllBytes()), QuestPool.class);
                                if (pools.containsKey(pool.name)) continue;
                                String invalidKey = pool.validate();
                                if (invalidKey.length() == 0) {
                                    pools.put(pool.name, pool);
                                    continue;
                                }
                                Guild.errors.add("Invalid key " + invalidKey.toString() + " in quest pool " + class_29604.toString());
                            }
                            catch (Exception e) {
                                Guild.errors.add("Couldn't parse quest pool " + class_29604.toString());
                            }
                        }
                        finally {
                            if (stream == null) continue;
                            stream.close();
                        }
                    }
                    catch (Exception e) {
                        Guild.errors.add("Error occurred while loading resource json " + class_29604.toString());
                    }
                }
                for (Map.Entry entry : professions.entrySet()) {
                    QuestPool pool;
                    QuestProfession profession = (QuestProfession)entry.getValue();
                    if (profession.taskPools == null) {
                        Guild.errors.add("Missing required property taskPools in profession " + (String)entry.getKey());
                    } else {
                        for (String taskId : profession.taskPools) {
                            pool = (QuestPool)pools.get(taskId);
                            if (pool == null) {
                                Guild.errors.add("Couldn't find task quest pool " + taskId + " required by profession " + (String)entry.getKey());
                                continue;
                            }
                            profession.addTaskPool(pool);
                        }
                    }
                    if (profession.rewardPools == null) {
                        Guild.errors.add("Missing required property rewardPools in profession " + (String)entry.getKey());
                    } else {
                        for (String rewardId : profession.rewardPools) {
                            pool = (QuestPool)pools.get(rewardId);
                            if (pool == null) {
                                Guild.errors.add("Couldn't find reward quest pool " + rewardId + " required by profession " + (String)entry.getKey());
                                continue;
                            }
                            profession.addRewardPool(pool);
                        }
                    }
                    if (profession.levelsPool == null) {
                        Guild.errors.add("Missing required property levelsPool in profession " + (String)entry.getKey());
                        continue;
                    }
                    if (levels.get(profession.levelsPool) != null) continue;
                    Guild.errors.add("Couldn't find levels pool " + profession.levelsPool + " required by profession " + (String)entry.getKey());
                }
                VillagerData.refreshTrades(professions);
            }
        });
    }
}

