/*
 * Decompiled with CFR 0.152.
 */
package dev.fulmineo.guild.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import dev.fulmineo.guild.Guild;
import dev.fulmineo.guild.data.GuildServerPlayerEntity;
import dev.fulmineo.guild.data.QuestHelper;
import dev.fulmineo.guild.data.QuestLevel;
import dev.fulmineo.guild.data.QuestPoolData;
import dev.fulmineo.guild.data.QuestProfession;
import dev.fulmineo.guild.data.Range;
import dev.fulmineo.guild.data.ServerDataManager;
import dev.fulmineo.guild.data.WeightedItemHelper;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class Quest {
    public static int MAX_TASK_ROLLS = 3;
    protected class_2487 nbt;
    @Environment(value=EnvType.CLIENT)
    public List<QuestData> tasks = new ArrayList<QuestData>();
    @Environment(value=EnvType.CLIENT)
    public List<QuestData> rewards = new ArrayList<QuestData>();

    public Quest() {
        this.nbt = new class_2487();
    }

    public static Quest create(QuestProfession profession, class_1657 player) {
        Object nbt;
        int level = QuestHelper.getCurrentLevel(ServerDataManager.levels.get(profession.levelsPool), ((GuildServerPlayerEntity)player).getProfessionExp(profession.name));
        List<QuestPoolData> tasks = new ArrayList<QuestPoolData>(profession.tasks);
        Iterator iterator = tasks.iterator();
        while (iterator.hasNext()) {
            if (((QuestPoolData)iterator.next()).isAvailableFor(level + 1)) continue;
            iterator.remove();
        }
        tasks = WeightedItemHelper.getWeightedItems(tasks, new Random().nextInt(MAX_TASK_ROLLS) + 1);
        class_2499 itemList = new class_2499();
        class_2499 slayList = new class_2499();
        class_2499 cureList = new class_2499();
        class_2499 summonList = new class_2499();
        class_2499 rewardList = new class_2499();
        int time = 0;
        int worth = 0;
        int exp = 0;
        HashMap<CallSite, QuestPoolData> groupedTasks = new HashMap<CallSite, QuestPoolData>();
        for (QuestPoolData task : tasks) {
            String key = task.type + "_" + task.name;
            QuestPoolData qpd = (QuestPoolData)groupedTasks.get(key);
            if (qpd == null) {
                groupedTasks.put((CallSite)((Object)key), task);
                continue;
            }
            Object object = qpd.number;
            Integer.valueOf(((Range)object).min + task.number.min);
            ((Range)object).min = ((Range)object).min;
            object = qpd.number;
            Integer.valueOf(((Range)object).max + task.number.max);
            ((Range)object).max = ((Range)object).max;
        }
        for (QuestPoolData task : groupedTasks.values()) {
            nbt = new class_2487();
            nbt.method_10582("Name", task.name);
            if (task.icon != null) {
                nbt.method_10582("Icon", task.icon);
                if (task.iconTag != null) {
                    nbt.method_10566("IconTag", (class_2520)task.iconTag);
                }
            }
            if (task.tag != null) {
                nbt.method_10566("Tag", (class_2520)task.tag);
            }
            int needed = task.getQuantityInRange();
            nbt.method_10569("Needed", needed);
            time += needed * task.unitTime;
            worth += needed * task.unitWorth;
            exp += needed * task.unitExp;
            switch (task.type) {
                case "item": {
                    itemList.add(nbt);
                    break;
                }
                case "slay": {
                    slayList.add(nbt);
                    break;
                }
                case "cure": {
                    cureList.add(nbt);
                    break;
                }
                case "summon": {
                    summonList.add(nbt);
                }
            }
        }
        if (time > 0) {
            int timeVariationPercentage = (new Random().nextInt(30) + 1 - 15) / 100;
            time *= 1 + timeVariationPercentage;
            worth *= 1 + timeVariationPercentage * -1;
            exp *= 1 + timeVariationPercentage * -1;
        }
        ArrayList<QuestPoolData> rewardsCopy = new ArrayList<QuestPoolData>(profession.rewards);
        iterator = rewardsCopy.iterator();
        while (iterator.hasNext()) {
            QuestPoolData reward = (QuestPoolData)iterator.next();
            if (reward.isAvailableFor(level + 1) && reward.getMinWorth() <= worth) continue;
            iterator.remove();
        }
        List<QuestPoolData> primaryRewards = WeightedItemHelper.getWeightedItems(rewardsCopy, 6 - MAX_TASK_ROLLS);
        primaryRewards.sort(new MinWeightComparator());
        for (QuestPoolData reward : primaryRewards) {
            if (reward.getMinWorth() <= worth) {
                class_2487 nbt2 = new class_2487();
                nbt2.method_10582("Type", reward.type);
                nbt2.method_10582("Name", reward.name);
                if (reward.tag != null) {
                    nbt2.method_10566("Tag", (class_2520)reward.tag);
                }
                if (reward.icon != null) {
                    nbt2.method_10582("Icon", reward.icon);
                    if (reward.iconTag != null) {
                        nbt2.method_10566("IconTag", (class_2520)reward.iconTag);
                    }
                }
                int count = reward.getCountByWorth(worth);
                nbt2.method_10569("Count", count);
                if (reward.type.equals("currency") && Guild.economyDependency != null) {
                    nbt2.method_10582("Label", Guild.economyDependency.getCurrencyName(reward.name, count));
                }
                rewardList.add((Object)nbt2);
                worth -= reward.unitWorth * count;
            }
            rewardsCopy.remove(reward);
        }
        Collections.reverse(rewardList);
        nbt = new class_2487();
        nbt.method_10582("Profession", profession.name);
        if (time > 0) {
            nbt.method_10569("Time", time);
        }
        if (Guild.CONFIG.expirationTicks != 0) {
            nbt.method_10544("AvailableUntil", player.field_6002.method_8510() + (long)Guild.CONFIG.expirationTicks);
        }
        nbt.method_10569("Exp", exp);
        nbt.method_10566("Slay", (class_2520)slayList);
        nbt.method_10566("Cure", (class_2520)cureList);
        nbt.method_10566("Summon", (class_2520)summonList);
        nbt.method_10566("Item", (class_2520)itemList);
        nbt.method_10566("Reward", (class_2520)rewardList);
        return Quest.fromNbt((class_2487)nbt);
    }

    public class_2487 getNbt() {
        return this.nbt;
    }

    public static Quest fromNbt(class_2487 nbt) {
        Quest quest = new Quest();
        if (nbt.method_10545("Entity")) {
            nbt.method_10566("Slay", nbt.method_10580("Entity"));
        }
        quest.nbt = nbt;
        return quest;
    }

    public class_2487 writeNbt(class_2487 nbt) {
        for (String key : this.nbt.method_10541()) {
            nbt.method_10566(key, this.nbt.method_10580(key));
        }
        return nbt;
    }

    public String getProfessionName() {
        return this.nbt.method_10558("Profession");
    }

    public class_2499 getItemList() {
        return this.nbt.method_10554("Item", 10);
    }

    public class_2499 getSlayList() {
        return this.nbt.method_10554("Slay", 10);
    }

    public class_2499 getCureList() {
        return this.nbt.method_10554("Cure", 10);
    }

    public class_2499 getSummonList() {
        return this.nbt.method_10554("Summon", 10);
    }

    public class_2499 getRewardList() {
        return this.nbt.method_10554("Reward", 10);
    }

    public String getRemainingTime(long currentTime) {
        int seconds;
        if (this.nbt.method_10545("ExpiresAt")) {
            seconds = (int)((this.nbt.method_10537("ExpiresAt") - currentTime) / 20L);
            if (seconds <= 0) {
                return "00:00";
            }
        } else {
            seconds = this.nbt.method_10550("Time");
            if (seconds == 0) {
                return "";
            }
        }
        return this.timeToString(seconds);
    }

    public String getAcceptationTime(long currentTime) {
        if (this.nbt.method_10545("AvailableUntil")) {
            int seconds = (int)((this.nbt.method_10537("AvailableUntil") - currentTime) / 20L);
            if (seconds <= 0) {
                return "00:00";
            }
            return this.timeToString(seconds);
        }
        return "";
    }

    public String timeToString(int seconds) {
        int minutes = seconds / 60;
        int hours = minutes / 60;
        seconds %= 60;
        if (hours > 0) {
            return (hours > 9 ? "" : "0") + hours + ":" + ((minutes %= 60) > 9 ? "" : "0") + minutes + ":" + (seconds > 9 ? "" : "0") + seconds;
        }
        return (minutes > 9 ? "" : "0") + minutes + ":" + (seconds > 9 ? "" : "0") + seconds;
    }

    public void accept(long currentTime) {
        if (this.nbt.method_10545("Time")) {
            this.nbt.method_10544("ExpiresAt", currentTime + (long)(this.nbt.method_10550("Time") * 20));
        }
        this.nbt.method_10551("AvailableUntil");
    }

    public boolean tick() {
        if (this.nbt.method_10545("Time")) {
            int time = this.nbt.method_10550("Time") - 1;
            this.nbt.method_10569("Time", time);
            return time < 0;
        }
        return false;
    }

    public void updateSlay(String entityIdentifier, class_1309 entity, class_1657 player) {
        this.updateEntityNbt("Slay", entityIdentifier, entity, player);
    }

    public void updateCure(String entityIdentifier, class_1309 entity, class_1657 player) {
        this.updateEntityNbt("Cure", entityIdentifier, entity, player);
    }

    public void updateSummon(String entityIdentifier, class_1309 entity, class_1657 player) {
        this.updateEntityNbt("Summon", entityIdentifier, entity, player);
    }

    private void updateEntityNbt(String listName, String identifier, class_1309 entity, class_1657 player) {
        if (this.nbt.method_10545(listName)) {
            class_2499 entities = this.nbt.method_10554(listName, 10);
            for (class_2520 elem : entities) {
                class_2487 entry = (class_2487)elem;
                if (entry.method_10550("Count") >= entry.method_10550("Needed") || !entry.method_10558("Name").equals(identifier) || entry.method_10545("Tag") && !Quest.matchesNbt(entity.method_5647(new class_2487()), entry.method_10562("Tag"))) continue;
                entry.method_10569("Count", entry.method_10550("Count") + 1);
                break;
            }
        }
    }

    public boolean isExpired(long time) {
        return this.nbt.method_10537("ExpiresAt") < time;
    }

    public boolean tryComplete(class_3222 player) {
        class_2499 entities = this.nbt.method_10554("Slay", 10);
        for (class_2520 elem : entities) {
            class_2487 entry = (class_2487)elem;
            if (entry.method_10550("Count") == entry.method_10550("Needed")) continue;
            return false;
        }
        ArrayList stacksByIndex = new ArrayList();
        class_1661 inventory = player.method_31548();
        ImmutableList mainAndOffhand = ImmutableList.of((Object)inventory.field_7547, (Object)inventory.field_7544);
        class_2499 items = this.nbt.method_10554("Item", 10);
        for (class_2520 elem : items) {
            class_2487 entry = (class_2487)elem;
            ArrayList<class_1799> stacks = new ArrayList<class_1799>();
            class_1792 item = (class_1792)class_2378.field_11142.method_10223(new class_2960(entry.method_10558("Name")));
            int needed = entry.method_10550("Needed");
            UnmodifiableIterator iterator = mainAndOffhand.iterator();
            block2: while (needed > 0 && iterator.hasNext()) {
                class_2371 defaultedList = (class_2371)iterator.next();
                for (int i = 0; i < defaultedList.size(); ++i) {
                    class_1799 stack = (class_1799)defaultedList.get(i);
                    if (!stack.method_31574(item) || entry.method_10545("Tag") && !Quest.matchesNbt(stack.method_7948(), entry.method_10562("Tag"))) continue;
                    stacks.add(stack);
                    if ((needed -= stack.method_7947()) <= 0) continue block2;
                }
            }
            if (needed > 0) {
                return false;
            }
            stacksByIndex.add(stacks);
        }
        for (int i = 0; i < items.size(); ++i) {
            class_2487 entry = (class_2487)items.method_10534(i);
            List stacks = (List)stacksByIndex.get(i);
            int needed = entry.method_10550("Needed");
            Iterator iterator = stacks.iterator();
            while (needed > 0 && iterator.hasNext()) {
                class_1799 stack = (class_1799)iterator.next();
                int count = stack.method_7947();
                if (count <= needed) {
                    needed -= count;
                    stack.method_7939(0);
                    continue;
                }
                stack.method_7939(count - needed);
                needed = 0;
            }
            if (needed <= 0) continue;
            return false;
        }
        GuildServerPlayerEntity guildPlayer = (GuildServerPlayerEntity)player;
        String professionName = this.getProfessionName();
        QuestProfession profession = ServerDataManager.professions.get(professionName);
        if (profession != null) {
            List<QuestLevel> levels = ServerDataManager.levels.get(profession.levelsPool);
            int exp = guildPlayer.getProfessionExp(professionName);
            QuestLevel lastLevel = levels.get(levels.size() - 1);
            if ((exp += this.nbt.method_10550("Exp")) > lastLevel.exp) {
                exp = lastLevel.exp;
            }
            guildPlayer.setProfessionExp(professionName, exp);
        }
        this.giveRewards(player);
        return true;
    }

    public void giveRewards(class_3222 player) {
        boolean expired = this.isExpired(player.field_6002.method_8510());
        class_2499 rewards = this.getRewardList();
        for (class_2520 elm : rewards) {
            class_2487 entry = (class_2487)elm;
            String type = entry.method_10558("Type");
            int count = entry.method_10550("Count");
            if (expired) {
                int cnt1 = player.field_6002.field_9229.nextInt(count + 1);
                if (player.method_6059(class_1294.field_5926)) {
                    int cnt2 = player.field_6002.field_9229.nextInt(count + 1);
                    count = Math.max(cnt1, cnt2);
                } else {
                    count = cnt1;
                }
            }
            switch (type) {
                case "currency": {
                    if (Guild.economyDependency == null) break;
                    Guild.economyDependency.giveReward(count, entry, player);
                }
            }
            class_1799 stack = new class_1799((class_1935)class_2378.field_11142.method_10223(new class_2960(entry.method_10558("Name"))), count);
            if (entry.method_10545("Tag")) {
                stack.method_7980(entry.method_10562("Tag"));
            }
            if (player.method_7270(stack)) continue;
            player.method_7328(stack, false);
        }
    }

    public static boolean matchesNbt(class_2487 nbtToMatch, class_2487 nbt) {
        for (String key : nbt.method_10541()) {
            class_2520 elm = nbtToMatch.method_10580(key);
            if (elm != null && elm.equals(nbt.method_10580(key))) continue;
            return false;
        }
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    private void addItemTask(String icon, class_2487 entry) {
        class_1799 stack;
        if (entry.method_10545("Icon")) {
            stack = new class_1799((class_1935)class_2378.field_11142.method_10223(new class_2960(entry.method_10558("Icon"))));
            if (entry.method_10545("IconTag")) {
                stack.method_7980(entry.method_10562("IconTag"));
            }
        } else {
            stack = new class_1799((class_1935)class_2378.field_11142.method_10223(new class_2960(entry.method_10558("Name"))));
            if (entry.method_10545("Tag")) {
                stack.method_7980(entry.method_10562("Tag"));
            }
        }
        QuestData data = new QuestData();
        data.icon = icon;
        data.stack = stack;
        data.count = entry.method_10550("Count");
        data.needed = entry.method_10550("Needed");
        this.tasks.add(data);
    }

    @Environment(value=EnvType.CLIENT)
    private void addEntityTask(String icon, class_2487 entry) {
        class_1799 stack;
        if (entry.method_10545("Icon")) {
            stack = new class_1799((class_1935)class_2378.field_11142.method_10223(new class_2960(entry.method_10558("Icon"))));
            if (entry.method_10545("IconTag")) {
                stack.method_7980(entry.method_10562("IconTag"));
            }
        } else {
            class_1792 spawnEgg = (class_1792)class_2378.field_11142.method_10223(new class_2960(entry.method_10558("Name") + "_spawn_egg"));
            if (spawnEgg == class_1802.field_8162) {
                stack = new class_1799((class_1935)class_1802.field_8802);
            } else {
                stack = new class_1799((class_1935)spawnEgg);
                stack.method_7977(((class_1299)class_2378.field_11145.method_10223(new class_2960(entry.method_10558("Name")))).method_5897());
            }
        }
        QuestData data = new QuestData();
        data.icon = icon;
        data.stack = stack;
        data.count = entry.method_10550("Count");
        data.needed = entry.method_10550("Needed");
        this.tasks.add(data);
    }

    @Environment(value=EnvType.CLIENT)
    private void addReward(class_2487 entry) {
        class_1799 stack;
        if (entry.method_10545("Icon")) {
            stack = new class_1799((class_1935)class_2378.field_11142.method_10223(new class_2960(entry.method_10558("Icon"))));
            if (entry.method_10545("IconTag")) {
                stack.method_7980(entry.method_10562("IconTag"));
            }
        } else {
            stack = new class_1799((class_1935)class_2378.field_11142.method_10223(new class_2960(entry.method_10558("Name"))));
            if (entry.method_10545("Tag")) {
                stack.method_7980(entry.method_10562("Tag"));
            }
        }
        if (entry.method_10545("Label")) {
            stack.method_7977((class_2561)new class_2585(entry.method_10558("Label")));
        }
        QuestData data = new QuestData();
        data.stack = stack;
        data.count = entry.method_10550("Count");
        this.rewards.add(data);
    }

    @Environment(value=EnvType.CLIENT)
    public void updateTasksAndRewards() {
        this.tasks.clear();
        this.rewards.clear();
        class_2499 itemList = this.getItemList();
        for (Object elm : itemList) {
            this.addItemTask("\u2709", (class_2487)elm);
        }
        class_2499 slayList = this.getSlayList();
        for (Object elm : slayList) {
            this.addEntityTask("\ud83d\udde1", (class_2487)elm);
        }
        class_2499 cureList = this.getCureList();
        for (Object elm : cureList) {
            this.addEntityTask("\u2719", (class_2487)elm);
        }
        class_2499 summonList = this.getSummonList();
        for (class_2520 elm : summonList) {
            this.addEntityTask("\u2726", (class_2487)elm);
        }
        class_2499 rewards = this.getRewardList();
        for (class_2520 elm : rewards) {
            this.addReward((class_2487)elm);
        }
    }

    static class MinWeightComparator
    implements Comparator<QuestPoolData> {
        MinWeightComparator() {
        }

        @Override
        public int compare(QuestPoolData a, QuestPoolData b) {
            return b.getMinWorth() - a.getMinWorth();
        }
    }

    public class QuestData {
        public String icon;
        public class_1799 stack;
        public int count;
        public int needed;
    }
}

