/*
 * Decompiled with CFR 0.152.
 */
package terrails.healthoverlay.render;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1159;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import terrails.healthoverlay.Constants;
import terrails.healthoverlay.ModConfiguration;
import terrails.healthoverlay.heart.Heart;
import terrails.healthoverlay.heart.HeartPiece;
import terrails.healthoverlay.heart.HeartType;

public class RenderUtils {
    public static void drawTexture(class_4587 poseStack, int x, int y, int u, int v) {
        RenderUtils.drawTexture(poseStack, x, y, u, v, 0);
    }

    public static void drawTexture(class_4587 poseStack, int x, int y, int u, int v, int alpha) {
        RenderUtils.drawTexture(poseStack, x, x + 9, y, y + 9, u, u + 9, v, v + 9, alpha);
    }

    public static void drawTexture(class_4587 poseStack, int x, int y, int u, int v, int color, int alpha) {
        RenderUtils.drawTexture(poseStack, x, x + 9, y, y + 9, u, u + 9, v, v + 9, color, alpha);
    }

    public static void drawTexture(class_4587 poseStack, int x1, int x2, int y1, int y2, int u1, int u2, int v1, int v2) {
        RenderUtils.drawTexture(poseStack, x1, x2, y1, y2, u1, u2, v1, v2, 0, 0, 0, 0);
    }

    public static void drawTexture(class_4587 poseStack, int x1, int x2, int y1, int y2, int u1, int u2, int v1, int v2, int alpha) {
        RenderUtils.drawTexture(poseStack, x1, x2, y1, y2, u1, u2, v1, v2, 255, 255, 255, alpha);
    }

    public static void drawTexture(class_4587 poseStack, int x1, int x2, int y1, int y2, int u1, int u2, int v1, int v2, int color, int alpha) {
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        RenderUtils.drawTexture(poseStack, x1, x2, y1, y2, u1, u2, v1, v2, r, g, b, alpha);
    }

    public static void drawTexture(class_4587 poseStack, int x1, int x2, int y1, int y2, int u1, int u2, int v1, int v2, int red, int green, int blue, int alpha) {
        RenderUtils.drawColoredTexturedQuad(poseStack.method_23760().method_23761(), x1, x2, y1, y2, class_310.method_1551().field_1705.method_25305(), (float)u1 / 256.0f, (float)u2 / 256.0f, (float)v1 / 256.0f, (float)v2 / 256.0f, red, green, blue, alpha);
    }

    public static void drawColoredTexturedQuad(class_1159 matrix4f, int x0, int x1, int y0, int y1, int z, float u0, float u1, float v0, float v1, int red, int green, int blue, int alpha) {
        RenderSystem.setShader(() -> alpha != 0 ? class_757.method_34541() : class_757.method_34542());
        class_287 bufferBuilder = class_289.method_1348().method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_27382, alpha != 0 ? class_290.field_20887 : class_290.field_1585);
        bufferBuilder.method_22918(matrix4f, (float)x0, (float)y1, (float)z).method_1336(red, green, blue, alpha).method_22913(u0, v1).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y1, (float)z).method_1336(red, green, blue, alpha).method_22913(u1, v1).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x1, (float)y0, (float)z).method_1336(red, green, blue, alpha).method_22913(u1, v0).method_1344();
        bufferBuilder.method_22918(matrix4f, (float)x0, (float)y0, (float)z).method_1336(red, green, blue, alpha).method_22913(u0, v0).method_1344();
        bufferBuilder.method_1326();
        class_286.method_1309((class_287)bufferBuilder);
    }

    public static List<Heart> calculateHearts(int absorption, int health, int maxHealth, HeartType heartType) {
        ArrayList hearts;
        block60: {
            int value;
            int i;
            int topAbsorptionRange;
            int absorptionRange;
            int topHealthRange;
            int healthRange;
            HeartPiece[] absorptionColors;
            HeartPiece[] healthColors;
            block59: {
                int index;
                int var;
                hearts = Lists.newArrayList();
                switch (heartType) {
                    case NORMAL: {
                        healthColors = ModConfiguration.healthColors;
                        absorptionColors = ModConfiguration.absorptionColors;
                        break;
                    }
                    case POISONED: {
                        healthColors = ModConfiguration.healthPoisonColors;
                        absorptionColors = ModConfiguration.absorptionPoisonColors;
                        break;
                    }
                    case WITHERED: {
                        healthColors = ModConfiguration.healthWitherColors;
                        absorptionColors = ModConfiguration.absorptionWitherColors;
                        break;
                    }
                    case FROZEN: {
                        healthColors = ModConfiguration.healthFrozenColors;
                        absorptionColors = ModConfiguration.absorptionFrozenColors;
                        break;
                    }
                    default: {
                        Constants.LOGGER.error("Something went very wrong, heart type '{}' does not exist. Using normal heart colors...", (Object)heartType);
                        healthColors = ModConfiguration.healthColors;
                        absorptionColors = ModConfiguration.absorptionColors;
                    }
                }
                if (health > 20) {
                    if (health % 20 == 0) {
                        var = (int)((double)(health - 1) / 20.0);
                        index = var % healthColors.length;
                        healthColors = new HeartPiece[]{null, healthColors[index]};
                    } else {
                        var = (int)((double)health / 20.0);
                        healthColors = new HeartPiece[]{healthColors[var % healthColors.length], healthColors[(var - 1) % healthColors.length]};
                    }
                } else {
                    healthColors = new HeartPiece[]{null, healthColors[0]};
                }
                if (absorption > 20) {
                    if (absorption % 20 == 0) {
                        var = (int)((double)(absorption - 1) / 20.0);
                        index = var % absorptionColors.length;
                        absorptionColors = new HeartPiece[]{null, absorptionColors[index]};
                    } else {
                        var = (int)((double)absorption / 20.0);
                        absorptionColors = new HeartPiece[]{absorptionColors[var % absorptionColors.length], absorptionColors[(var - 1) % absorptionColors.length]};
                    }
                } else if (absorption > 0) {
                    absorptionColors = new HeartPiece[]{null, absorptionColors[0]};
                }
                healthRange = Math.min(health, 20);
                topHealthRange = health > 20 && health % 20 != 0 ? health % 20 : 0;
                absorptionRange = Math.min(absorption, 20);
                int n = topAbsorptionRange = absorption > 20 && absorption % 20 != 0 ? absorption % 20 : 0;
                if (!ModConfiguration.absorptionOverHealth || absorption <= 0) break block59;
                ModConfiguration.AbsorptionMode mode = ModConfiguration.absorptionOverHealthMode;
                if (health % 20 == 0 || absorption % 20 == 0 || absorption >= 20) {
                    mode = ModConfiguration.AbsorptionMode.BEGINNING;
                }
                int[] offsets = null;
                if (mode == ModConfiguration.AbsorptionMode.AFTER_HEALTH) {
                    int temp = 20 - health % 20;
                    int var1 = absorption > temp ? absorptionRange - temp : 0;
                    int var2 = health > 20 ? topHealthRange + absorptionRange : healthRange + absorptionRange;
                    offsets = new int[]{var1, var2};
                }
                block10: for (int i2 = 0; i2 < class_3532.method_15386((float)((float)Math.min(maxHealth + absorption, 20) / 2.0f)); ++i2) {
                    int value2 = i2 * 2 + 1;
                    if (value2 > absorption + health) {
                        if (value2 < maxHealth) {
                            hearts.add(Heart.CONTAINER_FULL);
                            continue;
                        }
                        if (value2 != maxHealth) continue;
                        hearts.add(Heart.CONTAINER_HALF);
                        continue;
                    }
                    switch (mode) {
                        case BEGINNING: {
                            if (value2 < topAbsorptionRange) {
                                hearts.add(Heart.full(absorptionColors[0]));
                                continue block10;
                            }
                            if (value2 == topAbsorptionRange) {
                                hearts.add(Heart.full(absorptionColors[0], absorptionColors[1]));
                                continue block10;
                            }
                            if (value2 < absorptionRange) {
                                hearts.add(Heart.full(absorptionColors[1]));
                                continue block10;
                            }
                            if (value2 == absorptionRange) {
                                hearts.add(Heart.full(absorptionColors[1], healthColors[value2 + 1 <= topHealthRange ? 0 : 1]));
                                continue block10;
                            }
                            if (value2 < topHealthRange) {
                                hearts.add(Heart.full(healthColors[0]));
                                continue block10;
                            }
                            if (value2 == topHealthRange) {
                                hearts.add(Heart.full(healthColors[0], healthColors[1]));
                                continue block10;
                            }
                            if (value2 < healthRange) {
                                hearts.add(Heart.full(healthColors[1]));
                                continue block10;
                            }
                            if (value2 != healthRange) continue block10;
                            hearts.add(Heart.half(healthColors[1], value2 != maxHealth));
                            continue block10;
                        }
                        case AFTER_HEALTH: {
                            if (value2 < topAbsorptionRange) {
                                hearts.add(Heart.full(absorptionColors[0]));
                                continue block10;
                            }
                            if (value2 == topAbsorptionRange) {
                                hearts.add(Heart.full(absorptionColors[0], absorptionColors[1]));
                                continue block10;
                            }
                            if (value2 < offsets[0]) {
                                hearts.add(Heart.full(absorptionColors[1]));
                                continue block10;
                            }
                            if (value2 == offsets[0]) {
                                if (absorption >= 20) {
                                    hearts.add(Heart.full(absorptionColors[1]));
                                    continue block10;
                                }
                                hearts.add(Heart.full(absorptionColors[1], healthColors[value2 + 1 < topHealthRange ? 0 : 1]));
                                continue block10;
                            }
                            if (value2 < topHealthRange) {
                                hearts.add(Heart.full(healthColors[0]));
                                continue block10;
                            }
                            if (value2 == topHealthRange) {
                                if (value2 + 1 <= offsets[1]) {
                                    hearts.add(Heart.full(healthColors[0], absorptionColors[1]));
                                    continue block10;
                                }
                                hearts.add(Heart.full(healthColors[0], healthColors[1]));
                                continue block10;
                            }
                            if (health > 20) {
                                if (value2 < offsets[1]) {
                                    hearts.add(Heart.full(absorptionColors[1]));
                                    continue block10;
                                }
                                if (value2 == offsets[1]) {
                                    hearts.add(Heart.full(absorptionColors[1], healthColors[1]));
                                    continue block10;
                                }
                                if (value2 < healthRange) {
                                    hearts.add(Heart.full(healthColors[1]));
                                    continue block10;
                                }
                                if (value2 != healthRange) continue block10;
                                hearts.add(Heart.full(healthColors[1], absorptionColors[1]));
                                continue block10;
                            }
                            if (value2 < healthRange) {
                                hearts.add(Heart.full(healthColors[1]));
                                continue block10;
                            }
                            if (value2 == healthRange) {
                                hearts.add(Heart.full(healthColors[1], absorptionColors[1]));
                                continue block10;
                            }
                            if (value2 < offsets[1]) {
                                hearts.add(Heart.full(absorptionColors[1]));
                                continue block10;
                            }
                            if (value2 != offsets[1]) continue block10;
                            hearts.add(Heart.half(absorptionColors[1], false));
                        }
                    }
                }
                break block60;
            }
            for (i = 0; i < class_3532.method_15386((float)((float)Math.min(maxHealth, 20) / 2.0f)); ++i) {
                value = i * 2 + 1;
                if (value < topHealthRange) {
                    hearts.add(Heart.full(healthColors[0]));
                    continue;
                }
                if (value == topHealthRange) {
                    hearts.add(Heart.full(healthColors[0], healthColors[1]));
                    continue;
                }
                if (value < healthRange) {
                    hearts.add(Heart.full(healthColors[1]));
                    continue;
                }
                if (value == healthRange) {
                    if (maxHealth > value) {
                        hearts.add(Heart.half(healthColors[1], true));
                        continue;
                    }
                    hearts.add(Heart.half(healthColors[1], false));
                    continue;
                }
                if (value < maxHealth) {
                    hearts.add(Heart.CONTAINER_FULL);
                    continue;
                }
                if (value != maxHealth) continue;
                hearts.add(Heart.CONTAINER_HALF);
            }
            if (absorption <= 0) break block60;
            for (i = 0; i < class_3532.method_15386((float)((float)absorptionRange / 2.0f)); ++i) {
                value = i * 2 + 1;
                if (absorptionColors == null) {
                    if (value < topAbsorptionRange || value < absorptionRange) {
                        hearts.add(Heart.CONTAINER_FULL);
                        continue;
                    }
                    if (value != topAbsorptionRange && value != absorptionRange) continue;
                    hearts.add(Heart.CONTAINER_HALF);
                    continue;
                }
                if (value < topAbsorptionRange) {
                    hearts.add(Heart.full(absorptionColors[0]));
                    continue;
                }
                if (value == topAbsorptionRange) {
                    hearts.add(Heart.full(absorptionColors[0], absorptionColors[1]));
                    continue;
                }
                if (value < absorptionRange) {
                    hearts.add(Heart.full(absorptionColors[1]));
                    continue;
                }
                if (value != absorptionRange) continue;
                hearts.add(Heart.half(absorptionColors[1], false));
            }
        }
        return hearts;
    }
}

