/*
 * Decompiled with CFR 0.152.
 */
package terrails.healthoverlay.render;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1294;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import terrails.healthoverlay.HOExpectPlatform;
import terrails.healthoverlay.ModConfiguration;
import terrails.healthoverlay.heart.Heart;
import terrails.healthoverlay.heart.HeartType;
import terrails.healthoverlay.render.RenderUtils;

public class HeartRenderer {
    public static HeartRenderer INSTANCE = new HeartRenderer();
    private final class_310 client = class_310.method_1551();
    private final Random random = new Random();
    private long lastHealthTime;
    private long healthBlinkTime;
    private int displayHealth;
    private int lastHealth;
    private List<Heart> hearts = Lists.newArrayList();
    private int previousHealth;
    private int previousMaxHealth;
    private int previousAbsorption;
    private HeartType previousHeartType;

    public void renderPlayerHearts(class_4587 poseStack, class_1657 player) {
        int currentHealth = class_3532.method_15386((float)player.method_6032());
        long tickCount = this.client.field_1705.method_1738();
        boolean blinking = this.healthBlinkTime > tickCount && (this.healthBlinkTime - tickCount) / 3L % 2L == 1L;
        long currentTime = class_156.method_658();
        if (currentHealth < this.lastHealth && player.field_6008 > 0) {
            this.lastHealthTime = currentTime;
            this.healthBlinkTime = tickCount + 20L;
        } else if (currentHealth > this.lastHealth && player.field_6008 > 0) {
            this.lastHealthTime = currentTime;
            this.healthBlinkTime = tickCount + 10L;
        }
        this.lastHealth = currentHealth;
        if (currentTime - this.lastHealthTime > 1000L) {
            this.displayHealth = currentHealth;
            this.lastHealthTime = currentTime;
        }
        this.random.setSeed(tickCount * 312871L);
        int xPos = this.client.method_22683().method_4486() / 2 - 91;
        int yPos = this.client.method_22683().method_4502() - 39;
        int maxHealth = Math.max((int)player.method_6063(), Math.max(this.displayHealth, currentHealth));
        int absorption = class_3532.method_15386((float)player.method_6067());
        int regenerationIndex = -1;
        if (player.method_6059(class_1294.field_5924)) {
            regenerationIndex = (int)tickCount % class_3532.method_15386((float)((float)maxHealth + 5.0f));
        }
        HeartType heartType = HeartType.forPlayer(player);
        if (this.previousHealth != currentHealth || this.previousMaxHealth != maxHealth || this.previousAbsorption != absorption || this.previousHeartType != heartType) {
            this.hearts = RenderUtils.calculateHearts(absorption, currentHealth, maxHealth, heartType);
            this.previousHealth = currentHealth;
            this.previousMaxHealth = maxHealth;
            this.previousAbsorption = absorption;
            this.previousHeartType = heartType;
        }
        HOExpectPlatform.modifyStatusBarYPos(absorption);
        RenderSystem.enableBlend();
        for (int index = 0; index < this.hearts.size(); ++index) {
            Heart heart = this.hearts.get(index);
            int regenOffset = index < 10 && index == regenerationIndex ? -2 : 0;
            int absorptionOffset = index > 9 ? -10 : 0;
            int yPosition = yPos + regenOffset + absorptionOffset;
            int xPosition = xPos + index % 10 * 8;
            if (ModConfiguration.absorptionOverHealth || index < 10) {
                if (currentHealth <= 4) {
                    yPosition += this.random.nextInt(2);
                }
                if (index == regenerationIndex) {
                    yPosition -= 2;
                }
            }
            heart.draw(poseStack, xPosition, yPosition, blinking, heartType);
        }
        RenderSystem.disableBlend();
    }
}

