/*
 * Decompiled with CFR 0.152.
 */
package terrails.healthoverlay.heart;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import terrails.healthoverlay.Constants;
import terrails.healthoverlay.heart.HeartType;
import terrails.healthoverlay.render.RenderUtils;

public class HeartPiece {
    public static final HeartPiece VANILLA_HEALTH = new HeartPiece(false);
    public static final HeartPiece VANILLA_ABSORPTION = new HeartPiece(true);
    private final Integer color;
    private final boolean absorption;

    protected HeartPiece(int color, boolean absorption) {
        this.absorption = absorption;
        this.color = color;
    }

    private HeartPiece(boolean absorption) {
        this.absorption = absorption;
        this.color = null;
    }

    public static HeartPiece custom(int color, boolean absorption) {
        return new HeartPiece(color, absorption);
    }

    public static HeartPiece custom(String hexColor, boolean absorption) {
        return HeartPiece.custom(Integer.parseInt(hexColor.substring(1), 16), absorption);
    }

    public Integer getColor() {
        return this.color;
    }

    public boolean isAbsorption() {
        return this.absorption;
    }

    public boolean isVanilla() {
        return this.color == null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            HeartPiece part = (HeartPiece)obj;
            return Objects.equals(this.color, part.color) && this.absorption == part.absorption;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.absorption, this.color);
    }

    public void draw(class_4587 poseStack, int xPos, int yPos, boolean blinking, boolean hardcore, HeartType type) {
        this.draw(poseStack, xPos, yPos, blinking, hardcore, type, Part.FULL);
    }

    public void draw(class_4587 poseStack, int xPos, int yPos, boolean blinking, boolean hardcore, HeartType type, boolean firstHalf) {
        this.draw(poseStack, xPos, yPos, blinking, hardcore, type, firstHalf ? Part.FIRST_HALF : Part.SECOND_HALF);
    }

    private void draw(class_4587 poseStack, int xPos, int yPos, boolean blinking, boolean hardcore, HeartType type, Part part) {
        xPos += part == Part.SECOND_HALF ? 5 : 0;
        int xTex = type.getX(part.getXOffset(), this.isVanilla(), this.isAbsorption(), blinking);
        assert (class_310.method_1551().field_1687 != null);
        int yTex = hardcore ? (this.isVanilla() ? 45 : 36) : 0;
        int x2 = part == Part.FULL || part == Part.FIRST_HALF ? 9 : 5;
        int y2 = 9;
        if (this.isVanilla()) {
            RenderSystem.setShaderTexture((int)0, (class_2960)class_332.field_22737);
            RenderUtils.drawTexture(poseStack, xPos, xPos + x2, yPos, yPos + y2, xTex, xTex + x2, yTex, yTex + y2);
        } else {
            RenderSystem.setShaderTexture((int)0, (class_2960)(this.isAbsorption() ? Constants.ABSORPTION_ICONS_LOCATION : Constants.HEALTH_ICONS_LOCATION));
            RenderUtils.drawTexture(poseStack, xPos, xPos + x2, yPos, yPos + y2, xTex, xTex + x2, yTex, yTex + y2, this.getColor(), 255);
            yTex += y2;
            if (hardcore) {
                RenderUtils.drawTexture(poseStack, xPos, xPos + x2, yPos, yPos + y2, xTex, xTex + x2, yTex, yTex + y2, this.isAbsorption() ? 88 : 178);
            } else {
                RenderUtils.drawTexture(poseStack, xPos, xPos + x2, yPos, yPos + y2, xTex, xTex + x2, yTex, yTex + y2, 216);
            }
            RenderUtils.drawTexture(poseStack, xPos, xPos + x2, yPos, yPos + y2, xTex, xTex + x2, yTex += y2, yTex + y2, type == HeartType.WITHERED ? 216 : 56);
            if (blinking && !this.isAbsorption()) {
                RenderUtils.drawTexture(poseStack, xPos, xPos + x2, yPos, yPos + y2, xTex, xTex + x2, yTex -= 2 * y2, yTex + y2, type == HeartType.WITHERED ? 56 : 127);
            }
            RenderSystem.setShaderTexture((int)0, (class_2960)class_332.field_22737);
        }
    }

    private static enum Part {
        FULL(0),
        FIRST_HALF(9),
        SECOND_HALF(5);

        private final int x;

        private Part(int x) {
            this.x = x;
        }

        public int getXOffset() {
            return this.x;
        }
    }
}

