/*
 * Decompiled with CFR 0.152.
 */
package terrails.healthoverlay.fabric;

import com.google.common.collect.Lists;
import io.github.fablabsmc.fablabs.api.fiber.v1.FiberId;
import io.github.fablabsmc.fablabs.api.fiber.v1.builder.ConfigTreeBuilder;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.ValueDeserializationException;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.StringSerializableType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigTypes;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.EnumConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ListConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigAttribute;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigBranch;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.PropertyMirror;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import terrails.healthoverlay.Constants;
import terrails.healthoverlay.ModConfiguration;

public class HealthOverlay
implements ClientModInitializer {
    public static final JanksonValueSerializer JANKSON_SERIALIZER = new JanksonValueSerializer(false);
    public static final ConfigBranch CONFIG_NODE;
    public static final Path CONFIG_PATH;
    public static final FiberId LIST_MIN_SIZE;
    public static final FiberId LIST_MAX_SIZE;
    private static final List<Runnable> CONFIG_APPLY_LIST;

    public void onInitializeClient() {
        HealthOverlay.setupConfig(true);
    }

    public static void setupConfig(boolean deserialize) {
        try {
            while (deserialize) {
                if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
                    try {
                        FiberSerialization.deserialize((ConfigTree)CONFIG_NODE, (InputStream)Files.newInputStream(CONFIG_PATH, new OpenOption[0]), (ValueSerializer)JANKSON_SERIALIZER);
                        break;
                    }
                    catch (ValueDeserializationException e) {
                        Constants.LOGGER.error("Found a syntax error in '{}'.", (Object)CONFIG_PATH.toString());
                        e.printStackTrace();
                        String deformedFile = "healthoverlay-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd_HH.mm.ss")) + ".json5";
                        Files.move(CONFIG_PATH, FabricLoader.getInstance().getConfigDir().resolve(deformedFile), new CopyOption[0]);
                        Constants.LOGGER.info("Deformed config file renamed to '{}'.", (Object)deformedFile);
                        continue;
                    }
                }
                Constants.LOGGER.info("Creating config file at '{}'.", (Object)CONFIG_PATH.toString());
                break;
            }
            FiberSerialization.serialize((ConfigTree)CONFIG_NODE, (OutputStream)Files.newOutputStream(CONFIG_PATH, new OpenOption[0]), (ValueSerializer)JANKSON_SERIALIZER);
            Constants.LOGGER.info("Successfully loaded '{}'.", (Object)CONFIG_PATH.toString());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        CONFIG_APPLY_LIST.forEach(Runnable::run);
    }

    private static <T> void configValue(PropertyMirror<T> configValue, Consumer<PropertyMirror<T>> consumer) {
        CONFIG_APPLY_LIST.add(() -> consumer.accept(configValue));
    }

    static {
        CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("healthoverlay.json5");
        LIST_MIN_SIZE = new FiberId("healthoverlay", "list_min_size");
        LIST_MAX_SIZE = new FiberId("healthoverlay", "list_max_size");
        CONFIG_APPLY_LIST = Lists.newArrayList();
        ListConfigType COLOR = ConfigTypes.makeList((ConfigType)ConfigTypes.STRING.withType(new StringSerializableType(7, 7, Pattern.compile("^#[0-9a-fA-F]{6}+$"))));
        EnumConfigType ABSORPTION_MODE = ConfigTypes.makeEnum(ModConfiguration.AbsorptionMode.class);
        ConfigTreeBuilder tree = ConfigTree.builder();
        ConfigAttribute listMinSizeAttribute = ConfigAttribute.create((FiberId)LIST_MIN_SIZE, (ConfigType)ConfigTypes.INTEGER, (Object)1);
        ConfigAttribute listMaxSizeAttribute = ConfigAttribute.create((FiberId)LIST_MAX_SIZE, (ConfigType)ConfigTypes.INTEGER, (Object)2);
        ConfigTreeBuilder healthCategory = tree.fork("health");
        PropertyMirror healthVanilla = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        healthCategory.beginValue("health_vanilla", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Show vanilla hearts").finishValue(arg_0 -> ((PropertyMirror)healthVanilla).mirror(arg_0));
        HealthOverlay.configValue(healthVanilla, value -> {
            ModConfiguration.healthVanilla = (Boolean)value.getValue();
        });
        PropertyMirror healthColors = PropertyMirror.create((ConfigType)COLOR);
        healthCategory.beginValue("health_colors", (ConfigType)COLOR.withMinSize(1), (Object)Lists.newArrayList((Object[])new String[]{"#F06E14", "#F5DC23", "#2DB928", "#1EAFBE", "#7346E1", "#FA7DEB", "#EB375A", "#FF8278", "#AAFFFA", "#EBEBFF"})).withComment("Colors for every 10 hearts (not counting the default red)\nAll values are written as hexadecimal RGB color in '#RRGGBB' format").withAttribute(listMinSizeAttribute).finishValue(arg_0 -> ((PropertyMirror)healthColors).mirror(arg_0));
        HealthOverlay.configValue(healthColors, value -> {
            ModConfiguration.healthColors = ModConfiguration.getColors((List)value.getValue(), false, false);
        });
        PropertyMirror healthPoisonColors = PropertyMirror.create((ConfigType)COLOR);
        healthCategory.beginValue("health_poison_colors", (ConfigType)COLOR.withMinSize(1).withMaxSize(2), (Object)Lists.newArrayList((Object[])new String[]{"#739B00", "#96CD00"})).withComment("Two alternating colors when poisoned\nThere can be one color in case vanilla poisoned heart is wanted").withAttribute(listMinSizeAttribute).withAttribute(listMaxSizeAttribute).finishValue(arg_0 -> ((PropertyMirror)healthPoisonColors).mirror(arg_0));
        HealthOverlay.configValue(healthPoisonColors, value -> {
            ModConfiguration.healthPoisonColors = ModConfiguration.getColors((List)value.getValue(), false, true);
        });
        PropertyMirror healthWitherColors = PropertyMirror.create((ConfigType)COLOR);
        healthCategory.beginValue("health_wither_colors", (ConfigType)COLOR.withMinSize(1).withMaxSize(2), (Object)Lists.newArrayList((Object[])new String[]{"#0F0F0F", "#2D2D2D"})).withComment("Two alternating colors when withered\nThere can be one color in case vanilla withered heart is wanted").withAttribute(listMinSizeAttribute).withAttribute(listMaxSizeAttribute).finishValue(arg_0 -> ((PropertyMirror)healthWitherColors).mirror(arg_0));
        HealthOverlay.configValue(healthWitherColors, value -> {
            ModConfiguration.healthWitherColors = ModConfiguration.getColors((List)value.getValue(), false, true);
        });
        PropertyMirror healthFrozenColors = PropertyMirror.create((ConfigType)COLOR);
        healthCategory.beginValue("health_frozen_colors", (ConfigType)COLOR.withMinSize(1).withMaxSize(2), (Object)Lists.newArrayList((Object[])new String[]{"#3E70E6", "#873EE6"})).withComment("Two alternating colors when freezing\nThere can be one color in case vanilla frozen heart is wanted").withAttribute(listMinSizeAttribute).withAttribute(listMaxSizeAttribute).finishValue(arg_0 -> ((PropertyMirror)healthFrozenColors).mirror(arg_0));
        HealthOverlay.configValue(healthFrozenColors, value -> {
            ModConfiguration.healthFrozenColors = ModConfiguration.getColors((List)value.getValue(), false, true);
        });
        healthCategory.finishBranch();
        ConfigTreeBuilder absorptionCategory = tree.fork("absorption");
        PropertyMirror absorptionVanilla = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        absorptionCategory.beginValue("absorption_vanilla", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).withComment("Show vanilla hearts").finishValue(arg_0 -> ((PropertyMirror)absorptionVanilla).mirror(arg_0));
        HealthOverlay.configValue(absorptionVanilla, value -> {
            ModConfiguration.absorptionVanilla = (Boolean)value.getValue();
        });
        PropertyMirror absorptionColors = PropertyMirror.create((ConfigType)COLOR);
        absorptionCategory.beginValue("absorption_colors", (ConfigType)COLOR.withMinSize(1), (Object)Lists.newArrayList((Object[])new String[]{"#E1FA9B", "#A0FFAF", "#AAFFFA", "#AACDFF", "#D7B4FF", "#FAA5FF", "#FFB4B4", "#FFAA7D", "#D7F0FF", "#EBFFFA"})).withComment("Colors for every 10 hearts (not counting the default yellow)\nAll values are written as hexadecimal RGB color in '#RRGGBB' format").withAttribute(listMinSizeAttribute).finishValue(arg_0 -> ((PropertyMirror)absorptionColors).mirror(arg_0));
        HealthOverlay.configValue(absorptionColors, value -> {
            ModConfiguration.absorptionColors = ModConfiguration.getColors((List)value.getValue(), true, false);
        });
        listMinSizeAttribute = ConfigAttribute.create((FiberId)LIST_MIN_SIZE, (ConfigType)ConfigTypes.INTEGER, (Object)2);
        PropertyMirror absorptionPoisonColors = PropertyMirror.create((ConfigType)COLOR);
        absorptionCategory.beginValue("absorption_poison_colors", (ConfigType)COLOR.withMinSize(2).withMaxSize(2), (Object)Lists.newArrayList((Object[])new String[]{"#BFF230", "#7AA15A"})).withComment("Two alternating colors when poisoned").withAttribute(listMinSizeAttribute).withAttribute(listMaxSizeAttribute).finishValue(arg_0 -> ((PropertyMirror)absorptionPoisonColors).mirror(arg_0));
        HealthOverlay.configValue(absorptionPoisonColors, value -> {
            ModConfiguration.absorptionPoisonColors = ModConfiguration.getColors((List)value.getValue(), true, true);
        });
        PropertyMirror absorptionWitherColors = PropertyMirror.create((ConfigType)COLOR);
        absorptionCategory.beginValue("absorption_wither_colors", (ConfigType)COLOR.withMinSize(2).withMaxSize(2), (Object)Lists.newArrayList((Object[])new String[]{"#787061", "#73625C"})).withComment("Two alternating colors when withered").withAttribute(listMinSizeAttribute).withAttribute(listMaxSizeAttribute).finishValue(arg_0 -> ((PropertyMirror)absorptionWitherColors).mirror(arg_0));
        HealthOverlay.configValue(absorptionWitherColors, value -> {
            ModConfiguration.absorptionWitherColors = ModConfiguration.getColors((List)value.getValue(), true, true);
        });
        PropertyMirror absorptionFrozenColors = PropertyMirror.create((ConfigType)COLOR);
        absorptionCategory.beginValue("absorption_frozen_colors", (ConfigType)COLOR.withMinSize(2).withMaxSize(2), (Object)Lists.newArrayList((Object[])new String[]{"#90D136", "#36D183"})).withComment("Two alternating colors when freezing").withAttribute(listMinSizeAttribute).withAttribute(listMaxSizeAttribute).finishValue(arg_0 -> ((PropertyMirror)absorptionFrozenColors).mirror(arg_0));
        HealthOverlay.configValue(absorptionFrozenColors, value -> {
            ModConfiguration.absorptionFrozenColors = ModConfiguration.getColors((List)value.getValue(), true, true);
        });
        ConfigTreeBuilder absorptionSubCategory = absorptionCategory.fork("advanced");
        PropertyMirror absorptionOverHealth = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        absorptionSubCategory.beginValue("absorption_over_health", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).withComment("Display absorption in the same row as health\nAbsorption is rendered after and over health depending on the mode").finishValue(arg_0 -> ((PropertyMirror)absorptionOverHealth).mirror(arg_0));
        HealthOverlay.configValue(absorptionOverHealth, value -> {
            ModConfiguration.absorptionOverHealth = (Boolean)value.getValue();
        });
        PropertyMirror absorptionOverHealthMode = PropertyMirror.create((ConfigType)ABSORPTION_MODE);
        absorptionSubCategory.beginValue("absorption_over_health_mode", (ConfigType)ABSORPTION_MODE, (Object)ModConfiguration.AbsorptionMode.AFTER_HEALTH).withComment("Display mode for absorption\nabsorption.advanced.absorption_over_health must be true\nModes:\n  \"BEGINNING\":\n    Absorption always starts at first heart.\n  \"AFTER_HEALTH\":\n    Absorption starts after the last highest health heart and loops back to first health heart if overflowing.\n    This means that health hearts will be hidden when absorption has 10 or more hearts.\n      Example 1: If a player has 10 health (5 hearts), absorption will render itself in the last\n                   five hearts and in case it is higher it will loop back over first five health hearts.\n      Example 2: If a player has more than 20 absorption, second color is shown the same way as in \"BEGINNING\".\n      Example 3: If player health is divisible by 20, absorption is shown the same way as in \"BEGINNING\".").finishValue(arg_0 -> ((PropertyMirror)absorptionOverHealthMode).mirror(arg_0));
        HealthOverlay.configValue(absorptionOverHealthMode, value -> {
            ModConfiguration.absorptionOverHealthMode = (ModConfiguration.AbsorptionMode)((Object)((Object)value.getValue()));
        });
        absorptionSubCategory.finishBranch();
        absorptionCategory.finishBranch();
        CONFIG_NODE = tree.build();
    }
}

