/*
 * Decompiled with CFR 0.152.
 */
package io.github.fablabsmc.fablabs.impl.fiber.constraint;

import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.MapSerializableType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.TypeCheckResult;
import io.github.fablabsmc.fablabs.impl.fiber.constraint.ConstraintChecker;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;

public class MapConstraintChecker<V>
extends ConstraintChecker<Map<String, V>, MapSerializableType<V>> {
    private static final MapConstraintChecker<?> INSTANCE = new MapConstraintChecker();

    public static <V> MapConstraintChecker<V> instance() {
        MapConstraintChecker<?> t = INSTANCE;
        return t;
    }

    private MapConstraintChecker() {
    }

    @Override
    public TypeCheckResult<Map<String, V>> test(MapSerializableType<V> cfg, Map<String, V> values) {
        boolean valid = true;
        int maxSize = cfg.getMaxSize();
        LinkedHashMap<String, V> corrected = new LinkedHashMap<String, V>();
        for (Map.Entry<String, V> entry : values.entrySet()) {
            if (corrected.size() >= maxSize) {
                valid = false;
                break;
            }
            TypeCheckResult<String> keyTestResult = cfg.getKeyType().test(entry.getKey());
            TypeCheckResult<V> valueTestResult = cfg.getValueType().test(entry.getValue());
            if (keyTestResult.hasPassed() && valueTestResult.hasPassed()) {
                corrected.put(entry.getKey(), entry.getValue());
                continue;
            }
            valid = false;
            Optional<String> correctedKey = keyTestResult.getCorrectedValue();
            Optional<V> correctedValue = valueTestResult.getCorrectedValue();
            if (!correctedKey.isPresent() || !correctedValue.isPresent()) continue;
            corrected.put(correctedKey.get(), correctedValue.get());
        }
        if (corrected.size() < cfg.getMinSize()) {
            return TypeCheckResult.unrecoverable();
        }
        if (!valid) {
            return TypeCheckResult.failed(corrected);
        }
        return TypeCheckResult.successful(values);
    }

    @Override
    public boolean comprehends(MapSerializableType<V> cfg, MapSerializableType<V> cfg2) {
        if (cfg.getMinSize() > cfg2.getMinSize()) {
            return false;
        }
        if (cfg.getMaxSize() < cfg2.getMaxSize()) {
            return false;
        }
        return cfg.getValueType().isAssignableFrom(cfg2.getValueType());
    }
}

