/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.clienttweaks;

import java.util.HashMap;
import java.util.Map;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.client.BalmClient;
import net.blay09.mods.clienttweaks.ClientTweaksConfig;
import net.blay09.mods.clienttweaks.ClientTweaksConfigData;
import net.blay09.mods.clienttweaks.ModKeyMappings;
import net.blay09.mods.clienttweaks.tweak.AbstractClientTweak;
import net.blay09.mods.clienttweaks.tweak.AdditionalVolumeSlider;
import net.blay09.mods.clienttweaks.tweak.AutoClimbLadder;
import net.blay09.mods.clienttweaks.tweak.DisableLogStripping;
import net.blay09.mods.clienttweaks.tweak.DoNotUseLastTorch;
import net.blay09.mods.clienttweaks.tweak.HideOffhandItem;
import net.blay09.mods.clienttweaks.tweak.HideOwnEffectParticles;
import net.blay09.mods.clienttweaks.tweak.HideShieldUnlessHoldingWeapon;
import net.blay09.mods.clienttweaks.tweak.NoOffhandTorchAtAll;
import net.blay09.mods.clienttweaks.tweak.NoOffhandTorchWithBlock;
import net.blay09.mods.clienttweaks.tweak.NoOffhandTorchWithEmptyHand;
import net.blay09.mods.clienttweaks.tweak.NoOffhandTorchWithFood;
import net.blay09.mods.clienttweaks.tweak.OffhandTorchWithToolOnly;
import net.blay09.mods.clienttweaks.tweak.StepAssistIsAnnoying;
import net.minecraft.class_3419;

public class ClientTweaks {
    public static final String MOD_ID = "clienttweaks";
    private static final Map<String, AbstractClientTweak> tweaks = new HashMap<String, AbstractClientTweak>();

    public static void initializeCommon() {
        ClientTweaksConfig.initialize();
    }

    public static void initializeClient() {
        ClientTweaks.registerTweak(new AdditionalVolumeSlider("masterVolumeSlider", class_3419.field_15250, 0){

            @Override
            public boolean isEnabled() {
                return ClientTweaksConfig.getActive().tweaks.masterVolumeSlider;
            }

            @Override
            public void setEnabled(boolean enabled) {
                Balm.getConfig().updateConfig(ClientTweaksConfigData.class, it -> {
                    it.tweaks.masterVolumeSlider = enabled;
                });
            }
        });
        ClientTweaks.registerTweak(new AdditionalVolumeSlider("musicVolumeSlider", class_3419.field_15253, 160){

            @Override
            public boolean isEnabled() {
                return ClientTweaksConfig.getActive().tweaks.musicVolumeSlider;
            }

            @Override
            public void setEnabled(boolean enabled) {
                Balm.getConfig().updateConfig(ClientTweaksConfigData.class, it -> {
                    it.tweaks.musicVolumeSlider = enabled;
                });
            }
        });
        ClientTweaks.registerTweak(new NoOffhandTorchAtAll());
        ClientTweaks.registerTweak(new NoOffhandTorchWithBlock());
        ClientTweaks.registerTweak(new NoOffhandTorchWithEmptyHand());
        ClientTweaks.registerTweak(new OffhandTorchWithToolOnly());
        ClientTweaks.registerTweak(new HideOwnEffectParticles());
        ClientTweaks.registerTweak(new HideOffhandItem());
        ClientTweaks.registerTweak(new StepAssistIsAnnoying());
        ClientTweaks.registerTweak(new AutoClimbLadder());
        ClientTweaks.registerTweak(new HideShieldUnlessHoldingWeapon());
        ClientTweaks.registerTweak(new DoNotUseLastTorch());
        ClientTweaks.registerTweak(new DisableLogStripping());
        ClientTweaks.registerTweak(new NoOffhandTorchWithFood());
        ModKeyMappings.initialize(BalmClient.getKeyMappings(), tweaks.values());
    }

    private static void registerTweak(AbstractClientTweak tweak) {
        tweaks.put(tweak.getName(), tweak);
    }
}

