/*
 * Decompiled with CFR 0.152.
 */
package draylar.staticcontent;

import com.google.common.collect.ImmutableSet;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import draylar.staticcontent.api.ContentData;
import draylar.staticcontent.gson.IdentifierDeserializer;
import io.github.cottonmc.staticdata.StaticData;
import io.github.cottonmc.staticdata.StaticDataItem;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.ModInitializer;
import net.minecraft.class_2960;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StaticContent
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"Static Content");
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(class_2960.class, (Object)new IdentifierDeserializer()).create();
    private static final List<String> USED_DIRECTORIES = new ArrayList<String>();

    public void onInitialize() {
    }

    public static void load(class_2960 directory, Class<? extends ContentData> dataClass) {
        if (USED_DIRECTORIES.contains(directory.toString())) {
            throw new UnsupportedOperationException(String.format("%s was already registered as a data directory key!", directory));
        }
        ImmutableSet dataSet = StaticData.getAllInDirectory((String)String.format("%s/%s", directory.method_12836(), directory.method_12832()));
        for (StaticDataItem data : dataSet) {
            try {
                InputStreamReader reader = new InputStreamReader(data.createInputStream(), StandardCharsets.UTF_8);
                ((ContentData)GSON.fromJson((Reader)reader, dataClass)).register(data.getIdentifier());
                reader.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        LOGGER.info(String.format("Loaded %d Static Content file%s for %s", dataSet.size(), dataSet.size() == 1 ? "" : "s", directory));
        USED_DIRECTORIES.add(directory.toString());
    }
}

