/*
 * Decompiled with CFR 0.152.
 */
package com.aqupd.caracal.entity;

import com.aqupd.caracal.CaracalMain;
import com.aqupd.caracal.ai.CaracalSitOnBlockGoal;
import com.aqupd.caracal.utils.AqConfig;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1341;
import net.minecraft.class_1347;
import net.minecraft.class_1350;
import net.minecraft.class_1352;
import net.minecraft.class_1359;
import net.minecraft.class_1361;
import net.minecraft.class_1371;
import net.minecraft.class_1374;
import net.minecraft.class_1379;
import net.minecraft.class_1386;
import net.minecraft.class_1391;
import net.minecraft.class_1403;
import net.minecraft.class_1404;
import net.minecraft.class_1420;
import net.minecraft.class_1428;
import net.minecraft.class_1429;
import net.minecraft.class_1451;
import net.minecraft.class_1463;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2244;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_3532;
import net.minecraft.class_39;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_47;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import org.jetbrains.annotations.Nullable;

public class CaracalEntity
extends class_1321 {
    private static final class_1856 TAMING_INGREDIENT;
    private static final class_2940<Boolean> IN_SLEEPING_POSE;
    private TemptGoal temptGoal;
    private static double health;
    private static double speed;
    private static double follow;
    private static double damage;
    private static double knockback;
    private boolean commander;

    public CaracalEntity(class_1299<? extends CaracalEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    protected void method_5959() {
        this.temptGoal = new TemptGoal(this, 1.0, TAMING_INGREDIENT, true);
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(2, (class_1352)new class_1350((class_1321)this, 1.0, 10.0f, 5.0f, false));
        this.field_6201.method_6277(2, (class_1352)new SleepWithOwnerGoal(this));
        this.field_6201.method_6277(3, (class_1352)new class_1374((class_1314)this, 1.4));
        this.field_6201.method_6277(3, (class_1352)new class_1341((class_1429)this, 1.0));
        this.field_6201.method_6277(3, (class_1352)this.temptGoal);
        this.field_6201.method_6277(5, (class_1352)new class_1359((class_1308)this, 0.3f));
        this.field_6201.method_6277(6, (class_1352)new class_1371((class_1308)this));
        this.field_6201.method_6277(7, (class_1352)new CaracalSitOnBlockGoal(this, 0.8));
        this.field_6201.method_6277(7, (class_1352)new class_1361((class_1308)this, class_1657.class, 10.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1379((class_1314)this, 0.5));
        this.field_6185.method_6277(1, (class_1352)new class_1404((class_1321)this, class_1657.class, false, livingEntity -> livingEntity.method_5845().equals("06e02a3f-dc56-43b5-95b9-191387a59e01")));
        this.field_6185.method_6277(1, (class_1352)new class_1403((class_1321)this));
        this.field_6185.method_6277(3, (class_1352)new class_1404((class_1321)this, class_1428.class, true, null));
        this.field_6185.method_6277(3, (class_1352)new class_1404((class_1321)this, class_1463.class, true, null));
        this.field_6185.method_6277(3, (class_1352)new class_1404((class_1321)this, class_1420.class, true, null));
    }

    public void method_5958() {
        if (this.method_5962().method_6241()) {
            double d = this.method_5962().method_6242();
            if (d == 0.6) {
                this.method_18380(class_4050.field_18081);
                this.method_5728(false);
            } else if (d == 1.33) {
                this.method_18380(class_4050.field_18076);
                this.method_5728(true);
            } else {
                this.method_18380(class_4050.field_18076);
                this.method_5728(false);
            }
        } else {
            this.method_18380(class_4050.field_18076);
            this.method_5728(false);
        }
        this.updateAnimations();
    }

    private void updateAnimations() {
        if (this.isInSleepingPose() && this.field_6012 % 5 == 0) {
            this.method_5783(class_3417.field_14741, 0.6f + 0.4f * (this.field_5974.nextFloat() - this.field_5974.nextFloat()), 1.0f);
        }
    }

    public static class_5132.class_5133 createcaracalAttributes() {
        return class_1296.method_26827().method_26868(class_5134.field_23716, health).method_26868(class_5134.field_23719, speed).method_26868(class_5134.field_23717, follow).method_26868(class_5134.field_23721, damage).method_26868(class_5134.field_23722, knockback);
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        if (this.commander) {
            tag.method_10556("Commander", true);
        }
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        if (tag.method_10573("Commander", 99)) {
            this.commander = tag.method_10577("Commander");
        }
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        if (this.method_5797() != null) {
            String n = this.method_5797().method_10851().toLowerCase(Locale.ENGLISH);
            this.commander = (n.contains("\u043a\u043e\u043c\u0430\u043d\u0434\u0438\u0440") || n.contains("commander")) && !n.contains("\u043c\u0438\u0440\u043d\u044b\u0439") && !n.contains("peaceful");
        }
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    @Nullable
    protected class_3414 method_5994() {
        if (!this.isInSleepingPose() || this.field_6012 % 5 != 0) {
            return CaracalMain.CARACAL_AMBIENT;
        }
        return null;
    }

    public int method_5970() {
        return ThreadLocalRandom.current().nextInt(300, 1201);
    }

    protected class_3414 method_6011(class_1282 source) {
        return CaracalMain.CARACAL_HISS;
    }

    protected class_3414 method_6002() {
        return class_3417.field_16442;
    }

    private float getAttackDamage() {
        return (float)this.method_26825(class_5134.field_23721);
    }

    public boolean method_6121(class_1297 target) {
        return target.method_5643(class_1282.method_5511((class_1309)this), this.getAttackDamage());
    }

    protected void method_6475(class_1657 player, class_1268 hand, class_1799 stack) {
        if (this.method_6481(stack)) {
            this.method_5783(class_3417.field_16439, 1.0f, 1.0f);
        }
        super.method_6475(player, hand, stack);
    }

    @Nullable
    public class_1296 method_5613(class_3218 serverWorld, class_1296 passiveEntity) {
        CaracalEntity caracalEntity = (CaracalEntity)CaracalMain.CARACAL.method_5883((class_1937)serverWorld);
        if (passiveEntity instanceof CaracalEntity && this.method_6181()) {
            assert (caracalEntity != null);
            caracalEntity.method_6174(this.method_6139());
            caracalEntity.method_6173(true);
        }
        return caracalEntity;
    }

    public boolean method_6474(class_1429 other) {
        if (!this.method_6181()) {
            return false;
        }
        if (!(other instanceof CaracalEntity)) {
            return false;
        }
        CaracalEntity caracalEntity = (CaracalEntity)other;
        return caracalEntity.method_6181() && super.method_6474(other);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(IN_SLEEPING_POSE, (Object)false);
    }

    public void setInSleepingPose(boolean sleeping) {
        this.field_6011.method_12778(IN_SLEEPING_POSE, (Object)sleeping);
    }

    public boolean isInSleepingPose() {
        return (Boolean)this.field_6011.method_12789(IN_SLEEPING_POSE);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1269 actionResult;
        class_1799 itemStack = player.method_5998(hand);
        class_1792 item = itemStack.method_7909();
        if (this.field_6002.field_9236) {
            if (this.method_6181() && this.method_6171((class_1309)player)) {
                return class_1269.field_5812;
            }
            return !this.method_6481(itemStack) || !(this.method_6032() < this.method_6063()) && this.method_6181() ? class_1269.field_5811 : class_1269.field_5812;
        }
        if (this.method_6181()) {
            if (this.method_6171((class_1309)player)) {
                if (item.method_19263() && this.method_6481(itemStack) && this.method_6032() < this.method_6063()) {
                    this.method_6475(player, hand, itemStack);
                    this.method_6025(item.method_19264().method_19230());
                    return class_1269.field_21466;
                }
                class_1269 actionResult2 = super.method_5992(player, hand);
                if (!actionResult2.method_23665() || this.method_6109()) {
                    this.method_24346(!this.method_24345());
                }
                return actionResult2;
            }
        } else if (this.method_6481(itemStack)) {
            this.method_6475(player, hand, itemStack);
            if (this.field_5974.nextInt(3) == 0) {
                this.method_6170(player);
                this.method_24346(true);
                this.field_6002.method_8421((class_1297)this, (byte)7);
            } else {
                this.field_6002.method_8421((class_1297)this, (byte)6);
            }
            this.method_5971();
            return class_1269.field_21466;
        }
        if ((actionResult = super.method_5992(player, hand)).method_23665()) {
            this.method_5971();
        }
        return actionResult;
    }

    public boolean method_6481(class_1799 stack) {
        return TAMING_INGREDIENT.method_8093(stack);
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return dimensions.field_18068 * 0.98f;
    }

    public boolean method_5974(double distanceSquared) {
        return !this.method_6181() && this.field_6012 > 2400;
    }

    @Environment(value=EnvType.CLIENT)
    public class_243 method_29919() {
        return new class_243(0.0, (double)(0.5f * this.method_5751()), (double)(this.method_17681() * 0.4f));
    }

    static {
        health = AqConfig.INSTANCE.getDoubleProperty("entity.health");
        speed = AqConfig.INSTANCE.getDoubleProperty("entity.speed");
        follow = AqConfig.INSTANCE.getDoubleProperty("entity.follow");
        damage = AqConfig.INSTANCE.getDoubleProperty("entity.damage");
        knockback = AqConfig.INSTANCE.getDoubleProperty("entity.knockback");
        TAMING_INGREDIENT = class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8429, class_1802.field_8209, class_1802.field_8726, class_1802.field_8504});
        IN_SLEEPING_POSE = class_2945.method_12791(class_1451.class, (class_2941)class_2943.field_13323);
    }

    static class TemptGoal
    extends class_1391 {
        @Nullable
        private class_1657 player;
        private final CaracalEntity caracalEntity;

        public TemptGoal(CaracalEntity caracalEntity, double speed, class_1856 food, boolean canBeScared) {
            super((class_1314)caracalEntity, speed, food, canBeScared);
            this.caracalEntity = caracalEntity;
        }

        public void method_6268() {
            super.method_6268();
            if (this.player == null && this.field_6616.method_6051().nextInt(600) == 0) {
                this.player = this.field_6617;
            } else if (this.field_6616.method_6051().nextInt(500) == 0) {
                this.player = null;
            }
        }

        protected boolean method_16081() {
            return (this.player == null || !this.player.equals((Object)this.field_6617)) && super.method_16081();
        }

        public boolean method_6264() {
            return super.method_6264() && !this.caracalEntity.method_6181();
        }
    }

    static class SleepWithOwnerGoal
    extends class_1352 {
        private final CaracalEntity caracalEntity;
        private class_1657 owner;
        private class_2338 bedPos;
        private int ticksOnBed;

        public SleepWithOwnerGoal(CaracalEntity caracalEntity) {
            this.caracalEntity = caracalEntity;
        }

        public boolean method_6264() {
            if (!this.caracalEntity.method_6181()) {
                return false;
            }
            if (this.caracalEntity.method_24345()) {
                return false;
            }
            class_1309 livingEntity = this.caracalEntity.method_6177();
            if (livingEntity instanceof class_1657) {
                this.owner = (class_1657)livingEntity;
                if (!livingEntity.method_6113()) {
                    return false;
                }
                if (this.caracalEntity.method_5858((class_1297)this.owner) > 100.0) {
                    return false;
                }
                class_2338 blockPos = this.owner.method_24515();
                class_2680 blockState = this.caracalEntity.field_6002.method_8320(blockPos);
                if (blockState.method_26164((class_3494)class_3481.field_16443)) {
                    this.bedPos = blockState.method_28500((class_2769)class_2244.field_11177).map(direction -> blockPos.method_10093(direction.method_10153())).orElseGet(() -> new class_2338((class_2382)blockPos));
                    return !this.cannotSleep();
                }
            }
            return false;
        }

        private boolean cannotSleep() {
            CaracalEntity caracalEntity;
            List list = this.caracalEntity.field_6002.method_18467(CaracalEntity.class, new class_238(this.bedPos).method_1014(2.0));
            Iterator var2 = list.iterator();
            do {
                if (var2.hasNext()) continue;
                return false;
            } while ((caracalEntity = (CaracalEntity)((Object)var2.next())) == this.caracalEntity || !caracalEntity.isInSleepingPose());
            return true;
        }

        public boolean method_6266() {
            return this.caracalEntity.method_6181() && !this.caracalEntity.method_24345() && this.owner != null && this.owner.method_6113() && this.bedPos != null && !this.cannotSleep();
        }

        public void method_6269() {
            if (this.bedPos != null) {
                this.caracalEntity.method_6179(false);
                this.caracalEntity.method_5942().method_6337((double)this.bedPos.method_10263(), (double)this.bedPos.method_10264(), (double)this.bedPos.method_10260(), (double)1.1f);
            }
        }

        public void method_6270() {
            this.caracalEntity.setInSleepingPose(false);
            float f = this.caracalEntity.field_6002.method_30274(1.0f);
            if (this.owner.method_7297() >= 100 && (double)f > 0.77 && (double)f < 0.8 && (double)this.caracalEntity.field_6002.method_8409().nextFloat() < 0.7) {
                this.dropMorningGifts();
            }
            this.ticksOnBed = 0;
            this.caracalEntity.method_5942().method_6340();
        }

        private void dropMorningGifts() {
            Random random = this.caracalEntity.method_6051();
            class_2338.class_2339 mutable = new class_2338.class_2339();
            mutable.method_10101((class_2382)this.caracalEntity.method_24515());
            this.caracalEntity.method_6082(mutable.method_10263() + random.nextInt(11) - 5, mutable.method_10264() + random.nextInt(5) - 2, mutable.method_10260() + random.nextInt(11) - 5, false);
            mutable.method_10101((class_2382)this.caracalEntity.method_24515());
            class_52 lootTable = this.caracalEntity.field_6002.method_8503().method_3857().method_367(class_39.field_16216);
            class_47.class_48 builder = new class_47.class_48((class_3218)this.caracalEntity.field_6002).method_312(class_181.field_24424, (Object)this.caracalEntity.method_19538()).method_312(class_181.field_1226, (Object)this.caracalEntity).method_311(random);
            List list = lootTable.method_319(builder.method_309(class_173.field_16235));
            for (class_1799 itemStack : list) {
                this.caracalEntity.field_6002.method_8649((class_1297)new class_1542(this.caracalEntity.field_6002, (double)mutable.method_10263() - (double)class_3532.method_15374((float)(this.caracalEntity.field_6283 * ((float)Math.PI / 180))), (double)mutable.method_10264(), (double)mutable.method_10260() + (double)class_3532.method_15362((float)(this.caracalEntity.field_6283 * ((float)Math.PI / 180))), itemStack));
            }
        }

        public void method_6268() {
            if (this.owner != null && this.bedPos != null) {
                this.caracalEntity.method_6179(false);
                this.caracalEntity.method_5942().method_6337((double)this.bedPos.method_10263(), (double)this.bedPos.method_10264(), (double)this.bedPos.method_10260(), (double)1.1f);
                if (this.caracalEntity.method_5858((class_1297)this.owner) < 2.5) {
                    ++this.ticksOnBed;
                    if (this.ticksOnBed > 16) {
                        this.caracalEntity.setInSleepingPose(true);
                    } else {
                        this.caracalEntity.method_5951((class_1297)this.owner, 45.0f, 45.0f);
                    }
                } else {
                    this.caracalEntity.setInSleepingPose(false);
                }
            }
        }
    }
}

