/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.jankson;

import blue.endless.jankson.JsonArray;
import blue.endless.jankson.JsonElement;
import blue.endless.jankson.JsonNull;
import blue.endless.jankson.JsonObject;
import blue.endless.jankson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class JanksonOps
implements DynamicOps<JsonElement> {
    public static final JanksonOps INSTANCE = new JanksonOps(false);
    public static final JanksonOps COMPRESSED = new JanksonOps(true);
    private final boolean compressed;

    protected JanksonOps(boolean compressed) {
        this.compressed = compressed;
    }

    public JsonElement empty() {
        return JsonNull.INSTANCE;
    }

    public <U> U convertTo(DynamicOps<U> outOps, JsonElement input) {
        if (input instanceof JsonObject) {
            return (U)this.convertMap(outOps, input);
        }
        if (input instanceof JsonArray) {
            return (U)this.convertList(outOps, input);
        }
        if (input instanceof JsonPrimitive) {
            Object value = ((JsonPrimitive)input).getValue();
            if (value instanceof Byte) {
                return (U)outOps.createByte(((Byte)value).byteValue());
            }
            if (value instanceof Short) {
                return (U)outOps.createShort(((Short)value).shortValue());
            }
            if (value instanceof Integer) {
                return (U)outOps.createInt(((Integer)value).intValue());
            }
            if (value instanceof Long) {
                return (U)outOps.createLong(((Long)value).longValue());
            }
            if (value instanceof Float) {
                return (U)outOps.createFloat(((Float)value).floatValue());
            }
            if (value instanceof Double) {
                return (U)outOps.createDouble(((Double)value).doubleValue());
            }
            if (value instanceof Number) {
                return (U)outOps.createNumeric((Number)value);
            }
            if (value instanceof Boolean) {
                return (U)outOps.createBoolean(((Boolean)value).booleanValue());
            }
            if (value instanceof String) {
                return (U)outOps.createString((String)value);
            }
        }
        return (U)outOps.empty();
    }

    public DataResult<Number> getNumberValue(JsonElement input) {
        if (input instanceof JsonPrimitive) {
            Object value = ((JsonPrimitive)input).getValue();
            if (value instanceof Number) {
                return DataResult.success((Object)((Number)value));
            }
            if (value instanceof Boolean) {
                return DataResult.success((Object)((Boolean)value != false ? 1 : 0));
            }
            if (this.compressed && value instanceof String) {
                try {
                    return DataResult.success((Object)Integer.parseInt((String)value));
                }
                catch (NumberFormatException e) {
                    return DataResult.error((String)("Not a number: " + e + " " + input));
                }
            }
        }
        return DataResult.error((String)("Not a number: " + input));
    }

    public JsonElement createNumeric(Number i) {
        return new JsonPrimitive((Object)i);
    }

    public DataResult<String> getStringValue(JsonElement input) {
        if (input instanceof JsonPrimitive) {
            JsonPrimitive primitive = (JsonPrimitive)input;
            if (this.compressed || primitive.getValue() instanceof String) {
                return DataResult.success((Object)primitive.asString());
            }
        }
        return DataResult.error((String)("Not a string: " + input));
    }

    public JsonElement createString(String value) {
        return new JsonPrimitive((Object)value);
    }

    public JsonElement createBoolean(boolean value) {
        return value ? JsonPrimitive.TRUE : JsonPrimitive.FALSE;
    }

    public DataResult<JsonElement> mergeToList(JsonElement list, JsonElement value) {
        if (list instanceof JsonNull) {
            JsonArray output = new JsonArray();
            output.add(value);
            return DataResult.success((Object)output);
        }
        if (list instanceof JsonArray) {
            JsonArray output = new JsonArray();
            output.addAll((Collection)((JsonArray)list));
            output.add(value);
            return DataResult.success((Object)output);
        }
        return DataResult.error((String)("Not an array: " + list));
    }

    public DataResult<JsonElement> mergeToMap(JsonElement map, JsonElement key, JsonElement value) {
        if (!(key instanceof JsonPrimitive) || !(((JsonPrimitive)key).getValue() instanceof String) && !this.compressed) {
            return DataResult.error((String)("Key is not a string: " + key));
        }
        if (map instanceof JsonNull) {
            JsonObject output = new JsonObject();
            output.put(((JsonPrimitive)key).asString(), value);
            return DataResult.success((Object)output);
        }
        if (map instanceof JsonObject) {
            JsonObject output = new JsonObject();
            output.put(((JsonPrimitive)key).asString(), value);
            output.putAll((Map)((JsonObject)map));
            return DataResult.success((Object)output);
        }
        return DataResult.error((String)("Not a JSON object: " + map));
    }

    public DataResult<JsonElement> mergeToMap(JsonElement map, MapLike<JsonElement> values) {
        if (!(map instanceof JsonObject) && !(map instanceof JsonNull)) {
            return DataResult.error((String)("Not a JSON object: " + map));
        }
        JsonObject result = new JsonObject();
        if (map instanceof JsonObject) {
            result.putAll((Map)((JsonObject)map));
        }
        ArrayList invalidKeys = new ArrayList();
        values.entries().forEach(entry -> {
            JsonElement key = (JsonElement)entry.getFirst();
            if (!(key instanceof JsonPrimitive) || !(((JsonPrimitive)key).getValue() instanceof String) || this.compressed) {
                invalidKeys.add(key);
                return;
            }
            result.put(((JsonPrimitive)key).asString(), (JsonElement)entry.getSecond());
        });
        if (!invalidKeys.isEmpty()) {
            return DataResult.error((String)("Some keys are not strings: " + invalidKeys), (Object)result);
        }
        return DataResult.success((Object)result);
    }

    public DataResult<Stream<Pair<JsonElement, JsonElement>>> getMapValues(JsonElement input) {
        if (input instanceof JsonObject) {
            return DataResult.success(((JsonObject)input).entrySet().stream().map(entry -> new Pair((Object)new JsonPrimitive(entry.getKey()), (Object)((JsonElement)entry.getValue()))));
        }
        return DataResult.error((String)("Not a JSON object: " + input));
    }

    public JsonElement createMap(Map<JsonElement, JsonElement> map) {
        JsonObject result = new JsonObject();
        for (Map.Entry<JsonElement, JsonElement> entry : map.entrySet()) {
            result.put(((JsonPrimitive)entry.getKey()).asString(), entry.getValue());
        }
        return result;
    }

    public JsonElement createMap(Stream<Pair<JsonElement, JsonElement>> map) {
        JsonObject result = new JsonObject();
        map.forEach(pair -> result.put(((JsonPrimitive)pair.getFirst()).asString(), (JsonElement)pair.getSecond()));
        return result;
    }

    public DataResult<MapLike<JsonElement>> getMap(JsonElement input) {
        if (!(input instanceof JsonObject)) {
            return DataResult.error((String)("Not a JSON object: " + input));
        }
        final JsonObject obj = (JsonObject)input;
        return DataResult.success((Object)new MapLike<JsonElement>(){

            public JsonElement get(JsonElement key) {
                return obj.get((Object)((JsonPrimitive)key).asString());
            }

            public JsonElement get(String key) {
                return obj.get((Object)key);
            }

            public Stream<Pair<JsonElement, JsonElement>> entries() {
                return obj.entrySet().stream().map(entry -> new Pair((Object)new JsonPrimitive(entry.getKey()), (Object)((JsonElement)entry.getValue())));
            }

            public String toString() {
                return "MapLike[" + obj + "]";
            }
        });
    }

    public DataResult<Stream<JsonElement>> getStream(JsonElement input) {
        if (input instanceof JsonArray) {
            return DataResult.success((Object)((JsonArray)input).stream());
        }
        return DataResult.error((String)("Not an array: " + input));
    }

    public JsonElement createList(Stream<JsonElement> input) {
        JsonArray result = new JsonArray();
        input.forEach(arg_0 -> ((JsonArray)result).add(arg_0));
        return result;
    }

    public DataResult<Consumer<Consumer<JsonElement>>> getList(JsonElement input) {
        if (!(input instanceof JsonArray)) {
            return DataResult.error((String)("Not an array: " + input));
        }
        return DataResult.success(sink -> {
            for (JsonElement element : (JsonArray)input) {
                sink.accept(element);
            }
        });
    }

    public boolean compressMaps() {
        return this.compressed;
    }

    public JsonElement emptyList() {
        return new JsonArray();
    }

    public JsonElement emptyMap() {
        return new JsonObject();
    }

    public JsonElement remove(JsonElement input, String key) {
        if (input instanceof JsonObject) {
            JsonObject result = new JsonObject();
            for (Map.Entry entry : ((JsonObject)input).entrySet()) {
                if (((String)entry.getKey()).equals(key)) continue;
                result.put((String)entry.getKey(), (JsonElement)entry.getValue());
            }
            return result;
        }
        return input;
    }

    public String toString() {
        return "Jankson";
    }
}

