/*
 * Decompiled with CFR 0.152.
 */
package net.barribob.boss.mob.mobs.gauntlet;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.barribob.boss.mob.mobs.gauntlet.GauntletEntity;
import net.barribob.boss.mob.mobs.gauntlet.LaserAction;
import net.barribob.boss.mob.utils.IEntityTick;
import net.barribob.boss.mob.utils.IStatusHandler;
import net.barribob.boss.mob.utils.ITrackedDataHandler;
import net.barribob.boss.particle.ClientParticleBuilder;
import net.barribob.boss.particle.Particles;
import net.barribob.boss.utils.ModColors;
import net.barribob.maelstrom.general.data.HistoricalData;
import net.barribob.maelstrom.general.event.EventScheduler;
import net.barribob.maelstrom.general.event.IEvent;
import net.barribob.maelstrom.general.event.TimedEvent;
import net.barribob.maelstrom.static_utilities.MobUtilsKt;
import net.barribob.maelstrom.static_utilities.RandomUtils;
import net.barribob.maelstrom.static_utilities.VecUtils;
import net.barribob.maelstrom.static_utilities.VecUtilsKt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2940;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u00032\u00020\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\n\u0010\u0018\u001a\u0004\u0018\u00010\u000bH\u0002J\u0014\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u0016H\u0007J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0002J\u0006\u0010 \u001a\u00020\u001bJ\u0014\u0010!\u001a\u00020\u001b2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#H\u0016J\b\u0010$\u001a\u00020\u001fH\u0007J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010&\u001a\u00020\u0002H\u0016R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00170\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lnet/barribob/boss/mob/mobs/gauntlet/GauntletClientLaserHandler;", "Lnet/barribob/boss/mob/utils/IEntityTick;", "Lnet/minecraft/client/world/ClientWorld;", "Lnet/barribob/boss/mob/utils/ITrackedDataHandler;", "Lnet/barribob/boss/mob/utils/IStatusHandler;", "entity", "Lnet/barribob/boss/mob/mobs/gauntlet/GauntletEntity;", "eventScheduler", "Lnet/barribob/maelstrom/general/event/EventScheduler;", "(Lnet/barribob/boss/mob/mobs/gauntlet/GauntletEntity;Lnet/barribob/maelstrom/general/event/EventScheduler;)V", "cachedBeamTarget", "Lnet/minecraft/entity/LivingEntity;", "getEntity", "()Lnet/barribob/boss/mob/mobs/gauntlet/GauntletEntity;", "getEventScheduler", "()Lnet/barribob/maelstrom/general/event/EventScheduler;", "laserChargeParticles", "Lnet/barribob/boss/particle/ClientParticleBuilder;", "getLaserChargeParticles", "()Lnet/barribob/boss/particle/ClientParticleBuilder;", "laserRenderPositions", "Lnet/barribob/maelstrom/general/data/HistoricalData;", "Lkotlin/Pair;", "Lnet/minecraft/util/math/Vec3d;", "getBeamTarget", "getLaserRenderPos", "handleClientStatus", "", "status", "", "hasBeamTarget", "", "initDataTracker", "onTrackedDataSet", "data", "Lnet/minecraft/entity/data/TrackedData;", "shouldRenderLaser", "tick", "world", "BOMD"})
public final class GauntletClientLaserHandler
implements IEntityTick<class_638>,
ITrackedDataHandler,
IStatusHandler {
    @NotNull
    private final GauntletEntity entity;
    @NotNull
    private final EventScheduler eventScheduler;
    @Nullable
    private class_1309 cachedBeamTarget;
    @NotNull
    private final HistoricalData<Pair<class_243, class_243>> laserRenderPositions;
    @NotNull
    private final ClientParticleBuilder laserChargeParticles;

    public GauntletClientLaserHandler(@NotNull GauntletEntity entity, @NotNull EventScheduler eventScheduler) {
        Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
        Intrinsics.checkNotNullParameter((Object)eventScheduler, (String)"eventScheduler");
        this.entity = entity;
        this.eventScheduler = eventScheduler;
        this.laserRenderPositions = new HistoricalData((Object)new Pair((Object)class_243.field_1353, (Object)class_243.field_1353), 8);
        this.laserChargeParticles = new ClientParticleBuilder((class_2394)Particles.INSTANCE.getSPARKLES()).brightness(0xF000F0).color(ModColors.INSTANCE.getLASER_RED()).colorVariation(0.2);
    }

    @NotNull
    public final GauntletEntity getEntity() {
        return this.entity;
    }

    @NotNull
    public final EventScheduler getEventScheduler() {
        return this.eventScheduler;
    }

    @NotNull
    public final ClientParticleBuilder getLaserChargeParticles() {
        return this.laserChargeParticles;
    }

    @Override
    public void tick(@NotNull class_638 world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        class_1309 beamTarget = this.getBeamTarget();
        if (beamTarget != null) {
            class_243 centerBoxOffset = beamTarget.method_5829().method_1005().method_1020(beamTarget.method_19538());
            this.laserRenderPositions.set((Object)new Pair((Object)beamTarget.method_19538().method_1019(centerBoxOffset), (Object)MobUtilsKt.getLastRenderPos((class_1297)((class_1297)beamTarget)).method_1019(centerBoxOffset)));
        } else {
            this.laserRenderPositions.clear();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public final boolean shouldRenderLaser() {
        return this.laserRenderPositions.getSize() > 1;
    }

    @Environment(value=EnvType.CLIENT)
    @NotNull
    public final Pair<class_243, class_243> getLaserRenderPos() {
        Pair laserPos = (Pair)CollectionsKt.first((List)this.laserRenderPositions.getAll());
        class_243 newPos = LaserAction.Companion.extendLaser((class_1297)this.entity, (class_243)laserPos.getFirst());
        class_243 prevPos = LaserAction.Companion.extendLaser((class_1297)this.entity, (class_243)laserPos.getSecond());
        class_3965 newResult = this.entity.field_6002.method_17742(new class_3959(MobUtilsKt.eyePos((class_1297)((class_1297)this.entity)), newPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.entity));
        class_3965 prevResult = this.entity.field_6002.method_17742(new class_3959(MobUtilsKt.eyePos((class_1297)((class_1297)this.entity)), prevPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this.entity));
        class_243 colNewPos = newResult.method_17783() == class_239.class_240.field_1332 ? newResult.method_17784() : newPos;
        class_243 colPrevPos = prevResult.method_17783() == class_239.class_240.field_1332 ? prevResult.method_17784() : prevPos;
        return new Pair((Object)colNewPos, (Object)colPrevPos);
    }

    private final boolean hasBeamTarget() {
        Object object = this.entity.method_5841().method_12789(GauntletEntity.Companion.getLaserTarget());
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
        }
        return (Integer)object != 0;
    }

    private final class_1309 getBeamTarget() {
        class_1309 class_13092;
        if (!this.hasBeamTarget()) {
            class_13092 = null;
        } else if (this.entity.field_6002.field_9236) {
            if (this.cachedBeamTarget != null) {
                class_13092 = this.cachedBeamTarget;
            } else {
                Object object = this.entity.method_5841().method_12789(GauntletEntity.Companion.getLaserTarget());
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                }
                class_1297 entity = this.entity.field_6002.method_8469(((Integer)object).intValue());
                class_13092 = entity instanceof class_1309 ? (this.cachedBeamTarget = (class_1309)entity) : (class_1309)null;
            }
        } else {
            class_13092 = this.entity.method_5968();
        }
        return class_13092;
    }

    @Override
    public void onTrackedDataSet(@NotNull class_2940<?> data) {
        Intrinsics.checkNotNullParameter(data, (String)"data");
        if (Intrinsics.areEqual(GauntletEntity.Companion.getLaserTarget(), data)) {
            this.cachedBeamTarget = null;
        }
    }

    public final void initDataTracker() {
        this.entity.method_5841().method_12784(GauntletEntity.Companion.getLaserTarget(), (Object)0);
    }

    @Override
    public void handleClientStatus(byte status) {
        if (status == 8) {
            this.eventScheduler.addEvent((IEvent)new TimedEvent((Function0)new Function0<Unit>(this){
                final /* synthetic */ GauntletClientLaserHandler this$0;
                {
                    this.this$0 = $receiver;
                    super(0);
                }

                public final void invoke() {
                    class_243 lookVec = this.this$0.getEntity().method_5720();
                    int n = 0;
                    while (n < 2) {
                        int i = n++;
                        class_243 class_2432 = lookVec.method_1036(VecUtils.INSTANCE.getYAxis());
                        Intrinsics.checkNotNullExpressionValue((Object)class_2432, (String)"lookVec.crossProduct(VecUtils.yAxis)");
                        Intrinsics.checkNotNullExpressionValue((Object)lookVec, (String)"lookVec");
                        class_243 circularOffset = VecUtilsKt.rotateVector((class_243)class_2432, (class_243)lookVec, (double)RandomUtils.INSTANCE.range(0, 359));
                        class_243 velocity = circularOffset.method_1029().method_22882().method_1021(0.07).method_1019(this.this$0.getEntity().method_18798().method_1021(1.2));
                        class_243 position = MobUtilsKt.eyePos((class_1297)((class_1297)this.this$0.getEntity())).method_1019(circularOffset).method_1019(lookVec.method_1021(0.5));
                        ClientParticleBuilder clientParticleBuilder = this.this$0.getLaserChargeParticles();
                        Intrinsics.checkNotNullExpressionValue((Object)position, (String)"position");
                        Intrinsics.checkNotNullExpressionValue((Object)velocity, (String)"velocity");
                        clientParticleBuilder.build(position, velocity);
                    }
                }
            }, 0, 85, null, 8, null));
        }
    }
}

