/*
 * Decompiled with CFR 0.152.
 */
package net.barribob.boss.cardinalComponents;

import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistryV3;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentInitializer;
import dev.onyxstudios.cca.api.v3.world.WorldComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.world.WorldComponentInitializer;
import java.util.List;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.barribob.boss.Mod;
import net.barribob.boss.cardinalComponents.ChunkBlockCacheComponent;
import net.barribob.boss.cardinalComponents.IChunkBlockCacheComponent;
import net.barribob.boss.cardinalComponents.IPlayerChargedEnderPearlCooldownComponent;
import net.barribob.boss.cardinalComponents.IPlayerMoveHistory;
import net.barribob.boss.cardinalComponents.IPlayerMoveHistoryComponent;
import net.barribob.boss.cardinalComponents.IWorldEventScheduler;
import net.barribob.boss.cardinalComponents.IWorldEventSchedulerComponent;
import net.barribob.boss.cardinalComponents.PlayerChargedEnderPearlCooldownComponent;
import net.barribob.boss.cardinalComponents.PlayerMoveHistory;
import net.barribob.boss.cardinalComponents.WorldEventScheduler;
import net.barribob.maelstrom.general.event.EventScheduler;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \n2\u00020\u00012\u00020\u0002:\u0001\nB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\tH\u0016\u00a8\u0006\u000b"}, d2={"Lnet/barribob/boss/cardinalComponents/ModComponents;", "Ldev/onyxstudios/cca/api/v3/world/WorldComponentInitializer;", "Ldev/onyxstudios/cca/api/v3/entity/EntityComponentInitializer;", "()V", "registerEntityComponentFactories", "", "registry", "Ldev/onyxstudios/cca/api/v3/entity/EntityComponentFactoryRegistry;", "registerWorldComponentFactories", "Ldev/onyxstudios/cca/api/v3/world/WorldComponentFactoryRegistry;", "Companion", "BOMD"})
public final class ModComponents
implements WorldComponentInitializer,
EntityComponentInitializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final ComponentKey<IWorldEventSchedulerComponent> eventSchedulerComponentKey;
    @NotNull
    private static final ComponentKey<IPlayerMoveHistoryComponent> playerMoveHistoryComponentKey;
    @NotNull
    private static final ComponentKey<IChunkBlockCacheComponent> chunkBlockCacheComponentKey;
    @NotNull
    private static final ComponentKey<IPlayerChargedEnderPearlCooldownComponent> chargedEnderPearlCooldownComponentKey;

    public void registerWorldComponentFactories(@NotNull WorldComponentFactoryRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        registry.register(eventSchedulerComponentKey, WorldEventScheduler.class, WorldEventScheduler::new);
        registry.register(chunkBlockCacheComponentKey, ChunkBlockCacheComponent.class, ChunkBlockCacheComponent::new);
    }

    public void registerEntityComponentFactories(@NotNull EntityComponentFactoryRegistry registry) {
        Intrinsics.checkNotNullParameter((Object)registry, (String)"registry");
        registry.registerFor(class_3222.class, playerMoveHistoryComponentKey, PlayerMoveHistory::new);
        registry.registerFor(class_3222.class, chargedEnderPearlCooldownComponentKey, PlayerChargedEnderPearlCooldownComponent::new);
    }

    static {
        ComponentKey componentKey = ComponentRegistryV3.INSTANCE.getOrCreate(Mod.INSTANCE.identifier("event_scheduler"), IWorldEventSchedulerComponent.class);
        Intrinsics.checkNotNullExpressionValue((Object)componentKey, (String)"INSTANCE.getOrCreate(\n  \u2026:class.java\n            )");
        eventSchedulerComponentKey = componentKey;
        componentKey = ComponentRegistryV3.INSTANCE.getOrCreate(Mod.INSTANCE.identifier("player_move_history"), IPlayerMoveHistoryComponent.class);
        Intrinsics.checkNotNullExpressionValue((Object)componentKey, (String)"INSTANCE.getOrCreate(\n  \u2026:class.java\n            )");
        playerMoveHistoryComponentKey = componentKey;
        componentKey = ComponentRegistryV3.INSTANCE.getOrCreate(Mod.INSTANCE.identifier("chunk_block_cache_component"), IChunkBlockCacheComponent.class);
        Intrinsics.checkNotNullExpressionValue((Object)componentKey, (String)"INSTANCE.getOrCreate(\n  \u2026:class.java\n            )");
        chunkBlockCacheComponentKey = componentKey;
        componentKey = ComponentRegistryV3.INSTANCE.getOrCreate(Mod.INSTANCE.identifier("charged_ender_pearl_cooldown_component"), IPlayerChargedEnderPearlCooldownComponent.class);
        Intrinsics.checkNotNullExpressionValue((Object)componentKey, (String)"INSTANCE.getOrCreate(\n  \u2026:class.java\n            )");
        chargedEnderPearlCooldownComponentKey = componentKey;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lnet/barribob/boss/cardinalComponents/ModComponents$Companion;", "Lnet/barribob/boss/cardinalComponents/IWorldEventScheduler;", "Lnet/barribob/boss/cardinalComponents/IPlayerMoveHistory;", "()V", "chargedEnderPearlCooldownComponentKey", "Ldev/onyxstudios/cca/api/v3/component/ComponentKey;", "Lnet/barribob/boss/cardinalComponents/IPlayerChargedEnderPearlCooldownComponent;", "chunkBlockCacheComponentKey", "Lnet/barribob/boss/cardinalComponents/IChunkBlockCacheComponent;", "eventSchedulerComponentKey", "Lnet/barribob/boss/cardinalComponents/IWorldEventSchedulerComponent;", "playerMoveHistoryComponentKey", "Lnet/barribob/boss/cardinalComponents/IPlayerMoveHistoryComponent;", "getChunkBlockCache", "Ljava/util/Optional;", "world", "Lnet/minecraft/world/World;", "getPlayerPositions", "", "Lnet/minecraft/util/math/Vec3d;", "serverPlayerEntity", "Lnet/minecraft/server/network/ServerPlayerEntity;", "getWorldEventScheduler", "Lnet/barribob/maelstrom/general/event/EventScheduler;", "BOMD"})
    public static final class Companion
    implements IWorldEventScheduler,
    IPlayerMoveHistory {
        private Companion() {
        }

        @Override
        @NotNull
        public EventScheduler getWorldEventScheduler(@NotNull class_1937 world) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            return ((IWorldEventSchedulerComponent)eventSchedulerComponentKey.get((Object)world)).get();
        }

        @Override
        @NotNull
        public List<class_243> getPlayerPositions(@NotNull class_3222 serverPlayerEntity) {
            Intrinsics.checkNotNullParameter((Object)serverPlayerEntity, (String)"serverPlayerEntity");
            return ((IPlayerMoveHistoryComponent)playerMoveHistoryComponentKey.get((Object)serverPlayerEntity)).getHistoricalPositions();
        }

        @NotNull
        public final Optional<IChunkBlockCacheComponent> getChunkBlockCache(@NotNull class_1937 world) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Optional optional = chunkBlockCacheComponentKey.maybeGet((Object)world);
            Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"chunkBlockCacheComponentKey.maybeGet(world)");
            return optional;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

