/*
 * Decompiled with CFR 0.152.
 */
package net.barribob.boss.animation;

import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.barribob.boss.animation.IAnimationTimer;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u00020\u0001B!\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\u0002\u0010\u0007J\b\u0010\f\u001a\u00020\u0004H\u0016R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\b\u00a8\u0006\r"}, d2={"Lnet/barribob/boss/animation/PauseAnimationTimer;", "Lnet/barribob/boss/animation/IAnimationTimer;", "sysTimeProvider", "Lkotlin/Function0;", "", "isPaused", "", "(Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)V", "()Lkotlin/jvm/functions/Function0;", "pauseStart", "pauseTime", "getSysTimeProvider", "getCurrentTick", "BOMD"})
public final class PauseAnimationTimer
implements IAnimationTimer {
    @NotNull
    private final Function0<Double> sysTimeProvider;
    @NotNull
    private final Function0<Boolean> isPaused;
    private double pauseTime;
    private double pauseStart;

    public PauseAnimationTimer(@NotNull Function0<Double> sysTimeProvider, @NotNull Function0<Boolean> isPaused) {
        Intrinsics.checkNotNullParameter(sysTimeProvider, (String)"sysTimeProvider");
        Intrinsics.checkNotNullParameter(isPaused, (String)"isPaused");
        this.sysTimeProvider = sysTimeProvider;
        this.isPaused = isPaused;
    }

    @NotNull
    public final Function0<Double> getSysTimeProvider() {
        return this.sysTimeProvider;
    }

    @NotNull
    public final Function0<Boolean> isPaused() {
        return this.isPaused;
    }

    @Override
    public double getCurrentTick() {
        double sysTime = ((Number)this.sysTimeProvider.invoke()).doubleValue();
        if (((Boolean)this.isPaused.invoke()).booleanValue()) {
            if (this.pauseStart == 0.0) {
                this.pauseStart = sysTime;
            }
            return this.pauseStart - this.pauseTime;
        }
        if (!(this.pauseStart == 0.0)) {
            double timeElapsed = sysTime - this.pauseStart;
            this.pauseTime += timeElapsed;
            this.pauseStart = 0.0;
        }
        return sysTime - this.pauseTime;
    }
}

