/*
 * Decompiled with CFR 0.152.
 */
package de.guntram.mcmod.fabrictools;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import de.guntram.mcmod.fabrictools.ConfigurationItem;
import de.guntram.mcmod.fabrictools.ConfigurationSelectList;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1074;

public class Configuration {
    public static final int CATEGORY_CLIENT = 0;
    public static final int CATEGORY_GENERAL = 1;
    private static final Type MAP_TYPE = new TypeToken<Map<String, ConfigurationItem>>(){}.getType();
    private Map<String, ConfigurationItem> items;
    private boolean wasChanged;
    private File configFile;

    public Configuration(File configFile) {
        this.configFile = configFile;
        this.items = new HashMap<String, ConfigurationItem>();
        try (JsonReader reader2 = new JsonReader((Reader)new FileReader(configFile));){
            Gson gson = new Gson();
            this.items = (Map)gson.fromJson(reader2, MAP_TYPE);
        }
        catch (FileNotFoundException reader2) {
        }
        catch (IOException ex) {
            System.err.println("Trying to load config file " + configFile.getAbsolutePath() + ":");
            ex.printStackTrace(System.err);
        }
        this.wasChanged = false;
    }

    public boolean hasChanged() {
        return this.wasChanged;
    }

    public void save() {
        try (FileWriter writer = new FileWriter(this.configFile);){
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson(this.items, (Appendable)writer);
        }
        catch (IOException ex) {
            System.err.println("Trying to save config file " + this.configFile.getAbsolutePath() + ":");
            ex.printStackTrace(System.err);
        }
    }

    public int getInt(String description, int category, int defVal, int min, int max, String toolTip) {
        return (Integer)this.getValue(description, category, defVal, min, max, toolTip, Integer.class);
    }

    public float getFloat(String description, int category, float defVal, float min, float max, String toolTip) {
        return ((Float)this.getValue(description, category, Float.valueOf(defVal), Float.valueOf(min), Float.valueOf(max), toolTip, Float.class)).floatValue();
    }

    public boolean getBoolean(String description, int category, boolean defVal, String toolTip) {
        return (Boolean)this.getValue(description, category, defVal, toolTip, Boolean.class);
    }

    public String getString(String description, int category, String defVal, String toolTip) {
        return (String)this.getValue(description, category, defVal, toolTip, String.class);
    }

    public Object getValue(String description, int category, Object defVal, String toolTip, Class clazz) {
        return this.getValue(description, category, defVal, null, null, toolTip, clazz);
    }

    public int getSelection(String description, int category, int defVal, String[] options, String toolTip) {
        ConfigurationItem item = this.items.get(description);
        if (item == null) {
            this.items.put(description, new ConfigurationSelectList(description, toolTip, options, defVal, defVal));
            this.wasChanged = true;
            return defVal;
        }
        if (!(item instanceof ConfigurationSelectList)) {
            ConfigurationSelectList list = new ConfigurationSelectList(description, toolTip, options, item.value, defVal);
            this.items.put(description, list);
        }
        return (Integer)this.getValue(description, category, defVal, 0, options.length - 1, toolTip, Integer.class);
    }

    public Object getValue(String description, int category, Object defVal, Object minVal, Object maxVal, String toolTip, Class clazz) {
        ConfigurationItem item = this.items.get(description);
        if (item == null) {
            this.items.put(description, new ConfigurationItem(description, toolTip, defVal, defVal, minVal, maxVal));
            this.wasChanged = true;
            return defVal;
        }
        item.key = class_1074.method_4662((String)description, (Object[])new Object[0]);
        item.minValue = minVal;
        item.maxValue = maxVal;
        item.toolTip = toolTip;
        item.defaultValue = defVal;
        if (item.value.getClass() == clazz) {
            return item.value;
        }
        if (item.value.getClass() == Double.class && clazz == Integer.class) {
            int value = (int)((Double)item.value).doubleValue();
            item.value = value;
            return item.value;
        }
        if (item.value.getClass() == Double.class && clazz == Float.class) {
            float value = (float)((Double)item.value).doubleValue();
            item.value = Float.valueOf(value);
            return item.value;
        }
        item.value = defVal;
        this.wasChanged = true;
        return defVal;
    }

    public Object getValue(String description) {
        return this.items.get((Object)description).value;
    }

    public Object getDefault(String description) {
        return this.items.get((Object)description).defaultValue;
    }

    public Object getMin(String description) {
        return this.items.get((Object)description).minValue;
    }

    public Object getMax(String description) {
        return this.items.get((Object)description).maxValue;
    }

    public String getTooltip(String description) {
        return this.items.get((Object)description).toolTip;
    }

    public boolean isSelectList(String description) {
        return this.items.get(description) instanceof ConfigurationSelectList;
    }

    public String[] getListOptions(String description) {
        return ((ConfigurationSelectList)this.items.get((Object)description)).options;
    }

    public void forget(String item) {
        this.items.remove(item);
        this.wasChanged = true;
    }

    public void migrate(String oldKey, String newKey) {
        ConfigurationItem oldItem = this.items.get(oldKey);
        this.items.remove(oldKey);
        if (oldItem != null) {
            oldItem.key = newKey;
            this.items.put(newKey, oldItem);
        }
        this.wasChanged = true;
    }

    public boolean setValue(String description, Object value) {
        ConfigurationItem item = this.items.get(description);
        if (item == null) {
            return false;
        }
        item.value = value;
        this.wasChanged = true;
        return true;
    }

    public List getKeys() {
        ArrayList<String> list = new ArrayList<String>(this.items.keySet());
        Collections.sort(list);
        return list;
    }
}

