/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.lifts.compat;

import io.github.lucaargolo.lifts.Lifts;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0015J\u0006\u0010\u0017\u001a\u00020\u0015R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/github/lucaargolo/lifts/compat/OptifineShadersCompat;", "", "()V", "activeProgramField", "Ljava/lang/reflect/Field;", "bindShadersFramebufferMethod", "Ljava/lang/reflect/Method;", "dfbField", "getProgramNoneMethod", "isRenderingWorldField", "isShadowPassField", "lastActiveProgram", "programClass", "Ljava/lang/Class;", "programsClass", "programsField", "sfbField", "shadersClass", "shadersFramebufferClass", "useProgramMethod", "endDrawingScreen", "", "initialize", "startDrawingScreen", "lifts"})
public final class OptifineShadersCompat {
    @NotNull
    public static final OptifineShadersCompat INSTANCE = new OptifineShadersCompat();
    @Nullable
    private static Class<?> shadersClass;
    @Nullable
    private static Class<?> shadersFramebufferClass;
    @Nullable
    private static Class<?> programsClass;
    @Nullable
    private static Class<?> programClass;
    @Nullable
    private static Field isRenderingWorldField;
    @Nullable
    private static Field isShadowPassField;
    @Nullable
    private static Field dfbField;
    @Nullable
    private static Field sfbField;
    @Nullable
    private static Field programsField;
    @Nullable
    private static Field activeProgramField;
    @Nullable
    private static Method bindShadersFramebufferMethod;
    @Nullable
    private static Method useProgramMethod;
    @Nullable
    private static Method getProgramNoneMethod;
    @Nullable
    private static Object lastActiveProgram;

    private OptifineShadersCompat() {
    }

    public final void initialize() {
        Lifts.Companion.getLOGGER().info("Trying to load optifine compat!");
        try {
            Method method;
            shadersClass = Class.forName("net.optifine.shaders.Shaders");
            shadersFramebufferClass = Class.forName("net.optifine.shaders.ShadersFramebuffer");
            programsClass = Class.forName("net.optifine.shaders.Programs");
            programClass = Class.forName("net.optifine.shaders.Program");
            AnnotatedElement annotatedElement = shadersClass;
            isRenderingWorldField = annotatedElement == null ? null : ((Class)annotatedElement).getField("isRenderingWorld");
            annotatedElement = shadersClass;
            isShadowPassField = annotatedElement == null ? null : ((Class)annotatedElement).getField("isShadowPass");
            annotatedElement = shadersClass;
            dfbField = annotatedElement == null ? null : ((Class)annotatedElement).getDeclaredField("dfb");
            annotatedElement = dfbField;
            if (annotatedElement != null) {
                ((Field)annotatedElement).setAccessible(true);
            }
            annotatedElement = shadersClass;
            sfbField = annotatedElement == null ? null : ((Class)annotatedElement).getDeclaredField("sfb");
            annotatedElement = sfbField;
            if (annotatedElement != null) {
                ((Field)annotatedElement).setAccessible(true);
            }
            annotatedElement = shadersClass;
            programsField = annotatedElement == null ? null : ((Class)annotatedElement).getDeclaredField("programs");
            annotatedElement = programsField;
            if (annotatedElement != null) {
                ((Field)annotatedElement).setAccessible(true);
            }
            annotatedElement = shadersClass;
            activeProgramField = annotatedElement == null ? null : ((Class)annotatedElement).getField("activeProgram");
            annotatedElement = shadersFramebufferClass;
            bindShadersFramebufferMethod = annotatedElement == null ? null : ((Class)annotatedElement).getMethod("bindFramebuffer", new Class[0]);
            annotatedElement = shadersClass;
            if (annotatedElement == null) {
                method = null;
            } else {
                Class[] classArray = new Class[]{programClass};
                method = ((Class)annotatedElement).getMethod("useProgram", classArray);
            }
            useProgramMethod = method;
            annotatedElement = programsClass;
            getProgramNoneMethod = annotatedElement == null ? null : ((Class)annotatedElement).getMethod("getProgramNone", new Class[0]);
            Lifts.Companion.getLOGGER().info("Successfully loaded optifine compatibility!");
        }
        catch (Exception e) {
            Lifts.Companion.getLOGGER().info("Optifine not found, not loading compatibility!");
        }
    }

    public final void startDrawingScreen() {
        Field field = isRenderingWorldField;
        if (Intrinsics.areEqual((Object)(field == null ? null : Boolean.valueOf(field.getBoolean(null))), (Object)true) && Intrinsics.areEqual((Object)((field = isShadowPassField) == null ? null : Boolean.valueOf(field.getBoolean(null))), (Object)false)) {
            AccessibleObject accessibleObject = programsField;
            Object programs = accessibleObject == null ? null : ((Field)accessibleObject).get(null);
            accessibleObject = activeProgramField;
            lastActiveProgram = accessibleObject == null ? null : ((Field)accessibleObject).get(null);
            accessibleObject = useProgramMethod;
            if (accessibleObject != null) {
                Method method = getProgramNoneMethod;
                Object[] objectArray = new Object[]{method == null ? null : method.invoke(programs, new Object[0])};
                ((Method)accessibleObject).invoke(null, objectArray);
            }
        }
    }

    public final void endDrawingScreen() {
        Field field = isRenderingWorldField;
        if (Intrinsics.areEqual((Object)(field == null ? null : Boolean.valueOf(field.getBoolean(null))), (Object)true) && (field = isShadowPassField) != null) {
            boolean bl;
            boolean bl2 = bl = field.getBoolean(null);
            boolean bl3 = false;
            boolean bl4 = false;
            boolean isRenderingShadow = bl2;
            boolean bl5 = false;
            if (isRenderingShadow) {
                AccessibleObject accessibleObject = sfbField;
                Object shadowFramebuffer = accessibleObject == null ? null : ((Field)accessibleObject).get(null);
                accessibleObject = bindShadersFramebufferMethod;
                if (accessibleObject != null) {
                    ((Method)accessibleObject).invoke(shadowFramebuffer, new Object[0]);
                }
            } else {
                AccessibleObject accessibleObject = dfbField;
                Object drawFramebuffer = accessibleObject == null ? null : ((Field)accessibleObject).get(null);
                accessibleObject = bindShadersFramebufferMethod;
                if (accessibleObject != null) {
                    ((Method)accessibleObject).invoke(drawFramebuffer, new Object[0]);
                }
                accessibleObject = useProgramMethod;
                if (accessibleObject != null) {
                    Object[] objectArray = new Object[]{lastActiveProgram};
                    ((Method)accessibleObject).invoke(null, objectArray);
                }
            }
        }
    }
}

