/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.lifts.common.entity.platform;

import io.github.lucaargolo.lifts.common.entity.EntityCompendium;
import io.github.lucaargolo.lifts.network.PacketCompendium;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1264;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1313;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001d\b\u0016\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00000\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007B\u001f\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u000bJ\b\u0010(\u001a\u00020)H\u0014J\b\u0010*\u001a\u00020+H\u0016J\u0018\u0010,\u001a\u00020+2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\b\u0010-\u001a\u00020+H\u0002J\f\u0010.\u001a\u0006\u0012\u0002\b\u00030/H\u0016J\u000e\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u0017J\b\u00102\u001a\u00020+H\u0014J\b\u00103\u001a\u000204H\u0016J\u000e\u00105\u001a\u00020+2\u0006\u00106\u001a\u000207J\u0010\u00108\u001a\u00020+2\u0006\u00106\u001a\u000207H\u0014J\b\u00109\u001a\u00020:H\u0002J\b\u0010;\u001a\u00020+H\u0016J@\u0010<\u001a\u00020+2\u0006\u00101\u001a\u00020\u00172\u0006\u0010=\u001a\u00020\u00172\u0006\u0010>\u001a\u00020\u00172\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020@2\u0006\u0010B\u001a\u00020:2\u0006\u0010C\u001a\u000204H\u0016J\u000e\u0010D\u001a\u00020+2\u0006\u00106\u001a\u000207J\u0010\u0010E\u001a\u00020+2\u0006\u00106\u001a\u000207H\u0014R.\u0010\f\u001a\u0014\u0012\u000e\u0012\f\u0012\u0006\u0012\u0004\u0018\u00010\u000e\u0018\u00010\r\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0013\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u001a\u0010\u001f\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0019\"\u0004\b!\u0010\u001bR\u001a\u0010\"\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0019\"\u0004\b$\u0010\u001bR\u001a\u0010%\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010\u0019\"\u0004\b'\u0010\u001b\u00a8\u0006F"}, d2={"Lio/github/lucaargolo/lifts/common/entity/platform/PlatformEntity;", "Lnet/minecraft/entity/Entity;", "entityType", "Lnet/minecraft/entity/EntityType;", "world", "Lnet/minecraft/world/World;", "(Lnet/minecraft/entity/EntityType;Lnet/minecraft/world/World;)V", "(Lnet/minecraft/world/World;)V", "pos1", "Lnet/minecraft/util/math/BlockPos;", "pos2", "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/world/World;)V", "blockMatrix", "", "Lnet/minecraft/block/BlockState;", "getBlockMatrix", "()[[Lnet/minecraft/block/BlockState;", "setBlockMatrix", "([[Lnet/minecraft/block/BlockState;)V", "[[Lnet/minecraft/block/BlockState;", "collidingEntities", "", "finalElevation", "", "getFinalElevation", "()D", "setFinalElevation", "(D)V", "initialElevation", "getInitialElevation", "setInitialElevation", "lastProgress", "getLastProgress", "setLastProgress", "platformSpeed", "getPlatformSpeed", "setPlatformSpeed", "sameLastProgress", "getSameLastProgress", "setSameLastProgress", "calculateBoundingBox", "Lnet/minecraft/util/math/Box;", "calculateDimensions", "", "createBlockMatrix", "createBoundingBox", "createSpawnPacket", "Lnet/minecraft/network/Packet;", "easeInOutSine", "x", "initDataTracker", "isCollidable", "", "readBlockMatrixFromTag", "tag", "Lnet/minecraft/nbt/NbtCompound;", "readCustomDataFromNbt", "removeBlockMatrix", "", "tick", "updateTrackedPositionAndAngles", "y", "z", "yaw", "", "pitch", "interpolationSteps", "interpolate", "writeBlockMatrixToTag", "writeCustomDataToNbt", "lifts"})
public final class PlatformEntity
extends class_1297 {
    @Nullable
    private List<? extends class_1297> collidingEntities;
    @Nullable
    private class_2680[][] blockMatrix;
    private double platformSpeed;
    private double initialElevation;
    private double finalElevation;
    private double lastProgress;
    private double sameLastProgress;

    @Nullable
    public final class_2680[][] getBlockMatrix() {
        return this.blockMatrix;
    }

    public final void setBlockMatrix(@Nullable class_2680[][] class_2680Array) {
        this.blockMatrix = class_2680Array;
    }

    public final double getPlatformSpeed() {
        return this.platformSpeed;
    }

    public final void setPlatformSpeed(double d) {
        this.platformSpeed = d;
    }

    public final double getInitialElevation() {
        return this.initialElevation;
    }

    public final void setInitialElevation(double d) {
        this.initialElevation = d;
    }

    public final double getFinalElevation() {
        return this.finalElevation;
    }

    public final void setFinalElevation(double d) {
        this.finalElevation = d;
    }

    public final double getLastProgress() {
        return this.lastProgress;
    }

    public final void setLastProgress(double d) {
        this.lastProgress = d;
    }

    public final double getSameLastProgress() {
        return this.sameLastProgress;
    }

    public final void setSameLastProgress(double d) {
        this.sameLastProgress = d;
    }

    public PlatformEntity(@NotNull class_1299<PlatformEntity> entityType, @NotNull class_1937 world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(entityType, world);
        this.platformSpeed = 1.0;
        this.lastProgress = -9999.0;
    }

    public PlatformEntity(@NotNull class_1937 world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(EntityCompendium.INSTANCE.getPLATFORM_TYPE(), world);
        this.platformSpeed = 1.0;
        this.lastProgress = -9999.0;
    }

    public PlatformEntity(@NotNull class_2338 pos1, @NotNull class_2338 pos2, @NotNull class_1937 world) {
        Intrinsics.checkNotNullParameter((Object)pos1, (String)"pos1");
        Intrinsics.checkNotNullParameter((Object)pos2, (String)"pos2");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this(world);
        this.createBlockMatrix(pos1, pos2);
    }

    public void method_5759(double x, double y, double z, float yaw, float pitch, int interpolationSteps, boolean interpolate) {
    }

    public final double easeInOutSine(double x) {
        double d = Math.PI * x;
        boolean bl = false;
        return -(Math.cos(d) - 1.0) / (double)2;
    }

    public void method_5773() {
        class_1297 it;
        Iterable $this$forEach$iv;
        this.collidingEntities = this.field_6002.method_8335((class_1297)this, this.method_5829().method_1009(0.0, 0.3, 0.0));
        double progress = (this.method_19538().field_1351 - this.initialElevation) / (this.finalElevation - this.initialElevation);
        if (progress < 1.0) {
            int d = this.method_19538().field_1351 > this.finalElevation ? -1 : 1;
            double d2 = this.finalElevation - this.initialElevation;
            boolean bl = false;
            double h = Math.abs(d2);
            double p = progress <= 0.5 ? progress : 1.0 - progress;
            double d3 = p * (1.0 / ((double)5 / h));
            double d4 = 1.0;
            boolean bl2 = false;
            double e = Math.min(d3, d4);
            double vel = (double)d * this.easeInOutSine(e) * (this.platformSpeed / (double)2);
            double oldElevation = this.method_19538().field_1351;
            this.method_5784(class_1313.field_6308, new class_243(0.0, (vel + (double)d * 0.1) * 0.5, 0.0));
            double elevationOffset = this.method_19538().field_1351 - oldElevation;
            List<? extends class_1297> list = this.collidingEntities;
            if (list != null) {
                Iterable $this$forEach$iv2 = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv2) {
                    class_1297 it2 = (class_1297)element$iv;
                    boolean bl3 = false;
                    it2.method_5762(0.0, elevationOffset - it2.method_18798().field_1351, 0.0);
                }
            }
        }
        if ((progress = (this.method_19538().field_1351 - this.initialElevation) / (this.finalElevation - this.initialElevation)) == this.lastProgress) {
            PlatformEntity d = this;
            double d5 = d.sameLastProgress;
            d.sameLastProgress = d5 + 1.0;
            if (d5 >= 3.0) {
                int yPos = this.removeBlockMatrix();
                List<? extends class_1297> list = this.collidingEntities;
                if (list != null) {
                    $this$forEach$iv = list;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (class_1297)element$iv;
                        boolean bl = false;
                        it.method_20620(it.method_19538().field_1352, (double)yPos + 1.0, it.method_19538().field_1350);
                    }
                }
            }
        } else {
            this.lastProgress = progress;
        }
        if (progress >= 1.0) {
            int yPos = this.removeBlockMatrix();
            List<? extends class_1297> list = this.collidingEntities;
            if (list != null) {
                $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    it = (class_1297)element$iv;
                    boolean bl = false;
                    it.method_20620(it.method_19538().field_1352, (double)yPos + 1.0, it.method_19538().field_1350);
                }
            }
        }
        super.method_5773();
    }

    /*
     * WARNING - void declaration
     */
    private final int removeBlockMatrix() {
        class_2680[][] class_2680Array;
        double d = this.method_19538().field_1351;
        boolean bl = false;
        int yPos = (int)Math.rint(d);
        if (!this.field_6002.field_9236 && (class_2680Array = this.blockMatrix) != null) {
            Object[] $this$forEachIndexed$iv = (Object[])class_2680Array;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void row;
                int n = index$iv++;
                class_2680[] class_2680Array2 = (class_2680[])item$iv;
                int x = n;
                boolean bl2 = false;
                void var13_14 = row;
                if (var13_14 == null) continue;
                void $this$forEachIndexed$iv2 = var13_14;
                boolean $i$f$forEachIndexed2 = false;
                int index$iv2 = 0;
                for (void item$iv2 : $this$forEachIndexed$iv2) {
                    class_3218 class_32182;
                    void state;
                    int n2 = index$iv2++;
                    void var21_22 = item$iv2;
                    int z = n2;
                    boolean bl3 = false;
                    class_2338 pos = new class_2338(this.method_24515().method_10263() + x, yPos, this.method_24515().method_10260() + z);
                    if (this.field_6002.method_8320(pos).method_26215()) {
                        this.field_6002.method_8501(pos, (class_2680)state);
                        continue;
                    }
                    class_1937 class_19372 = this.field_6002;
                    class_3218 class_32183 = class_32182 = class_19372 instanceof class_3218 ? (class_3218)class_19372 : null;
                    if (class_32182 == null) continue;
                    class_19372 = class_32182;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    class_1937 serverWorld = class_19372;
                    boolean bl6 = false;
                    List stacks = class_2248.method_9562((class_2680)state, (class_3218)serverWorld, (class_2338)pos, null);
                    Intrinsics.checkNotNullExpressionValue((Object)stacks, (String)"stacks");
                    Iterable $this$forEach$iv = stacks;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        class_1799 it = (class_1799)element$iv;
                        boolean bl7 = false;
                        class_1264.method_5449((class_1937)this.field_6002, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)it);
                    }
                }
            }
        }
        this.method_5650(class_1297.class_5529.field_26999);
        return yPos;
    }

    private final void createBlockMatrix(class_2338 pos1, class_2338 pos2) {
        int y = pos1.method_10264();
        int n = pos1.method_10263();
        int n2 = pos2.method_10263();
        int n3 = 0;
        int minX = Math.min(n, n2);
        n2 = pos1.method_10263();
        n3 = pos2.method_10263();
        int n4 = 0;
        int maxX = Math.max(n2, n3);
        n3 = pos1.method_10260();
        n4 = pos2.method_10260();
        int n5 = 0;
        int minZ = Math.min(n3, n4);
        n4 = pos1.method_10260();
        n5 = pos2.method_10260();
        boolean bl = false;
        int maxZ = Math.max(n4, n5);
        class_2680[][] blockMatrix = new class_2680[maxX - minX + 1][];
        n5 = minX;
        if (n5 <= maxX) {
            int x;
            do {
                x = n5++;
                class_2680[] matrixRow = new class_2680[maxZ - minZ + 1];
                int n6 = minZ;
                if (n6 <= maxZ) {
                    int z;
                    do {
                        class_2680 class_26802;
                        class_2338 pos;
                        class_2680 state;
                        if ((state = this.field_6002.method_8320(pos = new class_2338(x, y, z = n6++))).method_26234((class_1922)this.field_6002, pos) && !state.method_31709()) {
                            this.field_6002.method_8501(pos, class_2246.field_10124.method_9564());
                            class_26802 = state;
                            continue;
                        }
                        class_26802 = matrixRow[z - minZ] = class_2246.field_10124.method_9564();
                    } while (z != maxZ);
                }
                blockMatrix[x - minX] = matrixRow;
            } while (x != maxX);
        }
        this.blockMatrix = blockMatrix;
        this.createBoundingBox();
    }

    private final void createBoundingBox() {
        class_2680[][] class_2680Array = this.blockMatrix;
        if (class_2680Array != null) {
            int n;
            class_2680[] class_2680Array2;
            class_2680[][] class_2680Array3 = class_2680Array;
            boolean bl = false;
            boolean bl2 = false;
            class_2680[][] matrix = class_2680Array3;
            boolean bl3 = false;
            int xSize = ((Object[])matrix).length;
            int zSize = xSize > 0 ? ((class_2680Array2 = matrix[0]) == null ? 0 : (n = class_2680Array2.length)) : 0;
            this.method_5857(new class_238(this.method_23317() - 0.5, this.method_23318(), this.method_23321() - 0.5, this.method_23317() + (double)xSize - 0.5, this.method_23318() + 1.0, this.method_23321() + (double)zSize - 0.5));
        }
    }

    public boolean method_30948() {
        return true;
    }

    public void method_18382() {
    }

    @NotNull
    protected class_238 method_33332() {
        return new class_238(this.method_23317() - 0.5, this.method_23318(), this.method_23321() - 0.5, this.method_23317() + this.method_5829().method_17939() - 0.5, this.method_23318() + this.method_5829().method_17940(), this.method_23321() + this.method_5829().method_17941() - 0.5);
    }

    protected void method_5693() {
    }

    /*
     * WARNING - void declaration
     */
    public final void writeBlockMatrixToTag(@NotNull class_2487 tag) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        class_2680[][] class_2680Array = this.blockMatrix;
        tag.method_10569("xSize", class_2680Array == null ? 0 : (n2 = ((Object[])class_2680Array).length));
        class_2680[][] class_2680Array2 = this.blockMatrix;
        class_2680Array = class_2680Array2 == null ? null : (class_2680[])ArraysKt.getOrNull((Object[])((Object[])class_2680Array2), (int)0);
        tag.method_10569("ySize", class_2680Array == null ? 0 : (n = class_2680Array.length));
        class_2680Array = this.blockMatrix;
        if (class_2680Array != null) {
            Object[] $this$forEachIndexed$iv = (Object[])class_2680Array;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void row;
                int n3 = index$iv++;
                class_2680[] class_2680Array3 = (class_2680[])item$iv;
                int x = n3;
                boolean bl = false;
                void var13_16 = row;
                if (var13_16 == null) continue;
                void $this$forEachIndexed$iv2 = var13_16;
                boolean $i$f$forEachIndexed2 = false;
                int index$iv2 = 0;
                for (void item$iv2 : $this$forEachIndexed$iv2) {
                    void state;
                    int n4 = index$iv2++;
                    void var21_24 = item$iv2;
                    int z = n4;
                    boolean bl2 = false;
                    tag.method_10566("block-" + x + z, (class_2520)class_2512.method_10686((class_2680)state));
                }
            }
        }
    }

    protected void method_5652(@NotNull class_2487 tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.writeBlockMatrixToTag(tag);
    }

    public final void readBlockMatrixFromTag(@NotNull class_2487 tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        int x = 0;
        int z = 0;
        class_2680[][] blockMatrix = new class_2680[tag.method_10550("xSize")][];
        while (tag.method_10545("block-" + x + z)) {
            class_2680[] class_2680Array = blockMatrix[x];
            class_2680[] matrixRow = class_2680Array == null ? new class_2680[tag.method_10550("ySize")] : class_2680Array;
            matrixRow[z] = class_2512.method_10681((class_2487)tag.method_10562("block-" + x + z));
            if (blockMatrix[x] == null) {
                blockMatrix[x] = matrixRow;
            }
            int n = z;
            z = n + 1;
            if (tag.method_10545("block-" + x + z)) continue;
            z = 0;
            n = x;
            x = n + 1;
        }
        this.blockMatrix = blockMatrix;
        this.createBoundingBox();
    }

    protected void method_5749(@NotNull class_2487 tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.readBlockMatrixFromTag(tag);
    }

    @NotNull
    public class_2596<?> method_18002() {
        class_2540 buf = PacketByteBufs.create();
        buf.method_10804(this.method_5628());
        buf.method_10797(this.field_6021);
        buf.writeDouble(this.method_23317());
        buf.writeDouble(this.method_23318());
        buf.writeDouble(this.method_23321());
        buf.writeByte(class_3532.method_15375((float)(this.method_36455() * 256.0f / 360.0f)));
        buf.writeByte(class_3532.method_15375((float)(this.method_36454() * 256.0f / 360.0f)));
        class_2487 tag = new class_2487();
        this.writeBlockMatrixToTag(tag);
        buf.method_10794(tag);
        buf.writeDouble(this.finalElevation);
        buf.writeDouble(this.platformSpeed);
        class_2596 class_25962 = ServerPlayNetworking.createS2CPacket((class_2960)PacketCompendium.INSTANCE.getSPAWN_PLATFORM_ENTITY(), (class_2540)buf);
        Intrinsics.checkNotNullExpressionValue((Object)class_25962, (String)"createS2CPacket(PacketCompendium.SPAWN_PLATFORM_ENTITY, buf)");
        return class_25962;
    }
}

