/*
 * Decompiled with CFR 0.152.
 */
package io.github.lucaargolo.lifts.common.blockentity.lift;

import io.github.lucaargolo.lifts.Lifts;
import io.github.lucaargolo.lifts.common.block.lift.ElectricLift;
import io.github.lucaargolo.lifts.common.block.lift.Lift;
import io.github.lucaargolo.lifts.common.blockentity.BlockEntityCompendium;
import io.github.lucaargolo.lifts.common.blockentity.lift.ElectricLiftBlockEntity;
import io.github.lucaargolo.lifts.common.blockentity.lift.LiftActionResult;
import io.github.lucaargolo.lifts.common.blockentity.lift.LiftBlockEntity;
import io.github.lucaargolo.lifts.common.blockentity.lift.LiftShaft;
import io.github.lucaargolo.lifts.utils.ModConfig;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.base.SimpleEnergyStorage;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0014R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lio/github/lucaargolo/lifts/common/blockentity/lift/ElectricLiftBlockEntity;", "Lio/github/lucaargolo/lifts/common/blockentity/lift/LiftBlockEntity;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/BlockState;", "(Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/BlockState;)V", "energyStorage", "Lteam/reborn/energy/api/base/SimpleEnergyStorage;", "getEnergyStorage", "()Lteam/reborn/energy/api/base/SimpleEnergyStorage;", "initializedEnergy", "", "liftCapacity", "", "liftMaxInsert", "getReachableLifts", "", "postSendRequirements", "", "distance", "preSendRequirements", "Lio/github/lucaargolo/lifts/common/blockentity/lift/LiftActionResult;", "readNbt", "tag", "Lnet/minecraft/nbt/NbtCompound;", "writeNbt", "Companion", "lifts"})
public final class ElectricLiftBlockEntity
extends LiftBlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean initializedEnergy;
    private long liftMaxInsert;
    private long liftCapacity;
    @NotNull
    private final SimpleEnergyStorage energyStorage;
    private static final int ENERGY_PER_BLOCK = Lifts.Companion.getCONFIG().getEnergyUnitsNeededPerBlock();

    public ElectricLiftBlockEntity(@NotNull class_2338 pos, @NotNull class_2680 state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(BlockEntityCompendium.INSTANCE.getELECTRIC_LIFT_TYPE(), pos, state);
        this.energyStorage = new SimpleEnergyStorage(this){
            final /* synthetic */ ElectricLiftBlockEntity this$0;
            {
                this.this$0 = $receiver;
                super(0L, 0L, 0L);
            }

            private final long getMaxInsert() {
                return ElectricLiftBlockEntity.access$getLiftMaxInsert$p(this.this$0);
            }

            public long getCapacity() {
                return ElectricLiftBlockEntity.access$getLiftCapacity$p(this.this$0);
            }

            public boolean supportsInsertion() {
                return this.getMaxInsert() > 0L;
            }

            public long insert(long maxAmount, @Nullable TransactionContext transaction) {
                StoragePreconditions.notNegative((long)maxAmount);
                long inserted = RangesKt.coerceAtMost((long)this.getMaxInsert(), (long)RangesKt.coerceAtMost((long)maxAmount, (long)(this.getCapacity() - this.amount)));
                if (inserted > 0L) {
                    this.updateSnapshots(transaction);
                    energyStorage.1 var6_4 = this;
                    var6_4.amount += inserted;
                    return inserted;
                }
                return 0L;
            }

            protected void onFinalCommit() {
                super.onFinalCommit();
                this.this$0.method_5431();
            }
        };
    }

    @NotNull
    public final SimpleEnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    @Override
    public int getReachableLifts() {
        SortedSet<LiftBlockEntity> sortedSet;
        int x = 0;
        LiftShaft liftShaft = this.getLiftShaft();
        if (liftShaft != null && (sortedSet = liftShaft.getLifts()) != null) {
            Iterable $this$forEach$iv = sortedSet;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                int n;
                ModConfig.LiftConfig liftConfig;
                LiftBlockEntity it = (LiftBlockEntity)((Object)element$iv);
                boolean bl = false;
                int distance = class_3532.method_15382((int)(it.method_11016().method_10264() - this.field_11867.method_10264()));
                Lift lift = this.getLift();
                ModConfig.LiftConfig liftConfig2 = liftConfig = lift == null ? null : lift.getLiftConfig();
                if (liftConfig == null) continue;
                int n2 = n = liftConfig.getPlatformRange();
                boolean bl2 = false;
                boolean bl3 = false;
                int range = n2;
                boolean bl4 = false;
                if (!new IntRange(0, range).contains(distance) || this.getEnergyStorage().amount < (long)(distance * ENERGY_PER_BLOCK)) continue;
                int n3 = x;
                x = n3 + 1;
            }
        }
        return x;
    }

    @Override
    @NotNull
    public LiftActionResult preSendRequirements(int distance) {
        int cost = ENERGY_PER_BLOCK * distance;
        return this.energyStorage.amount - (long)cost >= 0L ? LiftActionResult.SUCCESSFUL : LiftActionResult.NO_ENERGY;
    }

    @Override
    public void postSendRequirements(int distance) {
        int cost = ENERGY_PER_BLOCK * distance;
        SimpleEnergyStorage simpleEnergyStorage = this.energyStorage;
        simpleEnergyStorage.amount -= (long)cost;
        this.method_5431();
    }

    @Override
    public void method_11014(@NotNull class_2487 tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        super.method_11014(tag);
        this.energyStorage.amount = tag.method_10545("energyStored") ? (long)class_3532.method_15357((double)tag.method_10574("energyStored")) : tag.method_10537("storedEnergy");
    }

    @Override
    protected void method_11007(@NotNull class_2487 tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        tag.method_10544("storedEnergy", this.energyStorage.amount);
        super.method_11007(tag);
    }

    public static final /* synthetic */ long access$getLiftMaxInsert$p(ElectricLiftBlockEntity $this) {
        return $this.liftMaxInsert;
    }

    public static final /* synthetic */ long access$getLiftCapacity$p(ElectricLiftBlockEntity $this) {
        return $this.liftCapacity;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lio/github/lucaargolo/lifts/common/blockentity/lift/ElectricLiftBlockEntity$Companion;", "", "()V", "ENERGY_PER_BLOCK", "", "getENERGY_PER_BLOCK", "()I", "commonTick", "", "world", "Lnet/minecraft/world/World;", "pos", "Lnet/minecraft/util/math/BlockPos;", "state", "Lnet/minecraft/block/BlockState;", "entity", "Lio/github/lucaargolo/lifts/common/blockentity/lift/ElectricLiftBlockEntity;", "lifts"})
    public static final class Companion {
        private Companion() {
        }

        public final int getENERGY_PER_BLOCK() {
            return ENERGY_PER_BLOCK;
        }

        public final void commonTick(@NotNull class_1937 world, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull ElectricLiftBlockEntity entity) {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)state, (String)"state");
            Intrinsics.checkNotNullParameter((Object)((Object)entity), (String)"entity");
            LiftBlockEntity.Companion.commonTick(world, pos, state, entity);
            if (!entity.initializedEnergy) {
                ElectricLift electricLift;
                Lift lift = entity.getLift();
                ElectricLift electricLift2 = electricLift = lift instanceof ElectricLift ? (ElectricLift)lift : null;
                if (electricLift != null) {
                    lift = electricLift;
                    boolean bl = false;
                    boolean bl2 = false;
                    Lift it = lift;
                    boolean bl3 = false;
                    entity.liftMaxInsert = ((ElectricLift)it).getLiftMaxExtract();
                    entity.liftCapacity = ((ElectricLift)it).getElectricLiftConfig().getEnergyCapacity();
                    entity.initializedEnergy = true;
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

