/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.mininglevel;

import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_5414;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MiningLevelManagerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"fabric-mining-level-api-v1/MiningLevelManagerImpl");
    private static final String TOOL_TAG_NAMESPACE = "fabric";
    private static final Pattern TOOL_TAG_PATTERN = Pattern.compile("^needs_tool_level_([0-9]+)$");
    private static final ThreadLocal<Reference2IntMap<class_2680>> CACHE = ThreadLocal.withInitial(Reference2IntOpenHashMap::new);

    public static int getRequiredMiningLevel(class_2680 state) {
        return CACHE.get().computeIntIfAbsent((Object)state, s -> {
            class_5414 blockTags = class_3481.method_15073();
            int miningLevel = -1;
            for (class_2960 tagId : blockTags.method_30206((Object)state.method_26204())) {
                Matcher matcher;
                if (!tagId.method_12836().equals(TOOL_TAG_NAMESPACE) || !(matcher = TOOL_TAG_PATTERN.matcher(tagId.method_12832())).matches()) continue;
                try {
                    int tagMiningLevel = Integer.parseInt(matcher.group(1));
                    miningLevel = Math.max(miningLevel, tagMiningLevel);
                }
                catch (NumberFormatException e) {
                    LOGGER.error("Could not read mining level from tag #{}", (Object)tagId, (Object)e);
                }
            }
            if (state.method_26164((class_3494)class_3481.field_33717)) {
                miningLevel = Math.max(miningLevel, 3);
            } else if (state.method_26164((class_3494)class_3481.field_33718)) {
                miningLevel = Math.max(miningLevel, 2);
            } else if (state.method_26164((class_3494)class_3481.field_33719)) {
                miningLevel = Math.max(miningLevel, 1);
            }
            return miningLevel;
        });
    }

    public static void clearCache() {
        CACHE.get().clear();
    }
}

