/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanus.core.util;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.cammiescorner.arcanus.Arcanus;
import dev.cammiescorner.arcanus.common.items.WandItem;
import dev.cammiescorner.arcanus.common.structure.processor.BookshelfReplacerStructureProcessor;
import dev.cammiescorner.arcanus.common.structure.processor.LecternStructureProcessor;
import dev.cammiescorner.arcanus.core.registry.ModCommands;
import dev.cammiescorner.arcanus.core.util.ArcanusHelper;
import dev.cammiescorner.arcanus.core.util.ArcanusLootFunction;
import dev.cammiescorner.arcanus.core.util.MagicUser;
import java.util.ArrayList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.loot.v1.FabricLootPoolBuilder;
import net.fabricmc.fabric.api.loot.v1.event.LootTableLoadingCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_117;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_219;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3491;
import net.minecraft.class_3781;
import net.minecraft.class_3785;
import net.minecraft.class_44;
import net.minecraft.class_4587;
import net.minecraft.class_5497;
import net.minecraft.class_5658;
import net.minecraft.class_77;
import net.minecraft.class_85;

public class EventHandler {
    private static final class_2960 HUD_ELEMENTS = new class_2960("arcanus", "textures/gui/hud_elements.png");
    private static final class_2960 RUINED_PORTAL_LOOT_TABLE = new class_2960("minecraft", "chests/ruined_portal");
    private static final class_2960 STRONGHOLD_LIBRARY_LOOT_TABLE = new class_2960("minecraft", "chests/stronghold_library");

    @Environment(value=EnvType.CLIENT)
    public static void clientEvents() {
        class_310 client = class_310.method_1551();
        Object manaTimer = new Object(){
            int value;
        };
        HudRenderCallback.EVENT.register((arg_0, arg_1) -> EventHandler.lambda$clientEvents$0(client, manaTimer, arg_0, arg_1));
    }

    public static void commonEvents() {
        ServerLifecycleEvents.SERVER_STARTING.register(server -> EventHandler.addStructureProcessors((class_2385<class_3785>)server.method_30611().method_33309(class_2378.field_25917)));
        LootTableLoadingCallback.EVENT.register((resourceManager, lootManager, id, supplier, setter) -> {
            FabricLootPoolBuilder poolBuilder;
            if (Arcanus.getConfig().strongholdsHaveBooks && STRONGHOLD_LIBRARY_LOOT_TABLE.equals((Object)id) && !FabricLoader.getInstance().isModLoaded("betterstrongholds")) {
                poolBuilder = FabricLootPoolBuilder.builder().rolls((class_5658)class_44.method_32448((float)4.0f)).withCondition(class_219.method_932((float)0.5f).build()).withEntry(EventHandler.createItemEntry(new class_1799((class_1935)class_1802.field_8360)).method_419());
                supplier.withPool(poolBuilder.method_355());
            }
            if (Arcanus.getConfig().ruinedPortalsHaveBooks && RUINED_PORTAL_LOOT_TABLE.equals((Object)id)) {
                poolBuilder = FabricLootPoolBuilder.builder().rolls((class_5658)class_44.method_32448((float)1.0f)).withCondition(class_219.method_932((float)0.1f).build()).withEntry(EventHandler.createItemEntry(new class_1799((class_1935)class_1802.field_8360)).method_419());
                supplier.withPool(poolBuilder.method_355());
            }
        });
        ServerPlayerEvents.COPY_FROM.register((oldPlayer, newPlayer, alive) -> {
            ((MagicUser)newPlayer).setMana(((MagicUser)oldPlayer).getMana());
            ((MagicUser)newPlayer).setBurnout(((MagicUser)oldPlayer).getBurnout());
            ((MagicUser)oldPlayer).getKnownSpells().forEach(spell -> ((MagicUser)newPlayer).setKnownSpell(Arcanus.SPELL.method_10221(spell)));
        });
        CommandRegistrationCallback.EVENT.register(ModCommands::init);
    }

    private static class_85.class_86<?> createItemEntry(class_1799 stack) {
        class_85.class_86 builder = class_77.method_411((class_1935)stack.method_7909());
        builder.method_438((class_117.class_118)new ArcanusLootFunction.Builder());
        return builder;
    }

    public static void addStructureProcessors(class_2385<class_3785> templatePoolRegistry) {
        templatePoolRegistry.forEach(pool -> pool.field_16680.forEach(element -> {
            if (element instanceof class_3781) {
                String currentElement;
                class_3781 singleElement = (class_3781)element;
                if (singleElement.field_24015.left().isPresent() && (Arcanus.getConfig().structuresWithBookshelves.contains(currentElement = ((class_2960)singleElement.field_24015.left().get()).toString()) || Arcanus.getConfig().structuresWithLecterns.contains(currentElement))) {
                    class_5497 originalProcessorList = (class_5497)singleElement.field_16674.get();
                    ArrayList<class_3491> mutableProcessorList = new ArrayList<class_3491>(originalProcessorList.method_31027());
                    if (Arcanus.getConfig().doLecternProcessor) {
                        mutableProcessorList.add(LecternStructureProcessor.INSTANCE);
                    }
                    if (Arcanus.getConfig().doBookshelfProcessor) {
                        mutableProcessorList.add(BookshelfReplacerStructureProcessor.INSTANCE);
                    }
                    class_5497 newProcessorList = new class_5497(mutableProcessorList);
                    singleElement.field_16674 = () -> newProcessorList;
                }
            }
        }));
    }

    private static /* synthetic */ void lambda$clientEvents$0(class_310 client, 1 manaTimer, class_4587 matrices, float tickDelta) {
        class_1657 player;
        class_1297 patt2459$temp = client.field_1719;
        if (patt2459$temp instanceof class_1657 && !(player = (class_1657)patt2459$temp).method_7325() && !player.method_7337()) {
            MagicUser user = (MagicUser)player;
            int mana = Math.min(user.getMana(), user.getMaxMana() - user.getBurnout());
            int burnout = user.getBurnout();
            int manaLock = ArcanusHelper.getManaLock(player);
            manaTimer.value = player.method_6047().method_7909() instanceof WandItem || mana < user.getMaxMana() ? Math.min(manaTimer.value + 1, 40) : Math.max(manaTimer.value - 1, 0);
            if (manaTimer.value > 0) {
                int i;
                int i2;
                user.shouldShowMana(true);
                int scaledWidth = client.method_22683().method_4486();
                int scaledHeight = client.method_22683().method_4502();
                int x = scaledWidth / 2 + 82;
                int y = scaledHeight - (player.method_7337() ? 34 : 49);
                float alpha = manaTimer.value > 20 ? 1.0f : (float)manaTimer.value / 20.0f;
                RenderSystem.enableBlend();
                RenderSystem.setShaderTexture((int)0, (class_2960)HUD_ELEMENTS);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
                for (i2 = 0; i2 < 10; ++i2) {
                    class_332.method_25290((class_4587)matrices, (int)(x - i2 * 8), (int)y, (float)0.0f, (float)15.0f, (int)9, (int)9, (int)256, (int)256);
                }
                for (i2 = 0; i2 < mana / 2; ++i2) {
                    class_332.method_25290((class_4587)matrices, (int)(x - i2 * 8), (int)y, (float)0.0f, (float)0.0f, (int)8, (int)8, (int)256, (int)256);
                }
                if (mana % 2 == 1) {
                    class_332.method_25290((class_4587)matrices, (int)(x - mana / 2 * 8), (int)y, (float)8.0f, (float)0.0f, (int)8, (int)8, (int)256, (int)256);
                }
                boolean manaLockOdd = manaLock % 2 == 1;
                boolean burnoutOdd = burnout % 2 == 1;
                int adjustedBurnout = manaLockOdd && burnoutOdd ? burnout / 2 + 1 : burnout / 2;
                int adjustedManaLock = manaLock / 2 * 8;
                x -= 72;
                for (i = 0; i < adjustedBurnout; ++i) {
                    if (manaLockOdd && i == 0) {
                        class_332.method_25290((class_4587)matrices, (int)(x + adjustedManaLock), (int)y, (float)32.0f, (float)0.0f, (int)8, (int)8, (int)256, (int)256);
                        continue;
                    }
                    class_332.method_25290((class_4587)matrices, (int)(x + adjustedManaLock + i * 8), (int)y, (float)16.0f, (float)0.0f, (int)8, (int)8, (int)256, (int)256);
                }
                if (burnoutOdd != manaLockOdd && burnout > 0) {
                    class_332.method_25290((class_4587)matrices, (int)(x + adjustedManaLock + adjustedBurnout * 8), (int)y, (float)24.0f, (float)0.0f, (int)8, (int)8, (int)256, (int)256);
                }
                for (i = 0; i < manaLock / 2; ++i) {
                    class_332.method_25290((class_4587)matrices, (int)(x + i * 8), (int)y, (float)40.0f, (float)0.0f, (int)8, (int)8, (int)256, (int)256);
                }
                if (manaLock % 2 == 1) {
                    class_332.method_25290((class_4587)matrices, (int)(x + adjustedManaLock), (int)y, (float)48.0f, (float)0.0f, (int)8, (int)8, (int)256, (int)256);
                }
            } else {
                user.shouldShowMana(false);
            }
        }
    }
}

