/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanus.core.registry;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.cammiescorner.arcanus.Arcanus;
import dev.cammiescorner.arcanus.core.util.ArcanusHelper;
import dev.cammiescorner.arcanus.core.util.MagicUser;
import dev.cammiescorner.arcanus.core.util.Spell;
import dev.cammiescorner.arcanus.core.util.SpellBooks;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2314;
import net.minecraft.class_2316;
import net.minecraft.class_2319;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class ModCommands {
    public static void register() {
        class_2316.method_10017((String)"spells", SpellArgumentType.class, (class_2314)new class_2319(SpellArgumentType::new));
    }

    public static void init(CommandDispatcher<class_2168> dispatcher, boolean dedicated) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"spells").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"list").requires(source -> source.method_9259(0))).executes(context -> SpellsCommand.listPlayerSpells((CommandContext<class_2168>)context, (class_1657)((class_2168)context.getSource()).method_9207()))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).requires(source -> source.method_9259(3))).executes(context -> SpellsCommand.listPlayerSpells((CommandContext<class_2168>)context, (class_1657)class_2186.method_9315((CommandContext)context, (String)"player")))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(source -> source.method_9259(3))).then(class_2170.method_9244((String)"all", (ArgumentType)StringArgumentType.word()).executes(SpellsCommand::addAllSpellsToSelf))).then(class_2170.method_9244((String)"spell", (ArgumentType)SpellArgumentType.spell()).executes(SpellsCommand::addSpellToSelf))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"all", (ArgumentType)StringArgumentType.word()).executes(SpellsCommand::addAllSpellsToPlayer))).then(class_2170.method_9244((String)"spell", (ArgumentType)SpellArgumentType.spell()).executes(SpellsCommand::addSpellToPlayer))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(source -> source.method_9259(3))).then(class_2170.method_9244((String)"all", (ArgumentType)StringArgumentType.word()).executes(SpellsCommand::removeAllSpellsFromSelf))).then(class_2170.method_9244((String)"spell", (ArgumentType)SpellArgumentType.spell()).executes(SpellsCommand::removeSpellFromSelf))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).then(class_2170.method_9244((String)"all", (ArgumentType)StringArgumentType.word()).executes(SpellsCommand::removeAllSpellsFromPlayer))).then(class_2170.method_9244((String)"spell", (ArgumentType)SpellArgumentType.spell()).executes(SpellsCommand::removeSpellFromPlayer))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"spellbook").requires(source -> source.method_9259(2))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"all").executes(context -> SpellsCommand.giveSpellBook((CommandContext<class_2168>)context, ((class_2168)context.getSource()).method_9207(), null))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> SpellsCommand.giveSpellBook((CommandContext<class_2168>)context, class_2186.method_9315((CommandContext)context, (String)"player"), null))))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"spell", (ArgumentType)SpellArgumentType.spell()).executes(context -> SpellsCommand.giveSpellBook((CommandContext<class_2168>)context, ((class_2168)context.getSource()).method_9207(), SpellArgumentType.getSpell((CommandContext<class_2168>)context, "spell")))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(context -> SpellsCommand.giveSpellBook((CommandContext<class_2168>)context, class_2186.method_9315((CommandContext)context, (String)"player"), SpellArgumentType.getSpell((CommandContext<class_2168>)context, "spell")))))));
    }

    public static class SpellArgumentType
    implements ArgumentType<Spell> {
        public static final DynamicCommandExceptionType INVALID_SPELL_EXCEPTION = new DynamicCommandExceptionType(object -> new class_2588("commands.arcanus.spells.not_found", new Object[]{object}));

        public static SpellArgumentType spell() {
            return new SpellArgumentType();
        }

        public static Spell getSpell(CommandContext<class_2168> commandContext, String string) {
            return (Spell)commandContext.getArgument(string, Spell.class);
        }

        public Spell parse(StringReader reader) throws CommandSyntaxException {
            class_2960 identifier = class_2960.method_12835((StringReader)reader);
            return (Spell)Arcanus.SPELL.method_17966(identifier).orElseThrow(() -> INVALID_SPELL_EXCEPTION.create((Object)identifier));
        }

        public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
            return class_2172.method_9270((Iterable)Arcanus.SPELL.method_10235(), (SuggestionsBuilder)builder);
        }
    }

    private static class SpellsCommand {
        private SpellsCommand() {
        }

        public static int listPlayerSpells(CommandContext<class_2168> context, class_1657 player) throws CommandSyntaxException {
            if (((MagicUser)player).getKnownSpells().isEmpty()) {
                ((class_2168)context.getSource()).method_9213((class_2561)new class_2588("commands.arcanus.spells.no_known_spells", new Object[]{player.method_5820()}));
                return 0;
            }
            class_2585 knownSpells = new class_2585("");
            for (Spell spell : ((MagicUser)player).getKnownSpells()) {
                knownSpells = knownSpells.method_27693("\n    - ").method_10852((class_2561)new class_2588(spell.getTranslationKey())).method_27693(" (" + spell.getSpellPattern().get(0).getSymbol() + "-" + spell.getSpellPattern().get(1).getSymbol() + "-" + spell.getSpellPattern().get(2).getSymbol() + ")");
            }
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("commands.arcanus.spells.list", new Object[]{player.method_5820(), knownSpells}), false);
            return ((MagicUser)player).getKnownSpells().size();
        }

        public static int addAllSpellsToSelf(CommandContext<class_2168> context) throws CommandSyntaxException {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            MagicUser user = (MagicUser)player;
            if (StringArgumentType.getString(context, (String)"all").equals("all")) {
                Arcanus.SPELL.forEach(spell -> user.setKnownSpell(Arcanus.SPELL.method_10221(spell)));
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("commands.arcanus.spells.added_all", new Object[]{player.method_5820()}), false);
            } else {
                ((class_2168)context.getSource()).method_9213((class_2561)new class_2588("commands.arcanus.spells.not_valid_spell"));
            }
            return 1;
        }

        public static int addSpellToSelf(CommandContext<class_2168> context) throws CommandSyntaxException {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            MagicUser user = (MagicUser)player;
            Spell spell = SpellArgumentType.getSpell(context, "spell");
            if (!user.getKnownSpells().contains(spell)) {
                user.getKnownSpells().add(spell);
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("commands.arcanus.spells.added", new Object[]{Arcanus.SPELL.method_10221((Object)spell), player.method_5820()}), false);
            } else {
                ((class_2168)context.getSource()).method_9213((class_2561)new class_2588("commands.arcanus.spells.already_known", new Object[]{player.method_5820(), Arcanus.SPELL.method_10221((Object)spell)}));
            }
            return 1;
        }

        public static int addAllSpellsToPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
            class_3222 player = class_2186.method_9315(context, (String)"player");
            MagicUser user = (MagicUser)player;
            if (StringArgumentType.getString(context, (String)"all").equals("all")) {
                Arcanus.SPELL.forEach(spell -> user.setKnownSpell(Arcanus.SPELL.method_10221(spell)));
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("commands.arcanus.spells.added_all", new Object[]{player.method_5820()}), false);
            } else {
                ((class_2168)context.getSource()).method_9213((class_2561)new class_2588("commands.arcanus.spells.not_valid_spell"));
            }
            return 1;
        }

        public static int addSpellToPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
            class_3222 player = class_2186.method_9315(context, (String)"player");
            MagicUser user = (MagicUser)player;
            Spell spell = SpellArgumentType.getSpell(context, "spell");
            if (!user.getKnownSpells().contains(spell)) {
                user.getKnownSpells().add(spell);
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("commands.arcanus.spells.added", new Object[]{Arcanus.SPELL.method_10221((Object)spell), player.method_5820()}), false);
            } else {
                ((class_2168)context.getSource()).method_9213((class_2561)new class_2588("commands.arcanus.spells.already_known", new Object[]{player.method_5820(), Arcanus.SPELL.method_10221((Object)spell)}));
            }
            return 1;
        }

        public static int removeAllSpellsFromSelf(CommandContext<class_2168> context) throws CommandSyntaxException {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            ((MagicUser)player).getKnownSpells().clear();
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("commands.arcanus.spells.cleared", new Object[]{player.method_5820()}), false);
            return 1;
        }

        public static int removeSpellFromSelf(CommandContext<class_2168> context) throws CommandSyntaxException {
            class_3222 player = ((class_2168)context.getSource()).method_9207();
            MagicUser user = (MagicUser)player;
            Spell spell = SpellArgumentType.getSpell(context, "spell");
            if (user.getKnownSpells().contains(spell)) {
                user.getKnownSpells().remove(spell);
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("commands.arcanus.spells.removed", new Object[]{Arcanus.SPELL.method_10221((Object)spell), player.method_5820()}), false);
            } else {
                ((class_2168)context.getSource()).method_9213((class_2561)new class_2588("commands.arcanus.spells.does_not_have", new Object[]{player.method_5820(), Arcanus.SPELL.method_10221((Object)spell)}));
            }
            return 1;
        }

        public static int removeAllSpellsFromPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
            class_3222 player = class_2186.method_9315(context, (String)"player");
            ((MagicUser)player).getKnownSpells().clear();
            ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("commands.arcanus.spells.cleared", new Object[]{player.method_5820()}), false);
            return 1;
        }

        public static int removeSpellFromPlayer(CommandContext<class_2168> context) throws CommandSyntaxException {
            class_3222 player = class_2186.method_9315(context, (String)"player");
            MagicUser user = (MagicUser)player;
            Spell spell = SpellArgumentType.getSpell(context, "spell");
            if (user.getKnownSpells().contains(spell)) {
                user.getKnownSpells().remove(spell);
                ((class_2168)context.getSource()).method_9226((class_2561)new class_2588("commands.arcanus.spells.removed", new Object[]{Arcanus.SPELL.method_10221((Object)spell), player.method_5820()}), false);
            } else {
                ((class_2168)context.getSource()).method_9213((class_2561)new class_2588("commands.arcanus.spells.does_not_have", new Object[]{player.method_5820(), Arcanus.SPELL.method_10221((Object)spell)}));
            }
            return 1;
        }

        public static int giveSpellBook(CommandContext<class_2168> context, class_3222 player, Spell spell) {
            if (spell == null) {
                Arcanus.SPELL.forEach(spell1 -> SpellsCommand.giveSpellBook(player, spell1));
                return 1;
            }
            SpellsCommand.giveSpellBook(player, spell);
            return 1;
        }

        public static void giveSpellBook(class_3222 player, Spell spell) {
            class_1799 book = SpellBooks.getSpellBook(spell);
            ArcanusHelper.giveOrDrop(player, book);
        }
    }
}

