/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanus.core.mixin;

import dev.cammiescorner.arcanus.Arcanus;
import dev.cammiescorner.arcanus.common.entities.ArcaneBarrierEntity;
import dev.cammiescorner.arcanus.common.entities.MagicMissileEntity;
import dev.cammiescorner.arcanus.common.entities.SolarStrikeEntity;
import dev.cammiescorner.arcanus.core.registry.ModParticles;
import dev.cammiescorner.arcanus.core.registry.ModSoundEvents;
import dev.cammiescorner.arcanus.core.registry.ModSpells;
import dev.cammiescorner.arcanus.core.util.ArcanusHelper;
import dev.cammiescorner.arcanus.core.util.CanBeDiscombobulated;
import dev.cammiescorner.arcanus.core.util.MagicUser;
import dev.cammiescorner.arcanus.core.util.Spell;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1540;
import net.minecraft.class_1541;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1702;
import net.minecraft.class_1923;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2530;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5132;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityMixin
extends class_1309
implements MagicUser {
    @Shadow
    protected class_1702 field_7493;
    @Unique
    private final List<Spell> knownSpells = new ArrayList<Spell>(8);
    @Unique
    private Spell activeSpell = null;
    @Unique
    private long lastCastTime = 0L;
    @Unique
    private int spellTimer = 0;
    @Unique
    private static final int MAX_MANA = 20;
    @Unique
    private final List<class_1297> hasHit = new ArrayList<class_1297>();

    @Shadow
    public abstract void method_7322(float var1);

    @Shadow
    public abstract void method_7353(class_2561 var1, boolean var2);

    protected PlayerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(method={"createPlayerAttributes"}, at={@At(value="RETURN")})
    private static void createPlayerAttributes(CallbackInfoReturnable<class_5132.class_5133> info) {
        ((class_5132.class_5133)info.getReturnValue()).method_26867(Arcanus.EntityAttributes.MANA_COST).method_26867(Arcanus.EntityAttributes.MANA_REGEN).method_26867(Arcanus.EntityAttributes.BURNOUT_REGEN).method_26867(Arcanus.EntityAttributes.MANA_LOCK);
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    public void tick(CallbackInfo info) {
        if (!this.field_6002.method_8608()) {
            if (this.getMana() > this.getMaxMana()) {
                this.setMana(this.getMana());
            }
            if (this.getBurnout() > this.getMaxBurnout()) {
                this.setBurnout(this.getBurnout());
            }
            if (this.activeSpell != null) {
                if (ModSpells.LUNGE.equals(this.activeSpell)) {
                    this.castLunge();
                }
                if (ModSpells.DREAM_WARP.equals(this.activeSpell)) {
                    this.castDreamWarp();
                }
                if (ModSpells.MAGIC_MISSILE.equals(this.activeSpell)) {
                    this.castMagicMissile();
                }
                if (ModSpells.TELEKINESIS.equals(this.activeSpell)) {
                    this.castTelekinesis();
                }
                if (ModSpells.HEAL.equals(this.activeSpell)) {
                    this.castHeal();
                }
                if (ModSpells.DISCOMBOBULATE.equals(this.activeSpell)) {
                    this.castDiscombobulate();
                }
                if (ModSpells.SOLAR_STRIKE.equals(this.activeSpell)) {
                    this.castSolarStrike();
                }
                if (ModSpells.ARCANE_BARRIER.equals(this.activeSpell)) {
                    this.castArcaneBarrier();
                }
            }
            if (this.spellTimer-- <= 0) {
                this.spellTimer = 0;
            }
            if (this.field_6002.method_8510() >= this.lastCastTime + 20L) {
                int manaCooldown = (int)Math.round((double)Arcanus.getConfig().baseManaCooldown * ArcanusHelper.getManaRegen((class_1657)this));
                int burnoutCooldown = (int)Math.round((double)Arcanus.getConfig().baseBurnoutCooldown * ArcanusHelper.getBurnoutRegen((class_1657)this));
                if (manaCooldown != 0 && this.getMana() < this.getMaxMana() - this.getBurnout() && this.field_6002.method_8510() % (long)manaCooldown == 0L) {
                    this.addMana(1);
                }
                if (burnoutCooldown != 0 && this.getBurnout() > 0 && this.field_7493.method_7586() > 0 && this.field_6002.method_8510() % (long)burnoutCooldown == 0L) {
                    this.addBurnout(-1);
                    this.method_7322(5.0f);
                }
            }
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    public void readNbt(class_2487 tag, CallbackInfo info) {
        class_2487 rootTag = tag.method_10562("arcanus");
        class_2499 listTag = rootTag.method_10554("KnownSpells", 8);
        for (int i = 0; i < listTag.size(); ++i) {
            Arcanus.SPELL.method_17966(new class_2960(listTag.method_10608(i))).ifPresent(this.knownSpells::add);
        }
        this.field_6011.method_12778(Arcanus.DataTrackers.MANA, (Object)rootTag.method_10550("Mana"));
        this.field_6011.method_12778(Arcanus.DataTrackers.BURNOUT, (Object)rootTag.method_10550("Burnout"));
        this.field_6011.method_12778(Arcanus.DataTrackers.SHOW_MANA, (Object)rootTag.method_10577("ShowMana"));
        this.activeSpell = (Spell)Arcanus.SPELL.method_10223(new class_2960(rootTag.method_10558("ActiveSpell")));
        this.lastCastTime = rootTag.method_10537("LastCastTime");
        this.spellTimer = rootTag.method_10550("SpellTimer");
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    public void writeNbt(class_2487 tag, CallbackInfo info) {
        class_2487 rootTag = new class_2487();
        class_2499 listTag = new class_2499();
        tag.method_10566("arcanus", (class_2520)rootTag);
        this.knownSpells.forEach(spell -> listTag.add((Object)class_2519.method_23256((String)Arcanus.SPELL.method_10221(spell).toString())));
        rootTag.method_10566("KnownSpells", (class_2520)listTag);
        rootTag.method_10569("Mana", ((Integer)this.field_6011.method_12789(Arcanus.DataTrackers.MANA)).intValue());
        rootTag.method_10569("Burnout", ((Integer)this.field_6011.method_12789(Arcanus.DataTrackers.BURNOUT)).intValue());
        rootTag.method_10556("ShowMana", ((Boolean)this.field_6011.method_12789(Arcanus.DataTrackers.SHOW_MANA)).booleanValue());
        rootTag.method_10582("ActiveSpell", this.activeSpell != null ? Arcanus.SPELL.method_10221((Object)this.activeSpell).toString() : "");
        rootTag.method_10544("LastCastTime", this.lastCastTime);
        rootTag.method_10569("SpellTimer", this.spellTimer);
    }

    @Inject(method={"initDataTracker"}, at={@At(value="HEAD")})
    public void initTracker(CallbackInfo info) {
        this.field_6011.method_12784(Arcanus.DataTrackers.MANA, (Object)20);
        this.field_6011.method_12784(Arcanus.DataTrackers.BURNOUT, (Object)0);
        this.field_6011.method_12784(Arcanus.DataTrackers.SHOW_MANA, (Object)false);
    }

    @Override
    public List<Spell> getKnownSpells() {
        return this.knownSpells;
    }

    @Override
    public void setKnownSpell(class_2960 spellId) {
        Spell spell = (Spell)Arcanus.SPELL.method_10223(spellId);
        if (!this.knownSpells.contains(spell)) {
            this.knownSpells.add(spell);
        } else if (spell != null) {
            Arcanus.LOGGER.warn("Spell " + spell.getTranslationKey() + " is already known!");
        }
    }

    @Override
    public int getMana() {
        return (Integer)this.field_6011.method_12789(Arcanus.DataTrackers.MANA);
    }

    @Override
    public int getMaxMana() {
        return 20 - ArcanusHelper.getManaLock((class_1657)this);
    }

    @Override
    public void setMana(int amount) {
        this.field_6011.method_12778(Arcanus.DataTrackers.MANA, (Object)class_3532.method_15340((int)amount, (int)0, (int)this.getMaxMana()));
    }

    @Override
    public void addMana(int amount) {
        this.setMana(Math.min(this.getMana() + amount, this.getMaxMana()));
    }

    @Override
    public int getBurnout() {
        return (Integer)this.field_6011.method_12789(Arcanus.DataTrackers.BURNOUT);
    }

    @Override
    public int getMaxBurnout() {
        return this.getMaxMana();
    }

    @Override
    public void setBurnout(int amount) {
        this.field_6011.method_12778(Arcanus.DataTrackers.BURNOUT, (Object)class_3532.method_15340((int)amount, (int)0, (int)this.getMaxBurnout()));
    }

    @Override
    public void addBurnout(int amount) {
        this.setBurnout(Math.min(this.getBurnout() + amount, this.getMaxBurnout()));
    }

    public void setManaLock(int amount) {
        this.setMana(this.getMana());
        this.setBurnout(this.getBurnout());
    }

    @Override
    public boolean isManaVisible() {
        return (Boolean)this.field_6011.method_12789(Arcanus.DataTrackers.SHOW_MANA);
    }

    @Override
    public void shouldShowMana(boolean shouldShowMana) {
        this.field_6011.method_12778(Arcanus.DataTrackers.SHOW_MANA, (Object)shouldShowMana);
    }

    @Override
    public void setLastCastTime(long lastCastTime) {
        this.lastCastTime = lastCastTime;
    }

    @Override
    public void setActiveSpell(Spell spell, int timer) {
        this.activeSpell = spell;
        this.spellTimer = timer;
    }

    @Unique
    public void castLunge() {
        if (this.method_6128()) {
            if (this.spellTimer == 10) {
                this.field_6002.method_8396(null, this.method_24515(), class_3417.field_15231, class_3419.field_15248, 2.0f, (this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.2f + 1.0f);
            }
            if (this.spellTimer > 0) {
                class_243 rotation = this.method_5720();
                class_243 velocity = this.method_18798();
                float speed = 0.75f;
                this.method_18799(velocity.method_1031(rotation.field_1352 * (double)speed + (rotation.field_1352 * 1.5 - velocity.field_1352), rotation.field_1351 * (double)speed + (rotation.field_1351 * 1.5 - velocity.field_1351), rotation.field_1350 * (double)speed + (rotation.field_1350 * 1.5 - velocity.field_1350)));
                this.field_6002.method_8335(null, this.method_5829().method_1014(2.0)).forEach(entity -> {
                    if (entity != this && entity instanceof class_1309 && !this.hasHit.contains(entity)) {
                        entity.method_5643(class_1282.method_5532((class_1657)((class_1657)this)), 10.0f);
                        this.hasHit.add((class_1297)entity);
                    }
                });
                this.field_6037 = true;
            }
            if (this.method_24828() || this.spellTimer <= 0) {
                this.activeSpell = null;
                this.hasHit.clear();
            }
        } else {
            if (this.spellTimer == 10) {
                this.method_18800(0.0, 0.75, 0.0);
                this.field_6002.method_8396(null, this.method_24515(), class_3417.field_15231, class_3419.field_15248, 2.0f, (this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.2f + 1.0f);
            }
            float adjustedPitch = class_3532.method_15379((float)(class_3532.method_15379((float)(this.method_36455() / 90.0f)) - 1.0f));
            if (this.spellTimer > 0) {
                this.method_5762((this.method_5720().field_1352 * (double)0.025f + (this.method_5720().field_1352 - this.method_18798().field_1352)) * (double)adjustedPitch, 0.0, (this.method_5720().field_1350 * (double)0.025f + (this.method_5720().field_1350 - this.method_18798().field_1350)) * (double)adjustedPitch);
                this.field_6002.method_8335(null, this.method_5829().method_1014(2.0)).forEach(entity -> {
                    if (entity != this && entity instanceof class_1309 && !this.hasHit.contains(entity)) {
                        entity.method_5643(class_1282.method_5532((class_1657)((class_1657)this)), 10.0f);
                        this.hasHit.add((class_1297)entity);
                    }
                });
                this.field_6037 = true;
            }
            this.field_6017 = 0.0f;
            if (this.method_24828() && this.spellTimer <= 8) {
                this.spellTimer = 0;
                this.field_6002.method_8437((class_1297)this, this.method_23317(), this.method_23318() + 0.5, this.method_23321(), 1.0f, class_1927.class_4179.field_18685);
                this.activeSpell = null;
                this.hasHit.clear();
            }
        }
    }

    @Unique
    public void castDreamWarp() {
        class_3222 serverPlayer = (class_3222)this;
        class_3218 serverWorld = serverPlayer.method_5682().method_3847(serverPlayer.method_26281());
        class_2338 spawnPos = serverPlayer.method_26280();
        class_243 rotation = serverPlayer.method_5828(1.0f);
        float spawnAngle = serverPlayer.method_30631();
        boolean hasSpawnPoint = serverPlayer.method_26282();
        Optional optionalSpawnPoint = serverWorld != null && spawnPos != null ? class_1657.method_26091((class_3218)serverWorld, (class_2338)spawnPos, (float)spawnAngle, (boolean)hasSpawnPoint, (boolean)true) : Optional.empty();
        if (optionalSpawnPoint.isPresent()) {
            class_243 spawnPoint = (class_243)optionalSpawnPoint.get();
            System.out.println(spawnPoint);
            this.field_6002.method_8396(null, this.method_24515(), class_3417.field_14879, class_3419.field_15248, 2.0f, 1.0f);
            serverPlayer.method_14251(serverWorld, spawnPoint.field_1352, spawnPoint.field_1351, spawnPoint.field_1350, (float)rotation.field_1352, (float)rotation.field_1351);
            this.field_6002.method_8396(null, this.method_24515(), class_3417.field_14879, class_3419.field_15248, 2.0f, 1.0f);
        } else {
            this.method_7353((class_2561)new class_2588("block.minecraft.spawn.not_valid"), false);
        }
        this.activeSpell = null;
    }

    @Unique
    public void castMagicMissile() {
        MagicMissileEntity magicMissile = new MagicMissileEntity(this, this.field_6002);
        magicMissile.method_24919((class_1297)this, this.method_36455(), this.method_36454(), this.method_6003(), 4.5f, 0.0f);
        this.field_6002.method_8649((class_1297)magicMissile);
        this.field_6002.method_8396(null, this.method_24515(), ModSoundEvents.MAGIC_MISSILE, class_3419.field_15248, 2.0f, (this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.2f + 1.0f);
        this.activeSpell = null;
    }

    @Unique
    public void castTelekinesis() {
        class_239 result = ArcanusHelper.raycast((class_1297)this, 10.0, true);
        class_243 rotation = this.method_5828(1.0f);
        double startDivisor = 5.0;
        double endDivisor = 15.0;
        for (int count = 0; count < 8; ++count) {
            class_243 startPos = this.method_5836(1.0f).method_1031((double)(this.field_6002.field_9229.nextInt(3) - 1) / startDivisor, (double)(this.field_6002.field_9229.nextInt(3) - 1) / startDivisor, (double)(this.field_6002.field_9229.nextInt(3) - 1) / startDivisor);
            class_243 endPos = result.method_17784().method_1031((double)(this.field_6002.field_9229.nextInt(3) - 1) / endDivisor, (double)(this.field_6002.field_9229.nextInt(3) - 1) / endDivisor, (double)(this.field_6002.field_9229.nextInt(3) - 1) / endDivisor);
            ArcanusHelper.drawLine(startPos, endPos, this.field_6002, 0.5, (class_2394)ModParticles.TELEKINETIC_SHOCK);
        }
        this.field_6002.method_8396(null, this.method_24515(), ModSoundEvents.TELEKINETIC_SHOCK, class_3419.field_15248, 2.0f, (this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.2f + 1.0f);
        switch (result.method_17783()) {
            case field_1331: {
                class_2338 pos = ((class_3966)result).method_17782().method_24515();
                class_238 box = new class_238(pos);
                this.field_6002.method_8333((class_1297)this, box, class_1301.field_6154).forEach(target -> {
                    if (target instanceof class_1665) {
                        class_1665 projectile = (class_1665)target;
                        projectile.method_26352();
                    }
                    target.method_18799(rotation.method_1021(2.5));
                    target.field_6037 = true;
                });
                break;
            }
            case field_1332: {
                class_2338 pos = ((class_3965)result).method_17777();
                class_238 box = new class_238(pos);
                class_2680 state = this.field_6002.method_8320(pos);
                class_2248 block = state.method_26204();
                if (block instanceof class_2530) {
                    class_2530.method_10737((class_1937)this.field_6002, (class_2338)pos, (class_1309)this);
                    this.field_6002.method_8652(pos, class_2246.field_10124.method_9564(), 11);
                    this.field_6002.method_8390(class_1541.class, box, tnt -> tnt.method_5805() && tnt.method_6970() == this).forEach(target -> {
                        target.method_18799(rotation.method_1021(2.5));
                        target.field_6037 = true;
                    });
                }
                if (!(block instanceof class_2346)) break;
                class_2346 fallingBlock = (class_2346)block;
                class_1540 target2 = new class_1540(this.field_6002, (double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, state);
                fallingBlock.method_10132(target2);
                target2.method_18799(rotation.method_1021(2.5));
                target2.field_6037 = true;
                this.field_6002.method_8649((class_1297)target2);
            }
        }
        this.activeSpell = null;
    }

    @Unique
    public void castHeal() {
        this.method_6025(10.0f);
        this.field_6002.method_8396(null, this.method_24515(), ModSoundEvents.HEAL, class_3419.field_15248, 2.0f, (this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.2f + 1.0f);
        for (int amount = 0; amount < 32; ++amount) {
            float offsetX = (float)(this.field_5974.nextInt(3) - 1) * this.field_5974.nextFloat();
            float offsetY = this.field_5974.nextFloat() * 2.0f;
            float offsetZ = (float)(this.field_5974.nextInt(3) - 1) * this.field_5974.nextFloat();
            ((class_3218)this.field_6002).method_14199((class_2394)ModParticles.HEAL, this.method_23317() + (double)offsetX, this.method_23318() - 0.5 + (double)offsetY, this.method_23321() + (double)offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
        this.activeSpell = null;
    }

    @Unique
    public void castDiscombobulate() {
        class_239 result = ArcanusHelper.raycast((class_1297)this, 4.0, true);
        double startDivisor = 5.0;
        double endDivisor = 15.0;
        for (int count = 0; count < 8; ++count) {
            class_243 startPos = this.method_5836(1.0f).method_1031((double)(this.field_6002.field_9229.nextInt(3) - 1) / startDivisor, (double)(this.field_6002.field_9229.nextInt(3) - 1) / startDivisor, (double)(this.field_6002.field_9229.nextInt(3) - 1) / startDivisor);
            class_243 endPos = result.method_17784().method_1031((double)(this.field_6002.field_9229.nextInt(3) - 1) / endDivisor, (double)(this.field_6002.field_9229.nextInt(3) - 1) / endDivisor, (double)(this.field_6002.field_9229.nextInt(3) - 1) / endDivisor);
            ArcanusHelper.drawLine(startPos, endPos, this.field_6002, 0.5, (class_2394)ModParticles.DISCOMBOBULATE);
        }
        if (result.method_17783() == class_239.class_240.field_1331) {
            class_1297 class_12972 = ((class_3966)result).method_17782();
            if (class_12972 instanceof CanBeDiscombobulated) {
                CanBeDiscombobulated target = (CanBeDiscombobulated)class_12972;
                target.setDiscombobulated(true);
                target.setDiscombobulatedTimer(160);
            }
        } else {
            this.method_7353((class_2561)new class_2588("spell.arcanus.no_target"), false);
        }
        this.activeSpell = null;
    }

    @Unique
    public void castSolarStrike() {
        class_239 result = ArcanusHelper.raycast((class_1297)this, 640.0, false);
        if (result.method_17783() != class_239.class_240.field_1333) {
            class_1923 chunkPos = new class_1923(new class_2338(result.method_17784()));
            ((class_3218)this.field_6002).method_17988(chunkPos.field_9181, chunkPos.field_9180, true);
            SolarStrikeEntity solarStrike = new SolarStrikeEntity(this, this.field_6002);
            solarStrike.method_33574(result.method_17784());
            this.field_6002.method_8649((class_1297)solarStrike);
        } else {
            this.method_7353((class_2561)new class_2588("spell.arcanus.no_target"), false);
        }
        this.activeSpell = null;
    }

    @Unique
    public void castArcaneBarrier() {
        class_239 result = ArcanusHelper.raycast((class_1297)this, 24.0, false);
        if (result.method_17783() == class_239.class_240.field_1332) {
            class_3965 blockResult = (class_3965)result;
            class_2350 side = blockResult.method_17780();
            ArcaneBarrierEntity arcaneWall = new ArcaneBarrierEntity((class_1657)this, this.field_6002);
            class_2338 pos = blockResult.method_17777().method_10069(side.method_10148(), side.method_10164(), side.method_10165());
            arcaneWall.method_5814((double)pos.method_10263() + 0.5, pos.method_10264(), (double)pos.method_10260() + 0.5);
            this.field_6002.method_8649((class_1297)arcaneWall);
        } else {
            this.method_7353((class_2561)new class_2588("spell.arcanus.no_target"), false);
        }
        this.activeSpell = null;
    }
}

