/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanus.core.mixin;

import dev.cammiescorner.arcanus.core.util.CanBeDiscombobulated;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297
implements CanBeDiscombobulated {
    @Unique
    private static final class_2940<Boolean> IS_DISCOMBOBULATED = class_2945.method_12791(class_1309.class, (class_2941)class_2943.field_13323);
    @Unique
    private static final class_2940<Integer> DISCOMBOBULATED_TIMER = class_2945.method_12791(class_1309.class, (class_2941)class_2943.field_13327);

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @ModifyVariable(method={"travel"}, at=@At(value="HEAD"))
    public class_243 invertInput(class_243 movementInput) {
        if (this.isDiscombobulated()) {
            movementInput = movementInput.method_18805(-1.0, 1.0, -1.0);
        }
        return movementInput;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void tick(CallbackInfo info) {
        if (this.isDiscombobulated() && this.getDiscombobulatedTimer() > 0) {
            this.setDiscombobulatedTimer(this.getDiscombobulatedTimer() - 1);
        } else {
            this.setDiscombobulated(false);
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    public void readNbt(class_2487 tag, CallbackInfo info) {
        class_2487 rootTag = tag.method_10562("arcanus");
        this.field_6011.method_12778(IS_DISCOMBOBULATED, (Object)rootTag.method_10577("IsDiscombobulated"));
        this.field_6011.method_12778(DISCOMBOBULATED_TIMER, (Object)rootTag.method_10550("DiscombobulatedTimer"));
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    public void writeNbt(class_2487 tag, CallbackInfo info) {
        class_2487 rootTag = new class_2487();
        tag.method_10566("arcanus", (class_2520)rootTag);
        rootTag.method_10556("IsDiscombobulated", ((Boolean)this.field_6011.method_12789(IS_DISCOMBOBULATED)).booleanValue());
        rootTag.method_10569("DiscombobulatedTimer", ((Integer)this.field_6011.method_12789(DISCOMBOBULATED_TIMER)).intValue());
    }

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    public void initTracker(CallbackInfo info) {
        this.field_6011.method_12784(IS_DISCOMBOBULATED, (Object)false);
        this.field_6011.method_12784(DISCOMBOBULATED_TIMER, (Object)0);
    }

    @Override
    public boolean isDiscombobulated() {
        return (Boolean)this.field_6011.method_12789(IS_DISCOMBOBULATED);
    }

    @Override
    public void setDiscombobulated(boolean discombobulated) {
        this.field_6011.method_12778(IS_DISCOMBOBULATED, (Object)discombobulated);
    }

    @Override
    public int getDiscombobulatedTimer() {
        return (Integer)this.field_6011.method_12789(DISCOMBOBULATED_TIMER);
    }

    @Override
    public void setDiscombobulatedTimer(int time) {
        this.field_6011.method_12778(DISCOMBOBULATED_TIMER, (Object)time);
    }
}

