/*
 * Decompiled with CFR 0.152.
 */
package dev.cammiescorner.arcanus.client;

import dev.cammiescorner.arcanus.Arcanus;
import dev.cammiescorner.arcanus.client.particle.DiscombobulateParticle;
import dev.cammiescorner.arcanus.client.particle.HealParticle;
import dev.cammiescorner.arcanus.client.particle.MagicMissileParticle;
import dev.cammiescorner.arcanus.client.particle.TelekineticShockParticle;
import dev.cammiescorner.arcanus.client.renderer.blockentity.DisplayCaseBlockEntityRenderer;
import dev.cammiescorner.arcanus.client.renderer.entity.ArcaneBarrierEntityRenderer;
import dev.cammiescorner.arcanus.client.renderer.entity.MagicMissileEntityRenderer;
import dev.cammiescorner.arcanus.client.renderer.entity.SolarStrikeEntityRenderer;
import dev.cammiescorner.arcanus.client.screens.BookshelfScreen;
import dev.cammiescorner.arcanus.core.registry.ModBlockEntities;
import dev.cammiescorner.arcanus.core.registry.ModBlocks;
import dev.cammiescorner.arcanus.core.registry.ModEntities;
import dev.cammiescorner.arcanus.core.registry.ModParticles;
import dev.cammiescorner.arcanus.core.util.EventHandler;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendereregistry.v1.BlockEntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendereregistry.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.client.screenhandler.v1.ScreenRegistry;
import net.fabricmc.fabric.api.object.builder.v1.client.model.FabricModelPredicateProviderRegistry;
import net.minecraft.class_1921;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_4668;
import net.minecraft.class_5944;
import org.jetbrains.annotations.Nullable;

public class ArcanusClient
implements ClientModInitializer {
    @Nullable
    public static class_5944 renderTypeMagicShader;
    public static final class_1921 MAGIC;

    public void onInitializeClient() {
        this.screenRegistry();
        this.entityRendererRegistry();
        this.particleFactoryRegistry();
        this.itemPredicateRegistry();
        this.blockRenderLayerRegistry();
        this.blockEntityRendererRegistry();
        EventHandler.clientEvents();
    }

    public void screenRegistry() {
        ScreenRegistry.register(Arcanus.BOOKSHELF_SCREEN_HANDLER, BookshelfScreen::new);
    }

    public void entityRendererRegistry() {
        EntityRendererRegistry.INSTANCE.register(ModEntities.SOLAR_STRIKE, SolarStrikeEntityRenderer::new);
        EntityRendererRegistry.INSTANCE.register(ModEntities.ARCANE_BARRIER, ArcaneBarrierEntityRenderer::new);
        EntityRendererRegistry.INSTANCE.register(ModEntities.MAGIC_MISSILE, MagicMissileEntityRenderer::new);
    }

    public void particleFactoryRegistry() {
        ParticleFactoryRegistry.getInstance().register(ModParticles.MAGIC_MISSILE, MagicMissileParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register(ModParticles.TELEKINETIC_SHOCK, TelekineticShockParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register(ModParticles.HEAL, HealParticle.Factory::new);
        ParticleFactoryRegistry.getInstance().register(ModParticles.DISCOMBOBULATE, DiscombobulateParticle.Factory::new);
    }

    public void itemPredicateRegistry() {
        FabricModelPredicateProviderRegistry.register((class_2960)new class_2960("arcanus", "mana"), (stack, world, entity, seed) -> {
            class_2487 tag = stack.method_7941("arcanus");
            if (tag == null) {
                return 0.0f;
            }
            return (float)tag.method_10550("Mana") / 4.0f;
        });
    }

    public void blockRenderLayerRegistry() {
        BlockRenderLayerMap.INSTANCE.putBlocks(class_1921.method_23581(), new class_2248[]{ModBlocks.DISPLAY_CASE});
    }

    public void blockEntityRendererRegistry() {
        BlockEntityRendererRegistry.INSTANCE.register(ModBlockEntities.DISPLAY_CASE, DisplayCaseBlockEntityRenderer::new);
    }

    static {
        MAGIC = class_1921.method_24049((String)"magic", (class_293)class_290.field_1576, (class_293.class_5596)class_293.class_5596.field_27382, (int)256, (boolean)false, (boolean)true, (class_1921.class_4688)class_1921.class_4688.method_23598().method_34578(new class_4668.class_5942(() -> renderTypeMagicShader)).method_23616(class_1921.field_21349).method_23615(class_1921.field_21367).method_23610(class_1921.field_25282).method_23617(false));
    }
}

