/*
 * Decompiled with CFR 0.152.
 */
package uk.co.algid.fabricemotes.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import uk.co.algid.fabricemotes.emotes.Emote;
import uk.co.algid.fabricemotes.emotes.EmoteRegistry;
import uk.co.algid.fabricemotes.render.RenderEmote;
import uk.co.algid.fabricemotes.text.TextReaderVisitor;

public class EmoteRenderHelper {
    public static List<RenderEmote> extractEmotes(TextReaderVisitor textReaderVisitor, class_327 textRenderer, float renderX, float renderY) {
        ArrayList<RenderEmote> renderEmoteList = new ArrayList<RenderEmote>();
        Pattern emotePattern = Pattern.compile("(?:\\s|^)(\u258f([0-9]+))(?:\\s|$)");
        boolean emotesLeft = true;
        block2: while (emotesLeft) {
            String textStr = textReaderVisitor.getString();
            Matcher emoteMatch = emotePattern.matcher(textStr);
            while (emotesLeft = emoteMatch.find()) {
                String emoteIdStr = emoteMatch.group(2);
                try {
                    int emoteId = Integer.parseInt(emoteIdStr);
                    Emote emote = EmoteRegistry.getInstance().getEmoteById(emoteId);
                    int startPos = emoteMatch.start(1);
                    int endPos = emoteMatch.end(1);
                    if (emote == null) continue;
                    float beforeTextWidth = textRenderer.method_1727(textStr.substring(0, startPos));
                    renderEmoteList.add(new RenderEmote(emote, renderX + beforeTextWidth, renderY));
                    textReaderVisitor.replaceBetween(startPos, endPos, "  ", class_2583.field_24360);
                    continue block2;
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
        }
        return renderEmoteList;
    }

    public static void drawEmote(class_4587 matrices, RenderEmote renderEmote, float size, float alpha, float sizeMult, float maxWidthMult) {
        Emote emote = renderEmote.getEmote();
        float scaleX = (float)emote.getWidth() / (float)emote.getHeight() * sizeMult;
        float scaleY = sizeMult;
        if (scaleX > maxWidthMult) {
            scaleX = maxWidthMult;
            scaleY = maxWidthMult * ((float)emote.getHeight() / (float)emote.getWidth());
        }
        scaleX = (float)Math.round(size * scaleX) / size;
        scaleY = (float)Math.round(size * scaleY) / size;
        int x = (int)(renderEmote.getX() + size * (1.0f - scaleX) / 2.0f);
        int y = (int)(renderEmote.getY() + size * (1.0f - scaleY) / 2.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)emote.getTextureIdentifier());
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alpha);
        int frameNumber = 1;
        if (emote.isAnimated()) {
            frameNumber = (int)(System.currentTimeMillis() / (long)emote.getFrameTimeMs() % (long)emote.getFrameCount());
        }
        class_332.method_25293((class_4587)matrices, (int)x, (int)y, (int)Math.round(size * scaleX), (int)Math.round(size * scaleY), (float)0.0f, (float)(emote.getHeight() * frameNumber), (int)emote.getWidth(), (int)emote.getHeight(), (int)emote.getSheetWidth(), (int)emote.getSheetHeight());
    }
}

