/*
 * Decompiled with CFR 0.152.
 */
package uk.co.algid.fabricemotes.emotes;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import uk.co.algid.fabricemotes.emotes.Emote;

public class EmoteRegistry {
    private final Logger LOGGER = LogManager.getLogger((String)"fabricemotes.emotes.EmoteRegistry");
    private static EmoteRegistry emoteRegistry;
    public ConcurrentHashMap<Integer, Emote> emoteIdMap;
    public ConcurrentHashMap<String, Emote> emoteMap;

    private EmoteRegistry() {
    }

    public static EmoteRegistry getInstance() {
        if (emoteRegistry == null) {
            emoteRegistry = new EmoteRegistry();
        }
        return emoteRegistry;
    }

    public void init() {
        this.emoteIdMap = new ConcurrentHashMap();
        this.emoteMap = new ConcurrentHashMap();
        try {
            this.registerEmote(new Emote("Bedge", "bedge.png"));
            this.registerEmote(new Emote("bright_eyes", "bright-eyes.png"));
            this.registerEmote(new Emote("catCry", "cat-cry.png"));
            this.registerEmote(new Emote("catScream", "cat-scream.png"));
            this.registerEmote(new Emote("cryIgnore", "cry-ignore.png"));
            this.registerEmote(new Emote("ded", "ded.png"));
            this.registerEmote(new Emote("ggeeAww", "ggee-aww.png"));
            this.registerEmote(new Emote("ggeeCoffee", "ggee-coffee.png"));
            this.registerEmote(new Emote("ggeeFacePalm", "ggee-face-palm.png"));
            this.registerEmote(new Emote("ggeeHaha", "ggee-haha.png"));
            this.registerEmote(new Emote("ggeeHello", "ggee-hello.png"));
            this.registerEmote(new Emote("ggeeHmm", "ggee-hmm.png"));
            this.registerEmote(new Emote("ggeeOmg", "ggee-omg.png"));
            this.registerEmote(new Emote("ggeeOOOO", "ggee-oooo.png"));
            this.registerEmote(new Emote("ggeeSleep", "ggee-sleep.png"));
            this.registerEmote(new Emote("ggeeTeeHee", "ggee-tee-hee.png"));
            this.registerEmote(new Emote("ggeeWhycry", "ggee-whycry.png"));
            this.registerEmote(new Emote("ggeeWut", "ggee-wut.png"));
            this.registerEmote(new Emote("Hmm", "hmm.png"));
            this.registerEmote(new Emote("Hmmge", "hmmge.png"));
            this.registerEmote(new Emote("KEKW", "kekw.png"));
            this.registerEmote(new Emote("Madge", "madge.png"));
            this.registerEmote(new Emote("monkaS", "monkas.png"));
            this.registerEmote(new Emote("NEways", "neways.png"));
            this.registerEmote(new Emote("noSanity", "no-sanity.png"));
            this.registerEmote(new Emote("Okayge", "okayge.png"));
            this.registerEmote(new Emote("peepoBlush", "peepo-blush.png"));
            this.registerEmote(new Emote("peepoHappy", "peepo-happy.png"));
            this.registerEmote(new Emote("peepoHappyGun", "peepo-happy-gun.png"));
            this.registerEmote(new Emote("peepoPoint", "peepo-point.png"));
            this.registerEmote(new Emote("peepoSelfie", "peepo-selfie.png"));
            this.registerEmote(new Emote("PepeHands", "pepe-hands.png"));
            this.registerEmote(new Emote("PepeNotes", "pepe-notes.png"));
            this.registerEmote(new Emote("POGGIES", "poggies.png"));
            this.registerEmote(new Emote("Prayge", "prayge.png"));
            this.registerEmote(new Emote("Sadge", "sadge.png"));
            this.registerEmote(new Emote("Smadge", "smadge.png"));
            this.registerEmote(new Emote("Starege", "starege.png"));
            this.registerEmote(new Emote("suffer", "suffer.png"));
            this.registerEmote(new Emote("Susge", "susge.png"));
            this.registerEmote(new Emote("YesHoney", "yes-honey.png"));
            this.registerEmote(new Emote("catJAM", "animated/catjam.png", 40));
            this.registerEmote(new Emote("HYPERJAMMIES", "animated/hyperjammies.png", 20));
            this.registerEmote(new Emote("HYPERS", "animated/hypers.png", 70));
            this.registerEmote(new Emote("Jammies", "animated/jammies.png", 90));
            this.registerEmote(new Emote("MONKE", "animated/monke.png", 30));
            this.registerEmote(new Emote("NODDERS", "animated/nodders.png", 20));
            this.registerEmote(new Emote("NOPERS", "animated/nopers.png", 70));
            this.registerEmote(new Emote("peepoShy", "animated/peepo-shy.png", 250));
            this.registerEmote(new Emote("Tastyge", "animated/tastyge.png", 30));
        }
        catch (Exception e) {
            this.LOGGER.error("init(): Failed to load emotes", (Throwable)e);
        }
    }

    public void registerEmote(Emote emote) throws Exception {
        if (this.emoteMap.containsKey(emote.getName())) {
            throw new Exception("Emote with the name " + emote.getName() + " already exists, failed to register");
        }
        this.emoteIdMap.put(emote.getId(), emote);
        this.emoteMap.put(emote.getName(), emote);
    }

    public Emote getEmoteById(int id) {
        return this.emoteIdMap.get(id);
    }

    public Emote getEmoteByName(String name) {
        return this.emoteMap.get(name);
    }

    public Collection<String> getEmoteSuggestions() {
        return Lists.newArrayList(this.emoteMap.keys().asIterator()).stream().map(name -> ":" + name + ":").collect(Collectors.toList());
    }
}

