/*
 * Decompiled with CFR 0.152.
 */
package uk.co.algid.fabricemotes.emotes;

import java.awt.image.BufferedImage;
import java.io.IOException;
import javax.imageio.ImageIO;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;

public class Emote {
    private static int currEmoteId = 0;
    private int id = currEmoteId++;
    private String name;
    private String filename;
    private int width;
    private int height;
    private int frameCount;
    private int frameTimeMs;

    public Emote(String name, String filename) throws IOException {
        this(name, filename, 0);
    }

    public Emote(String name, String filename, int frameTimeMs) throws IOException {
        this.name = name;
        this.filename = filename;
        this.frameTimeMs = frameTimeMs;
        try (class_3298 resource = class_310.method_1551().method_1478().method_14486(this.getTextureIdentifier());
             class_3298 resource2 = class_310.method_1551().method_1478().method_14486(this.getTextureIdentifier());){
            BufferedImage bufferedImage = ImageIO.read(resource.method_14482());
            if (bufferedImage == null) {
                throw new IOException("Failed to load image: " + filename);
            }
            this.width = bufferedImage.getWidth();
            this.height = bufferedImage.getHeight();
            if (this.isAnimated()) {
                this.frameCount = this.height / this.width;
                this.height = this.width;
            } else {
                this.frameCount = 1;
            }
        }
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public int getFrameTimeMs() {
        return this.frameTimeMs;
    }

    public boolean isAnimated() {
        return this.frameTimeMs > 0;
    }

    public int getSheetWidth() {
        return this.width;
    }

    public int getSheetHeight() {
        return this.height * this.frameCount;
    }

    public class_2960 getTextureIdentifier() {
        return new class_2960("chatemotes:emotes/" + this.filename);
    }
}

