/*
 * Decompiled with CFR 0.152.
 */
package team.reborn.energy.api.base;

import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_2350;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public abstract class SimpleSidedEnergyContainer
extends SnapshotParticipant<Long> {
    public long amount = 0L;
    private final SideStorage[] sideStorages = new SideStorage[7];

    public SimpleSidedEnergyContainer() {
        for (int i = 0; i < 7; ++i) {
            this.sideStorages[i] = new SideStorage(i == 6 ? null : class_2350.method_10143((int)i));
        }
    }

    public abstract long getCapacity();

    public abstract long getMaxInsert(@Nullable class_2350 var1);

    public abstract long getMaxExtract(@Nullable class_2350 var1);

    public EnergyStorage getSideStorage(@Nullable class_2350 side) {
        return this.sideStorages[side == null ? 6 : side.method_10146()];
    }

    protected Long createSnapshot() {
        return this.amount;
    }

    protected void readSnapshot(Long snapshot) {
        this.amount = snapshot;
    }

    private class SideStorage
    implements EnergyStorage {
        private final class_2350 side;

        private SideStorage(class_2350 side) {
            this.side = side;
        }

        @Override
        public boolean supportsInsertion() {
            return SimpleSidedEnergyContainer.this.getMaxInsert(this.side) > 0L;
        }

        @Override
        public long insert(long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notNegative((long)maxAmount);
            long inserted = Math.min(SimpleSidedEnergyContainer.this.getMaxInsert(this.side), Math.min(maxAmount, this.getCapacity() - SimpleSidedEnergyContainer.this.amount));
            if (inserted > 0L) {
                SimpleSidedEnergyContainer.this.updateSnapshots(transaction);
                SimpleSidedEnergyContainer.this.amount += inserted;
                return inserted;
            }
            return 0L;
        }

        @Override
        public boolean supportsExtraction() {
            return SimpleSidedEnergyContainer.this.getMaxExtract(this.side) > 0L;
        }

        @Override
        public long extract(long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notNegative((long)maxAmount);
            long extracted = Math.min(SimpleSidedEnergyContainer.this.getMaxExtract(this.side), Math.min(maxAmount, SimpleSidedEnergyContainer.this.amount));
            if (extracted > 0L) {
                SimpleSidedEnergyContainer.this.updateSnapshots(transaction);
                SimpleSidedEnergyContainer.this.amount -= extracted;
                return extracted;
            }
            return 0L;
        }

        @Override
        public long getAmount() {
            return SimpleSidedEnergyContainer.this.amount;
        }

        @Override
        public long getCapacity() {
            return SimpleSidedEnergyContainer.this.getCapacity();
        }
    }
}

