/*
 * Decompiled with CFR 0.152.
 */
package team.reborn.energy.api.base;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public class DelegatingEnergyStorage
implements EnergyStorage {
    protected final Supplier<EnergyStorage> backingStorage;
    protected final BooleanSupplier validPredicate;

    public DelegatingEnergyStorage(EnergyStorage backingStorage, @Nullable BooleanSupplier validPredicate) {
        this(() -> backingStorage, validPredicate);
        Objects.requireNonNull(backingStorage);
    }

    public DelegatingEnergyStorage(Supplier<EnergyStorage> backingStorage, @Nullable BooleanSupplier validPredicate) {
        this.backingStorage = Objects.requireNonNull(backingStorage);
        this.validPredicate = validPredicate == null ? () -> true : validPredicate;
    }

    @Override
    public boolean supportsInsertion() {
        return this.validPredicate.getAsBoolean() && this.backingStorage.get().supportsInsertion();
    }

    @Override
    public long insert(long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative((long)maxAmount);
        if (this.validPredicate.getAsBoolean()) {
            return this.backingStorage.get().insert(maxAmount, transaction);
        }
        return 0L;
    }

    @Override
    public boolean supportsExtraction() {
        return this.validPredicate.getAsBoolean() && this.backingStorage.get().supportsExtraction();
    }

    @Override
    public long extract(long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notNegative((long)maxAmount);
        if (this.validPredicate.getAsBoolean()) {
            return this.backingStorage.get().extract(maxAmount, transaction);
        }
        return 0L;
    }

    @Override
    public long getAmount() {
        if (this.validPredicate.getAsBoolean()) {
            return this.backingStorage.get().getAmount();
        }
        return 0L;
    }

    @Override
    public long getCapacity() {
        if (this.validPredicate.getAsBoolean()) {
            return this.backingStorage.get().getCapacity();
        }
        return 0L;
    }
}

