/*
 * Decompiled with CFR 0.152.
 */
package team.reborn.energy.api;

import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;
import team.reborn.energy.api.EnergyStorage;

public class EnergyStorageUtil {
    public static long move(@Nullable EnergyStorage from, @Nullable EnergyStorage to, long maxAmount, @Nullable TransactionContext transaction) {
        long maxExtracted;
        if (from == null || to == null) {
            return 0L;
        }
        StoragePreconditions.notNegative((long)maxAmount);
        try (Transaction extractionTestTransaction = Transaction.openNested((TransactionContext)transaction);){
            maxExtracted = from.extract(maxAmount, (TransactionContext)extractionTestTransaction);
        }
        try (Transaction moveTransaction = Transaction.openNested((TransactionContext)transaction);){
            long accepted = to.insert(maxExtracted, (TransactionContext)moveTransaction);
            if (from.extract(accepted, (TransactionContext)moveTransaction) == accepted) {
                moveTransaction.commit();
                long l = accepted;
                return l;
            }
        }
        return 0L;
    }

    public static boolean isEnergyStorage(class_1799 stack) {
        return ContainerItemContext.withInitial((class_1799)stack).find(EnergyStorage.ITEM) != null;
    }

    private EnergyStorageUtil() {
    }
}

