/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.init;

import com.yungnickyoung.minecraft.betterdungeons.BetterDungeons;
import com.yungnickyoung.minecraft.betterdungeons.init.BDModStructureFeatures;
import com.yungnickyoung.minecraft.betterdungeons.mixin.accessor.StructureSettingsAccessor;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.skeleton_dungeon.SkeletonDungeonStructure;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.small_dungeon.SmallDungeonStructureFeature;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.SpiderDungeonStructure;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.zombie_dungeon.ZombieDungeonStructure;
import com.yungnickyoung.minecraft.yungsapi.api.YungJigsawConfig;
import java.util.HashMap;
import net.fabricmc.fabric.api.biome.v1.BiomeModifications;
import net.fabricmc.fabric.api.biome.v1.ModificationPhase;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3037;
import net.minecraft.class_3111;
import net.minecraft.class_3195;
import net.minecraft.class_5311;
import net.minecraft.class_5312;
import net.minecraft.class_5314;
import net.minecraft.class_5458;
import net.minecraft.class_6812;
import org.apache.logging.log4j.util.TriConsumer;

public class BDModConfiguredStructures {
    public static class_5312<?, ?> CONFIGURED_SMALL_DUNGEON = BDModStructureFeatures.SMALL_DUNGEON.method_28659((class_3037)new YungJigsawConfig(new class_2960("betterdungeons", "small_dungeon"), 10));
    public static class_5312<?, ?> CONFIGURED_SPIDER_DUNGEON = BDModStructureFeatures.SPIDER_DUNGEON.method_28659((class_3037)class_3111.field_24894);
    public static class_5312<?, ?> CONFIGURED_SKELETON_DUNGEON = BDModStructureFeatures.SKELETON_DUNGEON.method_28659((class_3037)new YungJigsawConfig(new class_2960("betterdungeons", "skeleton_dungeon"), 20));
    public static class_5312<?, ?> CONFIGURED_ZOMBIE_DUNGEON = BDModStructureFeatures.ZOMBIE_DUNGEON.method_28659((class_3037)new YungJigsawConfig(new class_2960("betterdungeons", "zombie_dungeon"), 20));

    public static void init() {
        BDModConfiguredStructures.registerConfiguredStructures();
        BDModConfiguredStructures.addConfiguredStructuresToBiomes();
        BDModConfiguredStructures.enforceDimensionWhitelist();
    }

    private static void registerConfiguredStructures() {
        class_2378 registry = class_5458.field_25930;
        class_2378.method_10230((class_2378)registry, (class_2960)new class_2960("betterdungeons", "small_dungeon"), CONFIGURED_SMALL_DUNGEON);
        class_2378.method_10230((class_2378)registry, (class_2960)new class_2960("betterdungeons", "spider_dungeon"), CONFIGURED_SPIDER_DUNGEON);
        class_2378.method_10230((class_2378)registry, (class_2960)new class_2960("betterdungeons", "skeleton_dungeon"), CONFIGURED_SKELETON_DUNGEON);
        class_2378.method_10230((class_2378)registry, (class_2960)new class_2960("betterdungeons", "zombie_dungeon"), CONFIGURED_ZOMBIE_DUNGEON);
    }

    private static void addConfiguredStructuresToBiomes() {
        if (BetterDungeons.CONFIG.betterDungeons.general.removeVanillaDungeons) {
            BiomeModifications.create((class_2960)new class_2960("betterdungeons", "vanilla_dungeon_removal")).add(ModificationPhase.REMOVALS, biomeSelectionContext -> biomeSelectionContext.hasBuiltInPlacedFeature(class_6812.field_35980), modificationContext -> modificationContext.getGenerationSettings().removeBuiltInFeature(class_6812.field_35980)).add(ModificationPhase.REMOVALS, biomeSelectionContext -> biomeSelectionContext.hasBuiltInPlacedFeature(class_6812.field_35981), modificationContext -> modificationContext.getGenerationSettings().removeBuiltInFeature(class_6812.field_35981));
        }
        if (BetterDungeons.CONFIG.betterDungeons.smallDungeon.enableSmallDungeons) {
            BiomeModifications.create((class_2960)new class_2960("betterdungeons", "small_dungeon_addition")).add(ModificationPhase.ADDITIONS, biomeSelectionContext -> !SmallDungeonStructureFeature.blacklistedBiomes.contains(biomeSelectionContext.getBiomeKey().method_29177().toString()), modificationContext -> modificationContext.getGenerationSettings().addBuiltInStructure(CONFIGURED_SMALL_DUNGEON));
        }
        if (BetterDungeons.CONFIG.betterDungeons.spiderDungeon.enableSpiderDungeons) {
            BiomeModifications.create((class_2960)new class_2960("betterdungeons", "spider_dungeon_addition")).add(ModificationPhase.ADDITIONS, biomeSelectionContext -> !SpiderDungeonStructure.blacklistedBiomes.contains(biomeSelectionContext.getBiomeKey().method_29177().toString()), modificationContext -> modificationContext.getGenerationSettings().addBuiltInStructure(CONFIGURED_SPIDER_DUNGEON));
        }
        if (BetterDungeons.CONFIG.betterDungeons.skeletonDungeon.enableSkeletonDungeons) {
            BiomeModifications.create((class_2960)new class_2960("betterdungeons", "skeleton_dungeon_addition")).add(ModificationPhase.ADDITIONS, biomeSelectionContext -> !SkeletonDungeonStructure.blacklistedBiomes.contains(biomeSelectionContext.getBiomeKey().method_29177().toString()), modificationContext -> modificationContext.getGenerationSettings().addBuiltInStructure(CONFIGURED_SKELETON_DUNGEON));
        }
        if (BetterDungeons.CONFIG.betterDungeons.zombieDungeon.enableZombieDungeons) {
            BiomeModifications.create((class_2960)new class_2960("betterdungeons", "zombie_dungeon_addition")).add(ModificationPhase.ADDITIONS, biomeSelectionContext -> !ZombieDungeonStructure.blacklistedBiomes.contains(biomeSelectionContext.getBiomeKey().method_29177().toString()), modificationContext -> modificationContext.getGenerationSettings().addBuiltInStructure(CONFIGURED_ZOMBIE_DUNGEON));
        }
    }

    public static void enforceDimensionWhitelist() {
        class_2960 runAfterFabricAPIPhase = new class_2960("betterdungeons", "run_after_fabric_api");
        ServerWorldEvents.LOAD.addPhaseOrdering(Event.DEFAULT_PHASE, runAfterFabricAPIPhase);
        ServerWorldEvents.LOAD.register(runAfterFabricAPIPhase, (minecraftServer, serverLevel) -> {
            class_5311 structureSettings = serverLevel.method_14178().method_12129().method_12109();
            HashMap tempMap = new HashMap(structureSettings.method_28598());
            TriConsumer whitelistHandler = (whitelist, structure, structureConfig) -> {
                if (whitelist.contains(serverLevel.method_27983().method_29177().toString())) {
                    tempMap.putIfAbsent((class_3195<?>)structure, (class_5314)structureConfig);
                } else {
                    tempMap.remove(structure);
                }
            };
            whitelistHandler.accept(SmallDungeonStructureFeature.whitelistedDimensions, BDModStructureFeatures.SMALL_DUNGEON, (Object)BDModStructureFeatures.SMALL_DUNGEON_CONFIG);
            whitelistHandler.accept(SpiderDungeonStructure.whitelistedDimensions, BDModStructureFeatures.SPIDER_DUNGEON, (Object)BDModStructureFeatures.SPIDER_DUNGEON_CONFIG);
            whitelistHandler.accept(SkeletonDungeonStructure.whitelistedDimensions, BDModStructureFeatures.SKELETON_DUNGEON, (Object)BDModStructureFeatures.SKELETON_DUNGEON_CONFIG);
            whitelistHandler.accept(ZombieDungeonStructure.whitelistedDimensions, BDModStructureFeatures.ZOMBIE_DUNGEON, (Object)BDModStructureFeatures.ZOMBIE_DUNGEON_CONFIG);
            ((StructureSettingsAccessor)structureSettings).setStructureConfig(tempMap);
        });
    }
}

