/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.libcd.mixin;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.cottonmc.libcd.impl.CustomRewardsUtils;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.class_170;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_170.class})
public class MixinAdvancementRewards
implements CustomRewardsUtils {
    private final Map<class_2960, JsonObject> settings = Maps.newHashMap();
    private final Map<class_2960, BiConsumer<class_3222, JsonObject>> appliers = Maps.newHashMap();

    @Inject(method={"apply"}, at={@At(value="TAIL")})
    public void onApply(class_3222 serverPlayerEntity, CallbackInfo ci) {
        this.getAllAppliers().forEach((id, applier) -> applier.accept(serverPlayerEntity, this.getSettings((class_2960)id)));
    }

    @Inject(method={"toJson"}, at={@At(value="TAIL")}, cancellable=true)
    public void onToJson(CallbackInfoReturnable<JsonElement> cir) {
        JsonObject jsonObject = ((JsonElement)cir.getReturnValue()).getAsJsonObject();
        JsonArray jsonArray = new JsonArray();
        this.getAllSettings().forEach((id, settings) -> {
            if (settings == null) {
                jsonArray.add(id.toString());
            } else {
                JsonObject current = new JsonObject();
                current.addProperty("name", id.toString());
                current.add("settings", (JsonElement)settings);
                jsonArray.add((JsonElement)current);
            }
        });
        jsonObject.add("libcd:custom", (JsonElement)jsonArray);
        cir.setReturnValue((Object)jsonObject);
    }

    @Override
    public Map<class_2960, JsonObject> getAllSettings() {
        return this.settings;
    }

    @Override
    public void setAllSettings(Map<class_2960, JsonObject> rewardsSettings) {
        this.settings.putAll(rewardsSettings);
    }

    @Override
    public JsonObject getSettings(class_2960 id) {
        return this.settings.get(id);
    }

    @Override
    public void setSettings(class_2960 id, JsonObject settings) {
        this.settings.put(id, settings);
    }

    @Override
    public Map<class_2960, BiConsumer<class_3222, JsonObject>> getAllAppliers() {
        return this.appliers;
    }

    @Override
    public void setAllAppliers(Map<class_2960, BiConsumer<class_3222, JsonObject>> appliers) {
        this.appliers.putAll(appliers);
    }

    @Override
    public BiConsumer<class_3222, JsonObject> getApplier(class_2960 id) {
        return this.appliers.get(id);
    }

    @Override
    public void setApplier(class_2960 id, BiConsumer<class_3222, JsonObject> applier) {
        this.appliers.put(id, applier);
    }
}

