/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.libcd.loader;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.cottonmc.libcd.api.CDSyntaxError;
import io.github.cottonmc.libcd.api.condition.ConditionalData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3494;

public final class TagExtensions {
    private TagExtensions() {
    }

    public static ExtensionResult load(JsonObject json) {
        boolean shouldReplace = false;
        ArrayList<class_3494.class_3496> entries = new ArrayList<class_3494.class_3496>();
        ArrayList<String> warnings = new ArrayList<String>();
        class_2960 defaultEntry = null;
        if (json.has("replace")) {
            shouldReplace = TagExtensions.testCondition(json.get("replace"), warnings);
        }
        if (json.has("entries")) {
            JsonElement rawEntries = json.get("entries");
            if (!(rawEntries instanceof JsonArray)) {
                throw new IllegalArgumentException("'entries' tag in LibCD tag extensions is not an array: " + rawEntries);
            }
            JsonArray entryArray = (JsonArray)rawEntries;
            for (JsonElement rawEntry : entryArray) {
                if (!(rawEntry instanceof JsonObject)) {
                    warnings.add("Tag extension entry '" + rawEntry + "' is not a JsonObject! Skipping...");
                    continue;
                }
                JsonObject entry = (JsonObject)rawEntry;
                if (!TagExtensions.testCondition(entry.get("when"), warnings)) continue;
                JsonElement rawValues = entry.get("values");
                if (!(rawValues instanceof JsonArray)) {
                    warnings.add("'values' of tag extension entry '" + rawEntry + "' is not a JsonArray! Skipping...");
                    continue;
                }
                JsonArray values = (JsonArray)rawValues;
                for (int i = 0; i < values.size(); ++i) {
                    String value = values.get(i).getAsString();
                    if (value == null) {
                        warnings.add("Could not convert JSON element '" + values.get(i) + "' to a string in tag extensions! Skipping...");
                        continue;
                    }
                    if (value.startsWith("#")) {
                        entries.add((class_3494.class_3496)new class_3494.class_3497(new class_2960(value.substring(1))));
                        continue;
                    }
                    entries.add((class_3494.class_3496)new class_3494.class_5122(new class_2960(value)));
                }
            }
        }
        if (json.has("default")) {
            defaultEntry = new class_2960(json.get("default").getAsString());
        }
        return new ExtensionResult(shouldReplace, entries, warnings, defaultEntry);
    }

    private static boolean testCondition(JsonElement condition, List<String> warnings) {
        if (condition instanceof JsonArray) {
            for (JsonElement child : (JsonArray)condition) {
                if (TagExtensions.testCondition(child, warnings)) continue;
                return false;
            }
            return true;
        }
        if (!(condition instanceof JsonObject)) {
            warnings.add("Error parsing tag extensions: item '" + condition + "' in condition list not a JsonObject");
            return false;
        }
        JsonObject obj = (JsonObject)condition;
        for (Map.Entry entry : obj.entrySet()) {
            class_2960 id;
            String key = (String)entry.getKey();
            class_2960 class_29602 = id = key.equals("or") ? new class_2960("libcd", "or") : class_2960.method_12829((String)key);
            if (id == null || !ConditionalData.hasCondition(id)) {
                warnings.add("Found unknown condition: " + key);
            }
            try {
                if (ConditionalData.testCondition(id, ConditionalData.parseElement(obj.get(key)))) continue;
                return false;
            }
            catch (CDSyntaxError e) {
                warnings.add("Error parsing tag extensions: item '" + condition + "' in condition list errored: " + e.getMessage());
                return false;
            }
        }
        return true;
    }

    public static final class ExtensionResult {
        private final boolean shouldReplace;
        private final List<class_3494.class_3496> entries;
        private final List<String> warnings;
        private final class_2960 defaultEntry;

        public ExtensionResult(boolean shouldReplace, List<class_3494.class_3496> entries, List<String> warnings, class_2960 defaultEntry) {
            this.shouldReplace = shouldReplace;
            this.entries = entries;
            this.warnings = warnings;
            this.defaultEntry = defaultEntry;
        }

        public boolean shouldReplace() {
            return this.shouldReplace;
        }

        public List<class_3494.class_3496> getEntries() {
            return this.entries;
        }

        public List<String> getWarnings() {
            return this.warnings;
        }

        public class_2960 getDefaultEntry() {
            return this.defaultEntry;
        }
    }
}

