/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.libcd.api.condition;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.cottonmc.libcd.api.CDCommons;
import io.github.cottonmc.libcd.api.CDSyntaxError;
import io.github.cottonmc.libcd.api.condition.Condition;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.class_2960;
import net.minecraft.class_3518;

public class ConditionalData {
    static final Map<class_2960, Condition> conditions = new HashMap<class_2960, Condition>();

    public static boolean shouldLoad(class_2960 resourceId, String meta) {
        if (conditions.isEmpty()) {
            CDCommons.logger.warn("List of conditions is empty, loading {} anyway", (Object)resourceId);
            return true;
        }
        JsonObject json = class_3518.method_15285((String)meta);
        JsonElement elem = json.get("when");
        if (elem instanceof JsonArray) {
            JsonArray array = (JsonArray)elem;
            for (JsonElement condition : array) {
                if (!(condition instanceof JsonObject)) {
                    CDCommons.logger.error("Error parsing meta for{}: item {} in condition list not a JsonObject", (Object)resourceId, (Object)condition.toString());
                    return false;
                }
                JsonObject obj = (JsonObject)condition;
                for (Map.Entry entry : obj.entrySet()) {
                    String key = (String)entry.getKey();
                    class_2960 id = key.equals("or") ? new class_2960("libcd", "or") : new class_2960(key);
                    try {
                        if (ConditionalData.testCondition(id, ConditionalData.parseElement(obj.get(key)))) continue;
                        return false;
                    }
                    catch (CDSyntaxError e) {
                        CDCommons.logger.error("Error parsing meta for {}: {}", (Object)resourceId, (Object)e.getMessage());
                    }
                }
            }
        } else {
            if (elem == null) {
                CDCommons.logger.error("Error parsing meta for {}: primary \"when\" key does not exist", (Object)resourceId);
                return false;
            }
            CDCommons.logger.error("Error parsing meta for {}: primary \"when\" key is not a JsonArray", (Object)resourceId);
            return false;
        }
        return true;
    }

    @Nullable
    public static Object parseElement(JsonElement element) {
        if (element instanceof JsonPrimitive) {
            JsonPrimitive prim = (JsonPrimitive)element;
            if (prim.isNumber()) {
                return prim.getAsNumber();
            }
            if (prim.isBoolean()) {
                return prim.getAsBoolean();
            }
            return prim.getAsString();
        }
        if (element instanceof JsonNull) {
            return null;
        }
        return element;
    }

    public static boolean hasCondition(class_2960 id) {
        return conditions.containsKey(id);
    }

    public static boolean testCondition(class_2960 id, Object toTest) throws CDSyntaxError {
        if (!ConditionalData.hasCondition(id)) {
            throw new CDSyntaxError("Condition " + id.toString() + "does not exist");
        }
        return conditions.get(id).test(toTest);
    }
}

