/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.libcd;

import com.google.gson.Gson;
import io.github.cottonmc.libcd.CDConfig;
import io.github.cottonmc.libcd.api.CDCommons;
import io.github.cottonmc.libcd.api.LibCDInitializer;
import io.github.cottonmc.libcd.api.advancement.AdvancementRewardsManager;
import io.github.cottonmc.libcd.api.condition.ConditionManager;
import io.github.cottonmc.libcd.api.init.AdvancementInitializer;
import io.github.cottonmc.libcd.api.init.ConditionInitializer;
import io.github.cottonmc.libcd.loot.DefaultedTagEntrySerializer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5335;
import net.minecraft.class_5338;

public class LibCD
implements ModInitializer {
    public static final String MODID = "libcd";
    public static CDConfig config;

    public static boolean isDevMode() {
        return LibCD.config.dev_mode;
    }

    public void onInitialize() {
        config = LibCD.loadConfig();
        FabricLoader.getInstance().getEntrypoints("libcd:conditions", ConditionInitializer.class).forEach(init -> init.initConditions(ConditionManager.INSTANCE));
        FabricLoader.getInstance().getEntrypoints("libcd:advancement_rewards", AdvancementInitializer.class).forEach(init -> init.initAdvancementRewards(AdvancementRewardsManager.INSTANCE));
        FabricLoader.getInstance().getEntrypoints(MODID, LibCDInitializer.class).forEach(init -> {
            init.initConditions(ConditionManager.INSTANCE);
            init.initAdvancementRewards(AdvancementRewardsManager.INSTANCE);
        });
        class_2378.method_10230((class_2378)class_2378.field_25293, (class_2960)new class_2960(MODID, "defaulted_tag"), (Object)new class_5338((class_5335)new DefaultedTagEntrySerializer()));
    }

    public static CDConfig loadConfig() {
        try {
            Gson gson = CDCommons.newGson();
            File file = FabricLoader.getInstance().getConfigDir().resolve("libcd.json").toFile();
            if (!file.exists()) {
                LibCD.saveConfig(new CDConfig());
            }
            FileReader reader = new FileReader(file);
            return (CDConfig)gson.fromJson((Reader)reader, CDConfig.class);
        }
        catch (IOException e) {
            CDCommons.logger.error("Error loading config: {}", (Object)e.getMessage());
            return new CDConfig();
        }
    }

    public static void saveConfig(CDConfig config) {
        try {
            File file = FabricLoader.getInstance().getConfigDir().resolve("libcd.json").toFile();
            String result = CDCommons.newGson().toJson((Object)config);
            if (!file.exists()) {
                file.createNewFile();
            }
            FileOutputStream out = new FileOutputStream(file, false);
            out.write(result.getBytes());
            out.flush();
            out.close();
        }
        catch (Exception e) {
            CDCommons.logger.error("Error saving config: {}", (Object)e.getMessage());
        }
    }
}

