/*
 * Decompiled with CFR 0.152.
 */
package io.github.cottonmc.libcd;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.github.cottonmc.libcd.LibCD;
import io.github.cottonmc.libcd.api.CDSyntaxError;
import io.github.cottonmc.libcd.api.LibCDInitializer;
import io.github.cottonmc.libcd.api.advancement.AdvancementRewardsManager;
import io.github.cottonmc.libcd.api.condition.ConditionManager;
import io.github.cottonmc.libcd.api.condition.ConditionalData;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5323;

public class CDContent
implements LibCDInitializer {
    @Override
    public void initConditions(ConditionManager manager) {
        manager.registerCondition(new class_2960("libcd", "mod_loaded"), value -> {
            if (value instanceof String) {
                return FabricLoader.getInstance().isModLoaded((String)value);
            }
            if (value instanceof List) {
                for (JsonElement el : (List)value) {
                    if (!(el instanceof JsonPrimitive)) {
                        return false;
                    }
                    String name = el.getAsString();
                    if (FabricLoader.getInstance().isModLoaded(name)) continue;
                    return false;
                }
                return true;
            }
            throw new CDSyntaxError("mod_loaded must accept either a String or an Array!");
        });
        manager.registerCondition(new class_2960("libcd", "item_exists"), value -> {
            if (value instanceof String) {
                return class_2378.field_11142.method_10223(new class_2960((String)value)) != class_1802.field_8162;
            }
            if (value instanceof List) {
                for (JsonElement el : (List)value) {
                    if (!(el instanceof JsonPrimitive)) {
                        throw new CDSyntaxError("item_exists array must only contain Strings!");
                    }
                    String name = el.getAsString();
                    if (class_2378.field_11142.method_10223(new class_2960(name)) != class_1802.field_8162) continue;
                    return false;
                }
                return true;
            }
            throw new CDSyntaxError("item_exists must accept either a String or an Array!");
        });
        manager.registerCondition(new class_2960("libcd", "item_tag_exists"), value -> {
            if (value instanceof String) {
                return class_5323.method_29223().method_30218().method_30211().contains(new class_2960((String)value));
            }
            if (value instanceof List) {
                for (JsonElement el : (List)value) {
                    if (!(el instanceof JsonPrimitive)) {
                        throw new CDSyntaxError("item_tag_exists array must only contain Strings!");
                    }
                    String name = el.getAsString();
                    class_2960 id = new class_2960(name);
                    if (!class_5323.method_29223().method_30218().method_30211().contains(id)) {
                        return false;
                    }
                    if (!class_5323.method_29223().method_30218().method_30213(id).method_15138().isEmpty()) continue;
                    return false;
                }
                return true;
            }
            throw new CDSyntaxError("item_tag_exists must accept either a String or an Array!");
        });
        manager.registerCondition(new class_2960("libcd", "block_exists"), value -> {
            if (value instanceof String) {
                return class_2378.field_11146.method_10223(new class_2960((String)value)) != class_2246.field_10124;
            }
            if (value instanceof List) {
                for (JsonElement el : (List)value) {
                    if (!(el instanceof JsonPrimitive)) {
                        throw new CDSyntaxError("block_exists array must only contain Strings!");
                    }
                    String name = el.getAsString();
                    if (class_2378.field_11146.method_10223(new class_2960(name)) != class_2246.field_10124) continue;
                    return false;
                }
                return true;
            }
            throw new CDSyntaxError("block_exists must accept either a String or an Array!");
        });
        manager.registerCondition(new class_2960("libcd", "block_tag_exists"), value -> {
            if (value instanceof String) {
                return class_5323.method_29223().method_30215().method_30211().contains(new class_2960((String)value));
            }
            if (value instanceof List) {
                for (JsonElement el : (List)value) {
                    if (!(el instanceof JsonPrimitive)) {
                        throw new CDSyntaxError("block_tag_exists array must only contain Strings!");
                    }
                    String name = el.getAsString();
                    class_2960 id = new class_2960(name);
                    if (!class_5323.method_29223().method_30215().method_30211().contains(id)) {
                        return false;
                    }
                    if (!class_5323.method_29223().method_30215().method_30213(id).method_15138().isEmpty()) continue;
                    return false;
                }
                return true;
            }
            throw new CDSyntaxError("block_tag_exists must accept either a String or an Array!");
        });
        manager.registerCondition(new class_2960("libcd", "not"), value -> {
            JsonObject json;
            Iterator iterator;
            if (value instanceof JsonObject && (iterator = (json = (JsonObject)value).entrySet().iterator()).hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String key = (String)entry.getKey();
                class_2960 id = new class_2960(key);
                Object result = ConditionalData.parseElement(json.get(key));
                if (ConditionalData.hasCondition(id)) {
                    return !ConditionalData.testCondition(id, result);
                }
                return false;
            }
            throw new CDSyntaxError("not must accept an Object!");
        });
        manager.registerCondition(new class_2960("libcd", "none"), value -> {
            if (value instanceof JsonArray) {
                JsonArray json = (JsonArray)value;
                for (JsonElement elem : json) {
                    if (!(elem instanceof JsonObject)) continue;
                    JsonObject obj = (JsonObject)elem;
                    for (Map.Entry entry : obj.entrySet()) {
                        String key = (String)entry.getKey();
                        if (!ConditionalData.testCondition(new class_2960(key), ConditionalData.parseElement(obj.get(key)))) continue;
                        return false;
                    }
                }
                return true;
            }
            throw new CDSyntaxError("none must accept an Array!");
        });
        manager.registerCondition(new class_2960("libcd", "or"), value -> {
            if (value instanceof JsonArray) {
                JsonArray json = (JsonArray)value;
                for (JsonElement elem : json) {
                    if (!(elem instanceof JsonObject)) continue;
                    JsonObject obj = (JsonObject)elem;
                    for (Map.Entry entry : obj.entrySet()) {
                        String key = (String)entry.getKey();
                        if (!ConditionalData.testCondition(new class_2960(key), ConditionalData.parseElement(obj.get(key)))) continue;
                        return true;
                    }
                }
            }
            throw new CDSyntaxError("or must accept an Array!");
        });
        manager.registerCondition(new class_2960("libcd", "xor"), value -> {
            if (value instanceof JsonArray) {
                JsonArray json = (JsonArray)value;
                boolean ret = false;
                for (JsonElement elem : json) {
                    if (!(elem instanceof JsonObject)) continue;
                    JsonObject obj = (JsonObject)elem;
                    for (Map.Entry entry : obj.entrySet()) {
                        String key = (String)entry.getKey();
                        if (!ConditionalData.testCondition(new class_2960(key), ConditionalData.parseElement(obj.get(key)))) continue;
                        if (ret) {
                            return false;
                        }
                        ret = true;
                    }
                }
                return ret;
            }
            throw new CDSyntaxError("xor must accept an Array!");
        });
        manager.registerCondition(new class_2960("libcd", "dev_mode"), value -> {
            if (value instanceof Boolean) {
                return (Boolean)value == LibCD.isDevMode();
            }
            throw new CDSyntaxError("dev_mode must accept a Boolean!");
        });
    }

    @Override
    public void initAdvancementRewards(AdvancementRewardsManager manager) {
    }
}

