/*
 * Decompiled with CFR 0.152.
 */
package ninjaphenix.expandedstorage;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.itemgroup.FabricItemGroupBuilder;
import net.fabricmc.fabric.api.client.rendering.v1.BlockEntityRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.BuiltinItemRendererRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.event.client.ClientSpriteRegistryCallback;
import net.fabricmc.fabric.api.tag.TagFactory;
import net.fabricmc.fabric.api.transfer.v1.item.ItemStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.impl.FabricLoaderImpl;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3494;
import net.minecraft.class_4722;
import net.minecraft.class_4732;
import net.minecraft.class_5601;
import ninjaphenix.expandedstorage.ChestItemAccess;
import ninjaphenix.expandedstorage.Common;
import ninjaphenix.expandedstorage.GenericItemAccess;
import ninjaphenix.expandedstorage.Pair;
import ninjaphenix.expandedstorage.Utils;
import ninjaphenix.expandedstorage.block.AbstractChestBlock;
import ninjaphenix.expandedstorage.block.BarrelBlock;
import ninjaphenix.expandedstorage.block.ChestBlock;
import ninjaphenix.expandedstorage.block.MiniChestBlock;
import ninjaphenix.expandedstorage.block.OpenableBlock;
import ninjaphenix.expandedstorage.block.entity.BarrelBlockEntity;
import ninjaphenix.expandedstorage.block.entity.ChestBlockEntity;
import ninjaphenix.expandedstorage.block.entity.MiniChestBlockEntity;
import ninjaphenix.expandedstorage.block.entity.OldChestBlockEntity;
import ninjaphenix.expandedstorage.block.entity.extendable.OpenableBlockEntity;
import ninjaphenix.expandedstorage.block.misc.BasicLockable;
import ninjaphenix.expandedstorage.block.misc.CursedChestType;
import ninjaphenix.expandedstorage.block.misc.DoubleItemAccess;
import ninjaphenix.expandedstorage.client.ChestBlockEntityRenderer;
import ninjaphenix.expandedstorage.compat.carrier.CarrierCompat;
import ninjaphenix.expandedstorage.compat.htm.HTMLockable;
import ninjaphenix.expandedstorage.registration.BlockItemCollection;
import org.jetbrains.annotations.Nullable;

public final class Main
implements ModInitializer {
    private final FabricLoaderImpl fabricLoader = FabricLoaderImpl.INSTANCE;
    private boolean isCarrierCompatEnabled = false;

    public void onInitialize() {
        try {
            SemanticVersion version = SemanticVersion.parse((String)"1.8.0");
            this.isCarrierCompatEnabled = this.fabricLoader.getModContainer("carrier").map(it -> {
                Version patt4052$temp = it.getMetadata().getVersion();
                if (patt4052$temp instanceof SemanticVersion) {
                    SemanticVersion carrierVersion = (SemanticVersion)patt4052$temp;
                    return carrierVersion.compareTo(version) > 0;
                }
                return false;
            }).orElse(false);
        }
        catch (VersionParsingException version) {
            // empty catch block
        }
        class_1761 group = FabricItemGroupBuilder.build((class_2960)Utils.id("tab"), () -> new class_1799((class_1935)class_2378.field_11142.method_10223(Utils.id("netherite_chest"))));
        boolean isClient = this.fabricLoader.getEnvironmentType() == EnvType.CLIENT;
        Common.registerContent(GenericItemAccess::new, this.fabricLoader.isModLoaded("htm") ? HTMLockable::new : BasicLockable::new, group, isClient, this::baseRegistration, true, this::chestRegistration, (class_3494.class_5123<class_2248>)TagFactory.BLOCK.create(new class_2960("c", "wooden_chests")), class_1747::new, ChestItemAccess::new, this::oldChestRegistration, this::barrelRegistration, (class_3494.class_5123<class_2248>)TagFactory.BLOCK.create(new class_2960("c", "wooden_barrels")), this::miniChestRegistration, class_1747::new, (class_3494.class_5123<class_2248>)TagFactory.BLOCK.create(Utils.id("chest_cycle")), (class_3494.class_5123<class_2248>)TagFactory.BLOCK.create(Utils.id("mini_chest_cycle")), (class_3494.class_5123<class_2248>)TagFactory.BLOCK.create(Utils.id("mini_chest_secret_cycle")), (class_3494.class_5123<class_2248>)TagFactory.BLOCK.create(Utils.id("mini_chest_secret_cycle_2")));
    }

    private static Storage<ItemVariant> getItemAccess(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_2586 blockEntity, class_2350 context) {
        if (blockEntity instanceof OldChestBlockEntity) {
            OldChestBlockEntity entity = (OldChestBlockEntity)blockEntity;
            DoubleItemAccess access = entity.getItemAccess();
            CursedChestType type = (CursedChestType)((Object)state.method_11654(AbstractChestBlock.CURSED_CHEST_TYPE));
            class_2350 facing = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
            if (access.hasCachedAccess() || type == CursedChestType.SINGLE) {
                return (Storage)access.get();
            }
            class_2586 class_25862 = world.method_8321(pos.method_10093(AbstractChestBlock.getDirectionToAttached(type, facing)));
            if (class_25862 instanceof OldChestBlockEntity) {
                DoubleItemAccess second;
                DoubleItemAccess first;
                OldChestBlockEntity otherEntity = (OldChestBlockEntity)class_25862;
                DoubleItemAccess otherAccess = otherEntity.getItemAccess();
                if (otherAccess.hasCachedAccess()) {
                    return (Storage)otherAccess.get();
                }
                if (AbstractChestBlock.getBlockType(type) == class_4732.class_4733.field_21784) {
                    first = access;
                    second = otherAccess;
                } else {
                    first = otherAccess;
                    second = access;
                }
                first.setOther(second);
                return (Storage)first.get();
            }
        } else if (blockEntity instanceof OpenableBlockEntity) {
            OpenableBlockEntity entity = (OpenableBlockEntity)blockEntity;
            return (Storage)entity.getItemAccess().get();
        }
        return null;
    }

    private void baseRegistration(Pair<class_2960, class_1792>[] items) {
        for (Pair<class_2960, class_1792> item : items) {
            class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)item.getFirst(), (Object)item.getSecond());
        }
    }

    private void chestRegistration(BlockItemCollection<ChestBlock, class_1747> content, class_2591<ChestBlockEntity> blockEntityType) {
        for (ChestBlock chestBlock : (ChestBlock[])content.getBlocks()) {
            if (this.isCarrierCompatEnabled) {
                CarrierCompat.registerChestBlock(chestBlock);
            }
            class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)chestBlock.getBlockId(), (Object)((Object)chestBlock));
        }
        for (ChestBlock chestBlock : content.getItems()) {
            class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)((OpenableBlock)chestBlock.method_7711()).getBlockId(), (Object)((Object)chestBlock));
        }
        class_2378.method_10230((class_2378)class_2378.field_11137, (class_2960)Common.CHEST_BLOCK_TYPE, blockEntityType);
        ItemStorage.SIDED.registerForBlocks(Main::getItemAccess, content.getBlocks());
        if (this.fabricLoader.getEnvironmentType() == EnvType.CLIENT) {
            Client.registerChestTextures((ChestBlock[])content.getBlocks());
            Client.registerItemRenderers(content.getItems());
        }
    }

    private void oldChestRegistration(BlockItemCollection<AbstractChestBlock, class_1747> content, class_2591<OldChestBlockEntity> blockEntityType) {
        for (AbstractChestBlock abstractChestBlock : (AbstractChestBlock[])content.getBlocks()) {
            if (this.isCarrierCompatEnabled) {
                CarrierCompat.registerOldChestBlock(abstractChestBlock);
            }
            class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)abstractChestBlock.getBlockId(), (Object)((Object)abstractChestBlock));
        }
        for (AbstractChestBlock abstractChestBlock : content.getItems()) {
            class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)((OpenableBlock)abstractChestBlock.method_7711()).getBlockId(), (Object)((Object)abstractChestBlock));
        }
        class_2378.method_10230((class_2378)class_2378.field_11137, (class_2960)Common.OLD_CHEST_BLOCK_TYPE, blockEntityType);
        ItemStorage.SIDED.registerForBlocks(Main::getItemAccess, content.getBlocks());
    }

    private void barrelRegistration(BlockItemCollection<BarrelBlock, class_1747> content, class_2591<BarrelBlockEntity> blockEntityType) {
        boolean isClient = this.fabricLoader.getEnvironmentType() == EnvType.CLIENT;
        for (BarrelBlock barrelBlock : (BarrelBlock[])content.getBlocks()) {
            class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)barrelBlock.getBlockId(), (Object)((Object)barrelBlock));
            if (!isClient) continue;
            BlockRenderLayerMap.INSTANCE.putBlock((class_2248)barrelBlock, class_1921.method_23579());
        }
        for (BarrelBlock barrelBlock : content.getItems()) {
            class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)((OpenableBlock)barrelBlock.method_7711()).getBlockId(), (Object)((Object)barrelBlock));
        }
        class_2378.method_10230((class_2378)class_2378.field_11137, (class_2960)Common.BARREL_BLOCK_TYPE, blockEntityType);
        ItemStorage.SIDED.registerForBlocks(Main::getItemAccess, content.getBlocks());
    }

    private void miniChestRegistration(BlockItemCollection<MiniChestBlock, class_1747> content, class_2591<MiniChestBlockEntity> blockEntityType) {
        for (MiniChestBlock miniChestBlock : (MiniChestBlock[])content.getBlocks()) {
            class_2378.method_10230((class_2378)class_2378.field_11146, (class_2960)miniChestBlock.getBlockId(), (Object)((Object)miniChestBlock));
        }
        for (MiniChestBlock miniChestBlock : content.getItems()) {
            class_2378.method_10230((class_2378)class_2378.field_11142, (class_2960)((OpenableBlock)miniChestBlock.method_7711()).getBlockId(), (Object)((Object)miniChestBlock));
        }
        class_2378.method_10230((class_2378)class_2378.field_11137, (class_2960)Common.MINI_CHEST_BLOCK_TYPE, blockEntityType);
        ItemStorage.SIDED.registerForBlocks(Main::getItemAccess, content.getBlocks());
    }

    private static class Client {
        private Client() {
        }

        public static void registerChestTextures(ChestBlock[] blocks) {
            ClientSpriteRegistryCallback.event((class_2960)class_4722.field_21709).register((atlasTexture, registry) -> {
                for (class_2960 texture : Common.getChestTextures(blocks)) {
                    registry.register(texture);
                }
            });
            BlockEntityRendererRegistry.register(Common.getChestBlockEntityType(), ChestBlockEntityRenderer::new);
        }

        public static void registerItemRenderers(class_1747[] items) {
            for (class_1747 item : items) {
                ChestBlockEntity renderEntity = (ChestBlockEntity)Common.getChestBlockEntityType().method_11032(class_2338.field_10980, item.method_7711().method_9564());
                BuiltinItemRendererRegistry.INSTANCE.register((class_1935)item, (itemStack, transform, stack, source, light, overlay) -> class_310.method_1551().method_31975().method_23077((class_2586)renderEntity, stack, source, light, overlay));
            }
            EntityModelLayerRegistry.registerModelLayer((class_5601)ChestBlockEntityRenderer.SINGLE_LAYER, ChestBlockEntityRenderer::createSingleBodyLayer);
            EntityModelLayerRegistry.registerModelLayer((class_5601)ChestBlockEntityRenderer.LEFT_LAYER, ChestBlockEntityRenderer::createLeftBodyLayer);
            EntityModelLayerRegistry.registerModelLayer((class_5601)ChestBlockEntityRenderer.RIGHT_LAYER, ChestBlockEntityRenderer::createRightBodyLayer);
            EntityModelLayerRegistry.registerModelLayer((class_5601)ChestBlockEntityRenderer.TOP_LAYER, ChestBlockEntityRenderer::createTopBodyLayer);
            EntityModelLayerRegistry.registerModelLayer((class_5601)ChestBlockEntityRenderer.BOTTOM_LAYER, ChestBlockEntityRenderer::createBottomBodyLayer);
            EntityModelLayerRegistry.registerModelLayer((class_5601)ChestBlockEntityRenderer.FRONT_LAYER, ChestBlockEntityRenderer::createFrontBodyLayer);
            EntityModelLayerRegistry.registerModelLayer((class_5601)ChestBlockEntityRenderer.BACK_LAYER, ChestBlockEntityRenderer::createBackBodyLayer);
        }
    }
}

