/*
 * Decompiled with CFR 0.152.
 */
package artifacts.mixin.mixins.item.goldenhook;

import artifacts.common.init.ModComponents;
import artifacts.common.init.ModItems;
import artifacts.common.trinkets.TrinketsHelper;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    @Shadow
    @Nullable
    protected class_1657 field_6258;

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @ModifyArg(method={"dropExperience"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/ExperienceOrb;award(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/phys/Vec3;I)V"))
    private int modifyXp(int originalXp) {
        if (!TrinketsHelper.isEquipped(ModItems.GOLDEN_HOOK, (class_1309)this.field_6258)) {
            return originalXp;
        }
        double killRatio = ModComponents.ENTITY_KILL_TRACKER.maybeGet((Object)this.field_6258).map(comp -> comp.getKillRatio(this.method_5864())).orElse(0.0);
        double multiplier = 5.0 * Math.max(0.0, 2.0 * (1.0 - killRatio - 0.5));
        int experienceBonus = (int)(multiplier * (double)Math.min(10, originalXp));
        return originalXp + experienceBonus;
    }

    @Inject(method={"die"}, at={@At(value="HEAD")})
    private void addToKillTracker(class_1282 source, CallbackInfo info) {
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            ModComponents.ENTITY_KILL_TRACKER.maybeGet((Object)player).ifPresent(comp -> comp.addKilledEntityType(this.method_5864()));
        }
    }
}

