/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.components;

import artifacts.common.item.curio.belt.HeliumFlamingoItem;
import dev.onyxstudios.cca.api.v3.component.Component;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.entity.PlayerComponent;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class SwimAbilityComponent
implements PlayerComponent<Component>,
AutoSyncedComponent {
    private boolean shouldSwim;
    private boolean shouldSink;
    private boolean hasTouchedWater;
    private int swimTime;
    private final class_1657 provider;

    public SwimAbilityComponent(class_1657 provider) {
        this.provider = provider;
    }

    public boolean isSwimming() {
        return this.shouldSwim;
    }

    public boolean isSinking() {
        return this.shouldSink;
    }

    public boolean isWet() {
        return this.hasTouchedWater;
    }

    public int getSwimTime() {
        return this.swimTime;
    }

    public void setSwimming(boolean shouldSwim) {
        if (this.shouldSwim && !shouldSwim) {
            this.setSwimTime((int)((float)(-300 * this.getSwimTime()) / 150.0f));
        }
        this.shouldSwim = shouldSwim;
    }

    public void setSinking(boolean shouldSink) {
        this.shouldSink = shouldSink;
    }

    public void setWet(boolean hasTouchedWater) {
        this.hasTouchedWater = hasTouchedWater;
    }

    public void setSwimTime(int swimTime) {
        this.swimTime = swimTime;
    }

    public void readFromNbt(class_2487 tag) {
        this.setSwimming(tag.method_10577("ShouldSwim"));
        this.setSinking(tag.method_10577("ShouldSink"));
        this.setWet(tag.method_10577("IsWet"));
        this.setSwimTime(tag.method_10550("SwimTime"));
    }

    public void writeToNbt(class_2487 tag) {
        tag.method_10556("ShouldSwim", this.isSwimming());
        tag.method_10556("ShouldSink", this.isSinking());
        tag.method_10556("IsWet", this.isWet());
        tag.method_10569("SwimTime", this.getSwimTime());
    }

    public boolean shouldSyncWith(class_3222 player) {
        return player == this.provider;
    }

    public void writeSyncPacket(class_2540 buf, class_3222 recipient) {
        buf.writeBoolean(this.isSwimming());
        buf.writeBoolean(this.isSinking());
        buf.writeBoolean(this.isWet());
        buf.writeInt(this.getSwimTime());
    }

    public void applySyncPacket(class_2540 buf) {
        this.setSwimming(buf.readBoolean());
        this.setSinking(buf.readBoolean());
        this.setWet(buf.readBoolean());
        this.setSwimTime(buf.readInt());
    }

    @Environment(value=EnvType.CLIENT)
    public void syncSwimming() {
        class_2540 byteBuf = PacketByteBufs.create();
        byteBuf.writeBoolean(this.isSwimming());
        ClientPlayNetworking.send((class_2960)HeliumFlamingoItem.C2S_AIR_SWIMMING_ID, (class_2540)byteBuf);
    }
}

