/*
 * Decompiled with CFR 0.152.
 */
package artifacts.client.render.entity;

import artifacts.client.render.entity.model.MimicChestLayerModel;
import artifacts.client.render.entity.model.MimicModel;
import artifacts.common.entity.MimicEntity;
import artifacts.common.init.ModModelLayers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1059;
import net.minecraft.class_1160;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2745;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_4730;
import net.minecraft.class_5599;
import net.minecraft.class_922;

public class MimicChestLayer
extends class_3887<MimicEntity, MimicModel> {
    private final MimicChestLayerModel chestModel;
    public final class_4730 vanillaChestMaterial;
    public final List<class_4730> chestMaterials;

    public MimicChestLayer(class_3883<MimicEntity, MimicModel> entityRenderer, class_5599 modelSet) {
        super(entityRenderer);
        Calendar calendar = Calendar.getInstance();
        boolean isChristmas = calendar.get(2) + 1 == 12 && calendar.get(5) >= 24 && calendar.get(5) <= 26;
        this.chestModel = new MimicChestLayerModel(modelSet.method_32072(ModModelLayers.MIMIC_OVERLAY));
        this.chestMaterials = new ArrayList<class_4730>();
        this.vanillaChestMaterial = class_4722.method_24062(null, (class_2745)class_2745.field_12569, (boolean)isChristmas);
        if (FabricLoader.getInstance().isModLoaded("lootr")) {
            class_2960 chestLocation = new class_2960("lootr", "chest");
            this.chestMaterials.add(new class_4730(class_1059.field_5275, chestLocation));
        } else {
            if (!isChristmas && FabricLoader.getInstance().isModLoaded("quark")) {
                List<String> chestTypes = Arrays.asList("oak", "spruce", "birch", "jungle", "acacia", "dark_oak", "warped", "crimson");
                class_2960 atlas = new class_2960("textures/atlas/chest.png");
                for (String chestType : chestTypes) {
                    class_2960 chestLocation = new class_2960("quark", String.format("model/chest/%s/normal", chestType));
                    this.chestMaterials.add(new class_4730(atlas, chestLocation));
                }
            }
            this.chestMaterials.add(this.vanillaChestMaterial);
        }
    }

    public void render(class_4587 matrixStack, class_4597 buffer, int packedLight, MimicEntity mimic, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (!mimic.method_5767()) {
            matrixStack.method_22903();
            matrixStack.method_22907(class_1160.field_20703.method_23214(180.0f));
            matrixStack.method_22904(-0.5, -1.5, -0.5);
            ((MimicModel)this.method_17165()).method_17081(this.chestModel);
            this.chestModel.prepareMobModel(mimic, limbSwing, limbSwingAmount, partialTicks);
            this.chestModel.setupAnim(mimic, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            class_4588 builder = this.getChestMaterial(mimic).method_24145(buffer, class_1921::method_23576);
            this.chestModel.method_2828(matrixStack, builder, packedLight, class_922.method_23622((class_1309)mimic, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.method_22909();
        }
    }

    private class_4730 getChestMaterial(MimicEntity mimic) {
        if (this.chestMaterials.size() == 1) {
            return this.chestMaterials.get(0);
        }
        return this.chestMaterials.get((int)(Math.abs(mimic.method_5667().getMostSignificantBits()) % (long)this.chestMaterials.size()));
    }
}

