/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.registry.sync;

import com.mojang.serialization.Lifecycle;
import net.fabricmc.fabric.api.event.registry.RegistryEntryAddedCallback;
import net.fabricmc.fabric.mixin.registry.sync.AccessorRegistry;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5458;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicRegistrySync {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicRegistrySync.class);

    public static void setupSync(class_5455.class_5457 template) {
        LOGGER.debug("Setting up synchronisation of new BuiltinRegistries entries to the built-in DynamicRegistryManager");
        class_5458.field_25926.method_10220().forEach(source -> DynamicRegistrySync.setupSync(source, template));
    }

    private static <T> void setupSync(class_2378<T> source, class_5455.class_5457 template) {
        AccessorRegistry sourceAccessor = (AccessorRegistry)source;
        class_5321 sourceKey = source.method_30517();
        class_2385 target = (class_2385)template.method_30530(sourceKey);
        RegistryEntryAddedCallback.event(source).register((rawId, id, object) -> {
            LOGGER.trace("Synchronizing {} from built-in registry {} into built-in dynamic registry manager template.", (Object)id, (Object)source.method_30517());
            Lifecycle lifecycle = sourceAccessor.callGetEntryLifecycle(object);
            class_5321 entryKey = class_5321.method_29179((class_5321)sourceKey, (class_2960)id);
            target.method_10273(rawId, entryKey, object, lifecycle);
        });
    }
}

