/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world;

import me.jellysquid.mods.sodium.client.world.BiomeSeedProvider;
import me.jellysquid.mods.sodium.client.world.biome.BlockColorCache;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSection;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSectionCache;
import me.jellysquid.mods.sodium.client.world.cloned.PackedIntegerArrayExtended;
import me.jellysquid.mods.sodium.client.world.cloned.palette.ClonedPalette;
import net.fabricmc.fabric.api.rendering.data.v1.RenderAttachedBlockView;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import net.minecraft.class_310;
import net.minecraft.class_3341;
import net.minecraft.class_3508;
import net.minecraft.class_3532;
import net.minecraft.class_3568;
import net.minecraft.class_3610;
import net.minecraft.class_4076;
import net.minecraft.class_4543;
import net.minecraft.class_5742;
import net.minecraft.class_6539;
import org.jetbrains.annotations.Nullable;

public class WorldSlice
implements class_1920,
RenderAttachedBlockView {
    private static final int SECTION_BLOCK_COUNT = 4096;
    private static final int SECTION_BIOME_COUNT = 64;
    private static final int NEIGHBOR_BLOCK_RADIUS = 2;
    private static final int NEIGHBOR_CHUNK_RADIUS = class_3532.method_28139((int)2, (int)16) >> 4;
    private static final int SECTION_LENGTH = 1 + NEIGHBOR_CHUNK_RADIUS * 2;
    private static final int TABLE_LENGTH = class_3532.method_15339((int)SECTION_LENGTH);
    private static final int TABLE_BITS = Integer.bitCount(TABLE_LENGTH - 1);
    private static final int BLOCK_BITS = 4;
    private static final int BIOME_BITS = 2;
    private static final int SECTION_TABLE_ARRAY_SIZE = TABLE_LENGTH * TABLE_LENGTH * TABLE_LENGTH;
    private final class_1937 world;
    private final class_4543 biomeAccess;
    private final class_2680[][] blockStatesArrays;
    private final class_1959[][] biomeArrays;
    private ClonedChunkSection[] sections;
    private BlockColorCache biomeColors;
    private int baseX;
    private int baseY;
    private int baseZ;
    private class_4076 origin;

    public static ChunkRenderContext prepare(class_1937 world, class_4076 origin, ClonedChunkSectionCache sectionCache) {
        class_2818 chunk = world.method_8497(origin.method_10263(), origin.method_10260());
        class_2826 section = chunk.method_12006()[world.method_31603(origin.method_10264())];
        if (section == null || section.method_38292()) {
            return null;
        }
        class_3341 volume = new class_3341(origin.method_19527() - 2, origin.method_19528() - 2, origin.method_19529() - 2, origin.method_19530() + 2, origin.method_19531() + 2, origin.method_19532() + 2);
        int minChunkX = origin.method_10263() - NEIGHBOR_CHUNK_RADIUS;
        int minChunkY = origin.method_10264() - NEIGHBOR_CHUNK_RADIUS;
        int minChunkZ = origin.method_10260() - NEIGHBOR_CHUNK_RADIUS;
        int maxChunkX = origin.method_10263() + NEIGHBOR_CHUNK_RADIUS;
        int maxChunkY = origin.method_10264() + NEIGHBOR_CHUNK_RADIUS;
        int maxChunkZ = origin.method_10260() + NEIGHBOR_CHUNK_RADIUS;
        ClonedChunkSection[] sections = new ClonedChunkSection[SECTION_TABLE_ARRAY_SIZE];
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                for (int chunkY = minChunkY; chunkY <= maxChunkY; ++chunkY) {
                    sections[WorldSlice.getLocalSectionIndex((int)(chunkX - minChunkX), (int)(chunkY - minChunkY), (int)(chunkZ - minChunkZ))] = sectionCache.acquire(chunkX, chunkY, chunkZ);
                }
            }
        }
        return new ChunkRenderContext(origin, sections, volume);
    }

    public WorldSlice(class_1937 world) {
        this.world = world;
        this.biomeAccess = new class_4543(this::getStoredBiome, ((BiomeSeedProvider)this.world).getBiomeSeed());
        this.sections = new ClonedChunkSection[SECTION_TABLE_ARRAY_SIZE];
        this.blockStatesArrays = new class_2680[SECTION_TABLE_ARRAY_SIZE][4096];
        this.biomeArrays = new class_1959[SECTION_TABLE_ARRAY_SIZE][64];
    }

    public void copyData(ChunkRenderContext context) {
        this.origin = context.getOrigin();
        this.sections = context.getSections();
        this.baseX = this.origin.method_10263() - NEIGHBOR_CHUNK_RADIUS << 4;
        this.baseY = this.origin.method_10264() - NEIGHBOR_CHUNK_RADIUS << 4;
        this.baseZ = this.origin.method_10260() - NEIGHBOR_CHUNK_RADIUS << 4;
        for (int x = 0; x < SECTION_LENGTH; ++x) {
            for (int y = 0; y < SECTION_LENGTH; ++y) {
                for (int z = 0; z < SECTION_LENGTH; ++z) {
                    int idx = WorldSlice.getLocalSectionIndex(x, y, z);
                    this.unpackBlockData(this.blockStatesArrays[idx], this.sections[idx], context.getVolume());
                    this.unpackBiomeData(this.biomeArrays[idx], this.sections[idx]);
                }
            }
        }
        this.biomeColors = new BlockColorCache(this, class_310.method_1551().field_1690.field_1878);
    }

    private void unpackBlockData(class_2680[] states, ClonedChunkSection section, class_3341 box) {
        if (this.origin.equals((Object)section.getPosition())) {
            this.unpackBlockData(states, section);
        } else {
            this.unpackBlockDataSlow(states, section, box);
        }
    }

    private void unpackBlockDataSlow(class_2680[] states, ClonedChunkSection section, class_3341 box) {
        class_3508 intArray = section.getBlockData();
        ClonedPalette<class_2680> palette = section.getBlockPalette();
        class_4076 pos = section.getPosition();
        int minBlockX = Math.max(box.method_35415(), pos.method_19527());
        int maxBlockX = Math.min(box.method_35418(), pos.method_19530());
        int minBlockY = Math.max(box.method_35416(), pos.method_19528());
        int maxBlockY = Math.min(box.method_35419(), pos.method_19531());
        int minBlockZ = Math.max(box.method_35417(), pos.method_19529());
        int maxBlockZ = Math.min(box.method_35420(), pos.method_19532());
        for (int y = minBlockY; y <= maxBlockY; ++y) {
            for (int z = minBlockZ; z <= maxBlockZ; ++z) {
                for (int x = minBlockX; x <= maxBlockX; ++x) {
                    int blockIdx = WorldSlice.getLocalBlockIndex(x & 0xF, y & 0xF, z & 0xF);
                    int value = intArray.method_15211(blockIdx);
                    states[blockIdx] = palette.get(value);
                }
            }
        }
    }

    private void unpackBlockData(class_2680[] states, ClonedChunkSection section) {
        ((PackedIntegerArrayExtended)section.getBlockData()).copyUsingPalette(states, section.getBlockPalette());
    }

    private void unpackBiomeData(class_1959[] biomes, ClonedChunkSection section) {
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                for (int z = 0; z < 4; ++z) {
                    biomes[WorldSlice.getLocalBiomeIndex((int)x, (int)y, (int)z)] = section.getBiome(x, y, z);
                }
            }
        }
    }

    public class_2680 method_8320(class_2338 pos) {
        return this.getBlockState(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public class_2680 getBlockState(int x, int y, int z) {
        int relX = x - this.baseX;
        int relY = y - this.baseY;
        int relZ = z - this.baseZ;
        return this.blockStatesArrays[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4)][WorldSlice.getLocalBlockIndex(relX & 0xF, relY & 0xF, relZ & 0xF)];
    }

    public class_3610 method_8316(class_2338 pos) {
        return this.method_8320(pos).method_26227();
    }

    public float method_24852(class_2350 direction, boolean shaded) {
        return this.world.method_24852(direction, shaded);
    }

    public class_3568 method_22336() {
        return this.world.method_22336();
    }

    public class_2586 method_8321(class_2338 pos) {
        return this.getBlockEntity(pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public class_2586 getBlockEntity(int x, int y, int z) {
        int relX = x - this.baseX;
        int relY = y - this.baseY;
        int relZ = z - this.baseZ;
        return this.sections[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4)].getBlockEntity(relX & 0xF, relY & 0xF, relZ & 0xF);
    }

    public int method_23752(class_2338 pos, class_6539 resolver) {
        return this.biomeColors.getColor(resolver, pos.method_10263(), pos.method_10264(), pos.method_10260());
    }

    public int method_8314(class_1944 type, class_2338 pos) {
        int relX = pos.method_10263() - this.baseX;
        int relY = pos.method_10264() - this.baseY;
        int relZ = pos.method_10260() - this.baseZ;
        return this.sections[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4)].getLightLevel(type, relX & 0xF, relY & 0xF, relZ & 0xF);
    }

    public class_4076 getOrigin() {
        return this.origin;
    }

    public int method_31605() {
        return this.world.method_31605();
    }

    public int method_31607() {
        return this.world.method_31607();
    }

    @Nullable
    public Object getBlockEntityRenderAttachment(class_2338 pos) {
        int relX = pos.method_10263() - this.baseX;
        int relY = pos.method_10264() - this.baseY;
        int relZ = pos.method_10260() - this.baseZ;
        return this.sections[WorldSlice.getLocalSectionIndex(relX >> 4, relY >> 4, relZ >> 4)].getBlockEntityRenderAttachment(relX & 0xF, relY & 0xF, relZ & 0xF);
    }

    private class_1959 getStoredBiome(int biomeX, int biomeY, int biomeZ) {
        int chunkX = class_5742.method_33101((int)biomeX) - this.baseX >> 4;
        int chunkY = class_5742.method_33101((int)biomeY) - this.baseY >> 4;
        int chunkZ = class_5742.method_33101((int)biomeZ) - this.baseZ >> 4;
        return this.biomeArrays[WorldSlice.getLocalSectionIndex(chunkX, chunkY, chunkZ)][WorldSlice.getLocalBiomeIndex(biomeX & 3, biomeY & 3, biomeZ & 3)];
    }

    public class_4543 getBiomeAccess() {
        return this.biomeAccess;
    }

    private static int getLocalBiomeIndex(int x, int y, int z) {
        return y << 2 << 2 | z << 2 | x;
    }

    public static int getLocalBlockIndex(int x, int y, int z) {
        return y << 4 << 4 | z << 4 | x;
    }

    public static int getLocalSectionIndex(int x, int y, int z) {
        return y << TABLE_BITS << TABLE_BITS | z << TABLE_BITS | x;
    }
}

