/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.creaturesofthesnow.liukrastapi;

public class AnimationAPI {
    public static float easeInSine(float fromTime, float toTime, float size, float time) {
        float exit = 0.0f;
        float w = toTime - fromTime;
        float x = time - fromTime;
        if (x >= 0.0f && x <= w) {
            float eq = time / w - 1.0f - fromTime / w;
            exit = eq * eq;
        }
        if (x > w) {
            return size;
        }
        if (x >= 0.0f) {
            return -exit * size + size;
        }
        return 0.0f;
    }

    public static float easeOutSine(float fromTime, float toTime, float size, float time) {
        float exit = 0.0f;
        float w = toTime - fromTime;
        float x = time - fromTime;
        if (x >= 0.0f && x <= w) {
            float eq = time / w - fromTime / w;
            exit = eq * eq;
        }
        if (x > w) {
            return size;
        }
        if (x >= 0.0f) {
            return exit * size;
        }
        return 0.0f;
    }

    public static float easeInOutSine(float fromTime, float toTime, float size, float time) {
        float exit = 0.0f;
        float w = toTime - fromTime;
        float x = time - fromTime;
        if (x >= 0.0f && x <= w) {
            exit = -((float)Math.cos((double)(x / w) * Math.PI)) / 2.0f + 0.5f;
        }
        if (x > w) {
            return size;
        }
        if (x >= 0.0f) {
            return exit * size;
        }
        return 0.0f;
    }

    public static float easeInBack(float fromTime, float toTime, float size, float time, float multiplier) {
        float exit = 0.0f;
        float w = toTime - fromTime;
        float x = time - fromTime;
        float c3 = multiplier + 1.0f;
        if (x >= 0.0f && x <= w) {
            exit = c3 * (x / w) * (x / w) * (x / w) - multiplier * (x / w) * (x / w);
        }
        if (x > w) {
            return size;
        }
        if (x >= 0.0f) {
            return exit * size;
        }
        return 0.0f;
    }

    public static float easeInBack(float fromTime, float toTime, float size, float time) {
        return AnimationAPI.easeInBack(fromTime, toTime, size, time, 1.5f);
    }

    public static float easeOutBack(float fromTime, float toTime, float size, float time, float multiplier) {
        float exit = 0.0f;
        float w = toTime - fromTime;
        float x = time - fromTime;
        float c3 = multiplier + 1.0f;
        if (x >= 0.0f && x <= w) {
            exit = 1.0f + c3 * (float)Math.pow(x / w - 1.0f, 3.0) + multiplier * (float)Math.pow(x / w - 1.0f, 2.0);
        }
        if (x > w) {
            return size;
        }
        if (x >= 0.0f) {
            return exit * size;
        }
        return 0.0f;
    }

    public static float easeOutBack(float fromTime, float toTime, float size, float time) {
        return AnimationAPI.easeOutBack(fromTime, toTime, size, time, 1.5f);
    }

    public static float easeInOutBack(float fromTime, float toTime, float size, float time, float multiplier) {
        float exit = 0.0f;
        float w = toTime - fromTime;
        float x = time - fromTime;
        float c2 = multiplier * 1.525f;
        if (x >= 0.0f && x <= w) {
            exit = (double)x < 0.5 * (double)w ? (float)Math.pow(2.0f * x / w, 2.0) * ((c2 + 1.0f) * 2.0f * x / w - c2) / 2.0f : ((float)Math.pow(2.0f * (x / w) - 2.0f, 2.0) * ((c2 + 1.0f) * (x / w * 2.0f - 2.0f) + c2) + 2.0f) / 2.0f;
        }
        if (x > w) {
            return size;
        }
        if (x >= 0.0f) {
            return exit * size;
        }
        return 0.0f;
    }

    public static float easeInOutBack(float fromTime, float toTime, float size, float time) {
        return AnimationAPI.easeInOutBack(fromTime, toTime, size, time, 1.5f);
    }

    public static float easeInElastic(float fromTime, float toTime, float size, float time, int amount) {
        float exit = 0.0f;
        float w = toTime - fromTime;
        float x = time - fromTime;
        int b = 2 * amount - 1;
        if (x >= 0.0f && x <= w) {
            exit = (float)Math.cos(Math.PI * 2 * (double)b * (double)(x / w)) * (x / w);
        }
        if (x > w) {
            return size;
        }
        if (x >= 0.0f) {
            return exit * size;
        }
        return 0.0f;
    }

    public static float easeInElastic(float fromTime, float toTime, float size, float time) {
        int w = (int)(toTime - fromTime) / 10;
        return AnimationAPI.easeInElastic(fromTime, toTime, size, time, w);
    }

    public static float easeOutElastic(float fromTime, float toTime, float size, float time, int amount) {
        float exit = 0.0f;
        float w = toTime - fromTime;
        float x = time - fromTime;
        int b = 2 * amount - 1;
        if (x >= 0.0f && x <= w) {
            exit = (float)(-Math.cos(Math.PI * 2 * (double)b * (double)(x / w)) * (double)(1.0f - x / w) + 1.0);
        }
        if (x > w) {
            return size;
        }
        if (x >= 0.0f) {
            return exit * size;
        }
        return 0.0f;
    }

    public static float easeOutElastic(float fromTime, float toTime, float size, float time) {
        int w = (int)(toTime - fromTime) / 10;
        return AnimationAPI.easeOutElastic(fromTime, toTime, size, time, w);
    }

    public static float easeInOutElastic(float fromTime, float toTime, float size, float time, int amount) {
        float exit = 0.0f;
        float w = toTime - fromTime;
        float x = time - fromTime;
        int b = 2 * amount - 1;
        if (x >= 0.0f && x <= w) {
            exit = (float)(Math.sin(Math.PI * 2 * (double)b * (double)(x / w)) * Math.sin(Math.PI * (double)(x / w))) + x / w;
        }
        if (x > w) {
            return size;
        }
        if (x >= 0.0f) {
            return exit * size;
        }
        return 0.0f;
    }

    public static float easeInOutElastic(float fromTime, float toTime, float size, float time) {
        int w = (int)(toTime - fromTime) / 10;
        return AnimationAPI.easeInOutElastic(fromTime, toTime, size, time, w);
    }

    public static float easeInBounce(float fromTime, float toTime, float size, float time, int amount) {
        float exit = 0.0f;
        float w = toTime - fromTime;
        float x = time - fromTime;
        int b = 2 * amount - 1;
        if (x >= 0.0f && x <= w) {
            exit = (float)Math.abs(Math.cos(Math.PI * 2 * (double)b * (double)(x / w)) * (double)(x / w));
        }
        if (x > w) {
            return size;
        }
        if (x >= 0.0f) {
            return exit * size;
        }
        return 0.0f;
    }

    public static float easeInBounce(float fromTime, float toTime, float size, float time) {
        int w = (int)(toTime - fromTime) / 10;
        return AnimationAPI.easeInBounce(fromTime, toTime, size, time, w);
    }

    public static float easeOutBounce(float fromTime, float toTime, float size, float time, int amount) {
        float exit = 0.0f;
        float w = toTime - fromTime;
        float x = time - fromTime;
        int b = 2 * amount - 1;
        if (x >= 0.0f && x <= w) {
            exit = (float)(-Math.abs(Math.cos(Math.PI * 2 * (double)b * (double)(x / w)) * (double)(1.0f - x / w))) + 1.0f;
        }
        if (x > w) {
            return size;
        }
        if (x >= 0.0f) {
            return exit * size;
        }
        return 0.0f;
    }

    public static float easeOutBounce(float fromTime, float toTime, float size, float time) {
        int w = (int)(toTime - fromTime) / 10;
        return AnimationAPI.easeOutBounce(fromTime, toTime, size, time, w);
    }

    public static float easeInOutBounce(float fromTime, float toTime, float size, float time, int amount) {
        float exit = 0.0f;
        float w = toTime - fromTime;
        float x = time - fromTime;
        int b = 2 * amount - 1;
        if (x >= 0.0f && x <= w) {
            exit = (float)Math.abs(Math.sin(Math.PI * 2 * (double)b * (double)(x / w)) * Math.sin(Math.PI * (double)(x / w))) + x / w;
        }
        if (x > w) {
            return size;
        }
        if (x >= 0.0f) {
            return exit * size;
        }
        return 0.0f;
    }

    public static float linear(float fromTime, float toTime, float size, float time) {
        float exit = 0.0f;
        float w = toTime - fromTime;
        float x = time - fromTime;
        if (x >= 0.0f && x <= w) {
            exit = x / w;
        }
        if (x > w) {
            return size;
        }
        if (x >= 0.0f) {
            return -exit * size;
        }
        return 0.0f;
    }

    public static float loopTime(float time, float size) {
        return time - size * (float)Math.floor(time / size);
    }

    public static float boomerangTime(float time, float size) {
        float eq1 = time - 2.0f * size * (float)Math.floor(time / (size * 2.0f));
        float eq2 = -time + 2.0f * size * (float)Math.floor(time / (size * 2.0f)) + 2.0f * size;
        if (eq1 >= 0.0f && eq1 <= size) {
            return eq1;
        }
        return eq2;
    }

    public static float animationTimer(float time, float from, float to) {
        float x = time - from;
        float w = to - from;
        if (x >= 0.0f && x <= w) {
            return x;
        }
        return 0.0f;
    }

    public static float max(float input, float max) {
        if (input < max) {
            return input;
        }
        return max;
    }
}

