/*
 * Decompiled with CFR 0.152.
 */
package draylar.gateofbabylon.entity;

import draylar.gateofbabylon.item.BoomerangItem;
import draylar.gateofbabylon.mixin.AbstractButtonBlockAccessor;
import draylar.gateofbabylon.mixin.BlockSoundGroupAccessor;
import draylar.gateofbabylon.registry.GOBDamageSources;
import draylar.gateofbabylon.registry.GOBEntities;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1313;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2269;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2401;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2604;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import org.jetbrains.annotations.NotNull;

public class BoomerangEntity
extends class_1297 {
    private static final String OWNER_KEY = "Owner";
    private static final class_2940<Optional<UUID>> OWNER = class_2945.method_12791(BoomerangEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<class_1799> STACK = class_2945.method_12791(BoomerangEntity.class, (class_2941)class_2943.field_13322);
    private int lastLeverAge = 0;
    private boolean isTemporary = false;
    private boolean hasTemporaryReturned = false;
    private class_243 temporaryOrigin = class_243.field_1353;

    public BoomerangEntity(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Environment(value=EnvType.CLIENT)
    public BoomerangEntity(class_1937 world, double x, double y, double z) {
        super(GOBEntities.BOOMERANG, world);
        this.method_30634(x, y, z);
        this.method_18003(x, y, z);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.field_6002.field_9236) {
            if (this.field_6012 % 5 == 0) {
                this.field_6002.method_8465(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14625, class_3419.field_15248, 0.5f, 0.5f);
            }
            this.field_6007 = true;
            this.field_6037 = true;
            this.method_5784(class_1313.field_6308, this.method_18798());
            if (this.field_6012 % 20 >= 15) {
                int t = 20 - this.field_6012 % 20;
                double modifier = (float)t / 5.0f;
                this.method_18799(this.method_18798().method_1021(modifier));
            }
            if (this.field_6012 % 20 == 0) {
                if (this.getOwner().isPresent()) {
                    class_1657 owner = this.field_6002.method_18470(this.getOwner().get());
                    if (owner != null) {
                        class_243 ownerPos = owner.method_19538();
                        ownerPos = ownerPos.method_18805(1.0, 0.0, 1.0).method_1031(0.0, owner.method_23320() - 0.2, 0.0);
                        class_243 thisPos = this.method_19538();
                        class_243 difference = ownerPos.method_1020(thisPos);
                        this.method_18799(difference.method_1029());
                    } else {
                        this.method_5650(class_1297.class_5529.field_26999);
                    }
                } else if (this.isTemporary) {
                    if (!this.hasTemporaryReturned) {
                        class_243 thisPos = this.method_19538();
                        class_243 difference = this.temporaryOrigin.method_1020(thisPos);
                        this.method_18799(difference.method_1029());
                        this.hasTemporaryReturned = true;
                    } else {
                        this.method_5650(class_1297.class_5529.field_26999);
                    }
                } else {
                    this.method_5650(class_1297.class_5529.field_26999);
                }
            }
            if (this.field_6012 > 200) {
                this.method_5650(class_1297.class_5529.field_26999);
            }
        }
        if (!this.field_6002.field_9236) {
            class_2248 class_22482;
            class_2248 class_22483;
            this.field_6002.method_8390(class_1309.class, new class_238(this.method_23317() - (double)0.4f, this.method_23318() - (double)0.05f, this.method_23321() - (double)0.4f, this.method_23317() + (double)0.4f, this.method_23318() + (double)0.05f, this.method_23321() + (double)0.4f), entity -> true).forEach(this::onCollision);
            class_2338 insidePos = this.method_24515();
            class_2338 towardsPos = new class_2338(this.method_19538().method_1019(this.method_18798().method_1029()));
            class_2680 insideState = this.field_6002.method_8320(this.method_24515());
            class_2680 towardsState = this.field_6002.method_8320(towardsPos);
            if (!towardsState.method_26215() && towardsState.method_26227().method_15769()) {
                this.field_6002.method_8465(null, this.method_23317(), this.method_23318(), this.method_23321(), ((BlockSoundGroupAccessor)towardsState.method_26231()).getHitSound(), class_3419.field_15248, 0.5f, 1.0f);
            }
            if ((class_22483 = insideState.method_26204()) instanceof class_2269) {
                class_2269 button = (class_2269)class_22483;
                if (!((Boolean)insideState.method_11654((class_2769)class_2269.field_10729)).booleanValue()) {
                    button.method_21845(insideState, this.field_6002, insidePos);
                    this.field_6002.method_8396(null, insidePos, ((AbstractButtonBlockAccessor)button).callGetClickSound(true), class_3419.field_15245, 0.3f, 0.6f);
                    this.field_6002.method_32888((class_1297)this, class_5712.field_28174, insidePos);
                }
            }
            int timeSinceLastLever = this.field_6012 - this.lastLeverAge;
            if ((this.lastLeverAge == 0 || timeSinceLastLever >= 20) && (class_22482 = insideState.method_26204()) instanceof class_2401) {
                class_2401 lever = (class_2401)class_22482;
                lever.method_21846(insideState, this.field_6002, insidePos);
                float f = (Boolean)insideState.method_11654((class_2769)class_2401.field_11265) != false ? 0.6f : 0.5f;
                this.field_6002.method_8396(null, insidePos, class_3417.field_14962, class_3419.field_15245, 0.3f, f);
                this.field_6002.method_32888((class_1297)this, (Boolean)insideState.method_11654((class_2769)class_2401.field_11265) != false ? class_5712.field_28170 : class_5712.field_28171, insidePos);
                this.lastLeverAge = this.field_6012;
            }
            if (insideState.method_26207().method_15800() && !insideState.method_26215() && insideState.method_26227().method_15769()) {
                this.field_6002.method_22352(insidePos, true);
            }
        }
    }

    public void onCollision(class_1309 entity) {
        class_1799 stack = this.getStack();
        if (this.getOwner().isPresent() && entity.method_5667().equals(this.getOwner().get()) && this.field_6012 > 3) {
            this.field_6002.method_8465(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.25f, 1.0f);
            this.method_5650(class_1297.class_5529.field_26999);
            return;
        }
        if (this.getOwner().isPresent() && entity.method_5667().equals(this.getOwner().get())) {
            return;
        }
        if (stack.method_7909() instanceof BoomerangItem) {
            boolean dmg;
            class_1657 player;
            this.field_6002.method_8465(null, this.method_23317(), this.method_23318(), this.method_23321(), class_3417.field_14625, class_3419.field_15248, 0.5f, 1.0f);
            float baseDamage = ((BoomerangItem)stack.method_7909()).method_8022().method_8028();
            if (this.getOwner().isPresent() && (player = this.field_6002.method_18470(this.getOwner().get())) != null) {
                baseDamage = (float)player.method_26825(class_5134.field_23721);
            }
            float attackDamage = baseDamage + class_1890.method_8218((class_1799)stack, (class_1310)entity.method_6046());
            if (this.getOwner().isPresent() && this.field_6002.method_18470(this.getOwner().get()) != null) {
                dmg = entity.method_5643((class_1282)GOBDamageSources.createBoomerangSource(this.field_6002.method_18470(this.getOwner().get())), attackDamage);
                stack.method_7970(1, this.field_5974, (class_3222)this.field_6002.method_18470(this.getOwner().get()));
            } else {
                dmg = entity.method_5643(class_1282.field_5869, attackDamage);
            }
            int level = class_1890.method_8225((class_1887)class_1893.field_9124, (class_1799)this.getStack());
            if (level > 0) {
                entity.method_5639(4 * level);
            }
            if (this.getOwner().isEmpty() || !entity.method_5667().equals(this.getOwner().get())) {
                int piercing = class_1890.method_8225((class_1887)class_1893.field_9132, (class_1799)this.getStack());
                if (piercing == 0 && dmg) {
                    entity.method_18799(this.method_18798());
                }
                if (piercing == 0) {
                    class_1657 owner;
                    class_1657 class_16572 = owner = this.getOwner().isEmpty() ? null : this.field_6002.method_18470(this.getOwner().get());
                    if (owner != null) {
                        class_243 ownerPos = owner.method_19538();
                        ownerPos = ownerPos.method_18805(1.0, 0.0, 1.0).method_1031(0.0, owner.method_23320() - 0.2, 0.0);
                        class_243 thisPos = this.method_19538();
                        class_243 difference = ownerPos.method_1020(thisPos);
                        this.method_18799(difference.method_1029());
                    } else {
                        this.method_5650(class_1297.class_5529.field_26999);
                    }
                }
            }
        }
    }

    public void method_5693() {
        this.field_6011.method_12784(OWNER, Optional.empty());
        this.field_6011.method_12784(STACK, (Object)class_1799.field_8037);
    }

    protected void method_5749(class_2487 nbt) {
    }

    protected void method_5652(class_2487 nbt) {
    }

    public class_2596<?> method_18002() {
        return new class_2604((class_1297)this);
    }

    public void setStack(class_1799 stack) {
        this.field_6011.method_12778(STACK, (Object)stack);
    }

    public class_1799 getStack() {
        return (class_1799)this.field_6011.method_12789(STACK);
    }

    public void setOwner(@NotNull class_1657 player) {
        this.field_6011.method_12778(OWNER, Optional.of(player.method_5667()));
    }

    @NotNull
    public Optional<UUID> getOwner() {
        return (Optional)this.field_6011.method_12789(OWNER);
    }

    public Optional<class_1657> getPlayerOwner() {
        return this.getOwner().isPresent() && this.field_6002.method_18470(this.getOwner().get()) != null ? Optional.ofNullable(this.field_6002.method_18470(this.getOwner().get())) : Optional.empty();
    }

    public void setTemporary() {
        this.isTemporary = true;
        this.temporaryOrigin = this.method_19538();
    }
}

